/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport.mqtt;

import com.microsoft.azure.sdk.iot.device.Message;
import com.microsoft.azure.sdk.iot.device.MessageType;
import com.microsoft.azure.sdk.iot.device.transport.IotHubTransportMessage;
import com.microsoft.azure.sdk.iot.device.transport.TransportException;
import com.microsoft.azure.sdk.iot.device.transport.mqtt.Mqtt;
import com.microsoft.azure.sdk.iot.device.twin.DeviceOperations;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.regex.Pattern;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MqttTwin
extends Mqtt {
    private static final Logger log = LoggerFactory.getLogger(MqttTwin.class);
    private final String subscribeTopic;
    private final Map<String, DeviceOperations> requestMap = new HashMap<String, DeviceOperations>();
    private boolean isStarted = false;
    private static final String BACKSLASH = "/";
    private static final String AND = "&";
    private static final String QUESTION = "?";
    private static final String POUND = "#";
    private static final String TWIN = "$iothub/twin";
    private static final String GET = "$iothub/twin/GET";
    private static final String RES = "$iothub/twin/res";
    private static final String PATCH = "$iothub/twin/PATCH";
    private static final String PROPERTIES = "properties";
    private static final String DESIRED = "desired";
    private static final String REPORTED = "reported";
    private static final String REQ_ID = "?$rid=";
    private static final String VERSION = "$version=";
    private static final int STATUS_TOKEN = 3;
    private static final int REQID_TOKEN = 4;
    private static final int VERSION_TOKEN = 4;
    private static final int PATCH_VERSION_TOKEN = 5;

    public MqttTwin(String deviceId, MqttConnectOptions connectOptions, Map<Integer, Message> unacknowledgedSentMessages, Queue<Pair<String, MqttMessage>> receivedMessages) {
        super(null, deviceId, connectOptions, unacknowledgedSentMessages, receivedMessages);
        this.subscribeTopic = "$iothub/twin/res/#";
    }

    public void start() throws TransportException {
        if (!this.isStarted) {
            this.subscribe(this.subscribeTopic);
            this.isStarted = true;
        }
    }

    public void stop() {
        this.isStarted = false;
        if (!this.requestMap.isEmpty()) {
            log.trace("Pending {} responses from IotHub yet unsubscribed", (Object)this.requestMap.size());
        }
    }

    private String buildTopic(IotHubTransportMessage message) {
        StringBuilder topic = new StringBuilder();
        switch (message.getDeviceOperationType()) {
            case DEVICE_OPERATION_TWIN_GET_REQUEST: {
                topic.append(GET);
                String reqid = message.getRequestId();
                if (reqid != null && reqid.length() > 0) {
                    topic.append(BACKSLASH);
                    topic.append(REQ_ID);
                    topic.append(reqid);
                    break;
                }
                throw new IllegalArgumentException("Request Id is Mandatory");
            }
            case DEVICE_OPERATION_TWIN_UPDATE_REPORTED_PROPERTIES_REQUEST: {
                topic.append(PATCH);
                topic.append(BACKSLASH);
                topic.append(PROPERTIES);
                topic.append(BACKSLASH);
                topic.append(REPORTED);
                String reqid = message.getRequestId();
                if (reqid == null || reqid.length() <= 0) {
                    throw new IllegalArgumentException("Request Id is Mandatory");
                }
                topic.append(BACKSLASH);
                topic.append(REQ_ID);
                topic.append(message.getRequestId());
                Integer version = message.getVersion();
                if (version == null) break;
                topic.append(AND);
                topic.append(VERSION);
                topic.append(version);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Device Twin Operation is not supported - " + (Object)((Object)message.getDeviceOperationType()));
            }
        }
        return topic.toString();
    }

    public void send(IotHubTransportMessage message) throws TransportException {
        if (message == null || message.getBytes() == null) {
            throw new IllegalArgumentException("Message cannot be null");
        }
        if (!this.isStarted) {
            throw new IllegalStateException("Start device twin before using it");
        }
        if (message.getMessageType() != MessageType.DEVICE_TWIN) {
            return;
        }
        this.requestMap.put(message.getRequestId(), message.getDeviceOperationType());
        if (message.getDeviceOperationType() == DeviceOperations.DEVICE_OPERATION_TWIN_SUBSCRIBE_DESIRED_PROPERTIES_REQUEST) {
            String subscribeTopic = "$iothub/twin/PATCH/properties/desired/#";
            this.subscribe(subscribeTopic);
        } else {
            String publishTopic = this.buildTopic(message);
            this.publish(publishTopic, message);
        }
    }

    private String getStatus(String token) {
        if (token != null && token.matches("\\d{3}")) {
            return token;
        }
        throw new IllegalArgumentException("Status could not be parsed");
    }

    private String getRequestId(String token) {
        String reqId = null;
        if (token.contains(REQ_ID)) {
            int startIndex = token.indexOf(REQ_ID) + REQ_ID.length();
            int endIndex = token.length();
            if (token.contains(VERSION)) {
                endIndex = token.indexOf(VERSION) - 1;
            }
            reqId = token.substring(startIndex, endIndex);
        }
        return reqId;
    }

    private String getVersion(String token) {
        String version = null;
        if (token.contains(VERSION)) {
            int startIndex = token.indexOf(VERSION) + VERSION.length();
            int endIndex = token.length();
            version = token.substring(startIndex, endIndex);
        }
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IotHubTransportMessage receive() {
        Object object = this.receivedMessagesLock;
        synchronized (object) {
            String topic;
            IotHubTransportMessage message = null;
            Pair messagePair = (Pair)this.receivedMessages.peek();
            if (messagePair != null && (topic = (String)messagePair.getKey()) != null && topic.length() > 0 && topic.length() > TWIN.length() && topic.startsWith(TWIN)) {
                MqttMessage mqttMessage = (MqttMessage)messagePair.getValue();
                byte[] data = mqttMessage.getPayload();
                this.receivedMessages.poll();
                if (topic.length() > RES.length() && topic.startsWith(RES)) {
                    String version;
                    String[] topicTokens = topic.split(Pattern.quote(BACKSLASH));
                    message = data != null && data.length > 0 ? new IotHubTransportMessage(data, MessageType.DEVICE_TWIN) : new IotHubTransportMessage(new byte[0], MessageType.DEVICE_TWIN);
                    message.setQualityOfService(mqttMessage.getQos());
                    message.setDeviceOperationType(DeviceOperations.DEVICE_OPERATION_UNKNOWN);
                    if (topicTokens.length > 3) {
                        message.setStatus(this.getStatus(topicTokens[3]));
                    } else {
                        log.warn("Message received without status");
                    }
                    if (topicTokens.length > 4) {
                        String requestId = this.getRequestId(topicTokens[4]);
                        message.setRequestId(requestId);
                        message.setCorrelationId(requestId);
                        if (this.requestMap.containsKey(requestId)) {
                            switch (this.requestMap.remove(requestId)) {
                                case DEVICE_OPERATION_TWIN_GET_REQUEST: {
                                    message.setDeviceOperationType(DeviceOperations.DEVICE_OPERATION_TWIN_GET_RESPONSE);
                                    break;
                                }
                                case DEVICE_OPERATION_TWIN_UPDATE_REPORTED_PROPERTIES_REQUEST: {
                                    message.setDeviceOperationType(DeviceOperations.DEVICE_OPERATION_TWIN_UPDATE_REPORTED_PROPERTIES_RESPONSE);
                                    break;
                                }
                                default: {
                                    message.setDeviceOperationType(DeviceOperations.DEVICE_OPERATION_UNKNOWN);
                                    break;
                                }
                            }
                        } else {
                            log.warn("Request ID cannot be null");
                        }
                    }
                    if (topicTokens.length > 4 && (version = this.getVersion(topicTokens[4])) != null && !version.isEmpty()) {
                        message.setVersion(Integer.parseInt(version));
                    }
                } else if (topic.length() > PATCH.length() && topic.startsWith(PATCH) && topic.startsWith("$iothub/twin/PATCH/properties/desired")) {
                    String[] topicTokens;
                    if (data != null) {
                        message = new IotHubTransportMessage(data, MessageType.DEVICE_TWIN);
                        message.setDeviceOperationType(DeviceOperations.DEVICE_OPERATION_TWIN_SUBSCRIBE_DESIRED_PROPERTIES_RESPONSE);
                        message.setQualityOfService(mqttMessage.getQos());
                    }
                    if ((topicTokens = topic.split(Pattern.quote(BACKSLASH))).length > 5 && message != null) {
                        message.setVersion(Integer.parseInt(this.getVersion(topicTokens[5])));
                    }
                }
            }
            return message;
        }
    }
}

