/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport.amqps;

import com.microsoft.azure.sdk.iot.device.IotHubStatusCode;
import com.microsoft.azure.sdk.iot.device.transport.IotHubServiceException;
import com.microsoft.azure.sdk.iot.device.transport.TransportException;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsCbsSessionHandler;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsSessionHandler;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AuthenticationMessageCallback;
import java.util.Iterator;
import org.apache.qpid.proton.amqp.messaging.Accepted;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.engine.BaseHandler;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Handler;
import org.apache.qpid.proton.reactor.Reactor;
import org.apache.qpid.proton.reactor.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AmqpsSasTokenRenewalHandler
extends BaseHandler
implements AuthenticationMessageCallback {
    private static final Logger log = LoggerFactory.getLogger(AmqpsSasTokenRenewalHandler.class);
    private static final int RETRY_INTERVAL_MILLISECONDS = 5000;
    private final AmqpsCbsSessionHandler amqpsCbsSessionHandler;
    final AmqpsSessionHandler amqpsSessionHandler;
    private boolean isClosed;
    private AmqpsSasTokenRenewalHandler nextToAuthenticate;
    private Task scheduledTask;

    public AmqpsSasTokenRenewalHandler(AmqpsCbsSessionHandler amqpsCbsSessionHandler, AmqpsSessionHandler amqpsSessionHandler) {
        this.amqpsCbsSessionHandler = amqpsCbsSessionHandler;
        this.amqpsSessionHandler = amqpsSessionHandler;
        this.isClosed = false;
    }

    public void setNextToAuthenticate(AmqpsSasTokenRenewalHandler nextToAuthenticate) {
        this.nextToAuthenticate = nextToAuthenticate;
    }

    public void onTimerTask(Event event) {
        if (this.amqpsSessionHandler != null) {
            log.trace("onTimerTask fired for sas token renewal handler for device {}", (Object)this.amqpsSessionHandler.getDeviceId());
            if (!this.isClosed) {
                try {
                    this.sendAuthenticationMessage(event.getReactor());
                }
                catch (TransportException e) {
                    log.error("Failed to send the CBS authentication message to authenticate device {}, trying to send again in {} milliseconds", (Object)this.amqpsSessionHandler.getDeviceId(), (Object)5000);
                    this.scheduleRenewalRetry(event.getReactor());
                }
            }
        }
    }

    public void sendAuthenticationMessage(Reactor reactor) throws TransportException {
        if (!this.isClosed) {
            log.debug("Sending authentication message for device {}", (Object)this.amqpsSessionHandler.getDeviceId());
            this.amqpsCbsSessionHandler.sendAuthenticationMessage(this.amqpsSessionHandler.getClientConfiguration(), this);
            this.scheduleRenewal(reactor);
        }
    }

    @Override
    public DeliveryState handleAuthenticationResponseMessage(int status, String description, Reactor reactor) {
        try {
            if (this.nextToAuthenticate != null) {
                this.nextToAuthenticate.sendAuthenticationMessage(reactor);
                this.nextToAuthenticate = null;
            }
        }
        catch (TransportException e) {
            log.error("Failed to send authentication message for device {}", (Object)this.nextToAuthenticate.amqpsSessionHandler.getDeviceId(), (Object)e);
        }
        if (status == 200) {
            log.debug("CBS message authentication succeeded for device {}", (Object)this.amqpsSessionHandler.getDeviceId());
            this.amqpsSessionHandler.openLinks();
        } else {
            IotHubServiceException exception = IotHubStatusCode.getConnectionStatusException(IotHubStatusCode.getIotHubStatusCode(status), description);
            this.amqpsCbsSessionHandler.onAuthenticationFailed(this.amqpsSessionHandler.getDeviceId(), exception);
        }
        return Accepted.getInstance();
    }

    public void close() {
        this.isClosed = true;
        this.clearHandlers();
    }

    private void scheduleRenewal(Reactor reactor) {
        int sasTokenRenewalPeriod = this.amqpsSessionHandler.getClientConfiguration().getSasTokenAuthentication().getMillisecondsBeforeProactiveRenewal();
        log.trace("Scheduling proactive sas token renewal for device {} in {} milliseconds", (Object)this.amqpsSessionHandler.getDeviceId(), (Object)sasTokenRenewalPeriod);
        this.scheduledTask = reactor.schedule(sasTokenRenewalPeriod, (Handler)this);
    }

    private void scheduleRenewalRetry(Reactor reactor) {
        this.scheduledTask = reactor.schedule(5000, (Handler)this);
    }

    private void clearHandlers() {
        if (this.scheduledTask != null) {
            this.scheduledTask.cancel();
            this.scheduledTask.attachments().clear();
        }
        Iterator childrenIterator = this.children();
        while (childrenIterator.hasNext()) {
            childrenIterator.next();
            childrenIterator.remove();
        }
    }
}

