/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.exceptions;

import com.microsoft.azure.sdk.iot.device.IotHubStatusCode;
import com.microsoft.azure.sdk.iot.device.exceptions.IotHubClientException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class MultiplexingClientRegistrationException
extends IotHubClientException {
    private Map<String, Exception> registrationExceptions = new HashMap<String, Exception>();

    public MultiplexingClientRegistrationException() {
        super(IotHubStatusCode.ERROR);
    }

    public MultiplexingClientRegistrationException(String message) {
        super(IotHubStatusCode.ERROR, message);
    }

    public MultiplexingClientRegistrationException(String message, Exception cause) {
        super(IotHubStatusCode.ERROR, message, cause);
    }

    public MultiplexingClientRegistrationException(Exception cause) {
        super(IotHubStatusCode.ERROR, "", cause);
    }

    public void addRegistrationException(String deviceId, Exception registrationException) {
        Objects.requireNonNull(registrationException, "registrationException cannot be null");
        if (deviceId == null || deviceId.isEmpty()) {
            throw new IllegalArgumentException("DeviceId cannot be null or empty");
        }
        this.registrationExceptions.put(deviceId, registrationException);
    }

    public Map<String, Exception> getRegistrationExceptions() {
        return this.registrationExceptions;
    }

    public void setRegistrationExceptionsMap(Map<String, Exception> registrationExceptions) {
        this.registrationExceptions = registrationExceptions;
    }
}

