/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device;

import com.microsoft.azure.sdk.iot.device.ClientConfiguration;
import com.microsoft.azure.sdk.iot.device.DeviceClient;
import com.microsoft.azure.sdk.iot.device.DeviceIO;
import com.microsoft.azure.sdk.iot.device.IotHubClientProtocol;
import com.microsoft.azure.sdk.iot.device.IotHubConnectionStatusChangeCallback;
import com.microsoft.azure.sdk.iot.device.MultiplexingClientOptions;
import com.microsoft.azure.sdk.iot.device.ProxySettings;
import com.microsoft.azure.sdk.iot.device.exceptions.IotHubClientException;
import com.microsoft.azure.sdk.iot.device.exceptions.MultiplexingClientRegistrationException;
import com.microsoft.azure.sdk.iot.device.transport.RetryPolicy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiplexingClient {
    private static final Logger log = LoggerFactory.getLogger(MultiplexingClient.class);
    static final long DEFAULT_SEND_PERIOD_MILLIS = 10L;
    static final long DEFAULT_RECEIVE_PERIOD_MILLIS = 10L;
    static final int DEFAULT_MAX_MESSAGES_TO_SEND_PER_THREAD = 10;
    private static final long DEFAULT_REGISTRATION_TIMEOUT_MILLISECONDS = 60000L;
    private static final long DEFAULT_UNREGISTRATION_TIMEOUT_MILLISECONDS = 60000L;
    private static final long DEFAULT_MESSAGE_EXPIRATION_CHECK_PERIOD = 10000L;
    private final Map<String, DeviceClient> multiplexedDeviceClients;
    private final DeviceIO deviceIO;
    private final String hostName;
    private final IotHubClientProtocol protocol;
    private final Object operationLock = new Object();
    private final ProxySettings proxySettings;
    public static final int MAX_MULTIPLEX_DEVICE_COUNT_AMQPS = 1000;
    public static final int MAX_MULTIPLEX_DEVICE_COUNT_AMQPS_WS = 500;

    public MultiplexingClient(String hostName, IotHubClientProtocol protocol) {
        this(hostName, protocol, null);
    }

    public MultiplexingClient(String hostName, IotHubClientProtocol protocol, MultiplexingClientOptions options) {
        long messageExpiredCheckPeriod;
        Objects.requireNonNull(hostName);
        Objects.requireNonNull(protocol);
        switch (protocol) {
            case AMQPS: 
            case AMQPS_WS: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Multiplexing is only supported for AMQPS and AMQPS_WS");
            }
        }
        this.multiplexedDeviceClients = new HashMap<String, DeviceClient>();
        this.hostName = hostName;
        this.protocol = protocol;
        this.proxySettings = options != null ? options.getProxySettings() : null;
        long sendPeriod = options != null ? options.getSendInterval() : 10L;
        long receivePeriod = options != null ? options.getReceiveInterval() : 10L;
        int sendMessagesPerThread = options != null ? options.getMaxMessagesSentPerSendInterval() : 10;
        int keepAliveInterval = options != null ? options.getKeepAliveInterval() : 230;
        int sendInterval = (int)(options != null ? options.getSendInterval() : 10L);
        String threadNamePrefix = options != null ? options.getThreadNamePrefix() : null;
        String threadNameSuffix = options != null ? options.getThreadNameSuffix() : null;
        boolean useIdentifiableThreadNames = options == null || options.isUsingIdentifiableThreadNames();
        long l = messageExpiredCheckPeriod = options != null ? options.getMessageExpirationCheckPeriod() : 10000L;
        if (sendPeriod < 0L) {
            throw new IllegalArgumentException("Send period cannot be negative");
        }
        if (sendPeriod == 0L) {
            sendPeriod = 10L;
        }
        if (receivePeriod < 0L) {
            throw new IllegalArgumentException("Receive period cannot be negative");
        }
        if (receivePeriod == 0L) {
            receivePeriod = 10L;
        }
        if (sendMessagesPerThread == 0) {
            sendMessagesPerThread = 10;
        }
        SSLContext sslContext = options != null ? options.getSslContext() : null;
        this.deviceIO = new DeviceIO(hostName, protocol, sslContext, this.proxySettings, keepAliveInterval, sendInterval, useIdentifiableThreadNames, threadNamePrefix, threadNameSuffix, messageExpiredCheckPeriod);
        this.deviceIO.setMaxNumberOfMessagesSentPerSendThread(sendMessagesPerThread);
        this.deviceIO.setSendPeriodInMilliseconds(sendPeriod);
        this.deviceIO.setReceivePeriodInMilliseconds(receivePeriod);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(boolean withRetry) throws IotHubClientException {
        Object object = this.operationLock;
        synchronized (object) {
            log.info("Opening multiplexing client");
            this.deviceIO.open(withRetry);
            log.info("Successfully opened multiplexing client");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.operationLock;
        synchronized (object) {
            log.info("Closing multiplexing client");
            this.deviceIO.close();
            log.info("Successfully closed multiplexing client");
        }
    }

    public void registerDeviceClient(DeviceClient deviceClient) throws InterruptedException, IotHubClientException {
        this.registerDeviceClient(deviceClient, 60000L);
    }

    public void registerDeviceClient(DeviceClient deviceClient, long timeoutMilliseconds) throws InterruptedException, IotHubClientException {
        Objects.requireNonNull(deviceClient);
        ArrayList<DeviceClient> clientList = new ArrayList<DeviceClient>();
        clientList.add(deviceClient);
        this.registerDeviceClients(clientList, timeoutMilliseconds);
    }

    public void registerDeviceClients(Iterable<DeviceClient> deviceClients) throws InterruptedException, IotHubClientException {
        this.registerDeviceClients(deviceClients, 60000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDeviceClients(Iterable<DeviceClient> deviceClients, long timeoutMilliseconds) throws InterruptedException, IotHubClientException {
        Objects.requireNonNull(deviceClients);
        if (timeoutMilliseconds <= 0L) {
            throw new IllegalArgumentException("Cannot set a device registration timeout of less than or equal to 0 milliseconds");
        }
        Object object = this.operationLock;
        synchronized (object) {
            ArrayList<ClientConfiguration> clientConfigsToRegister = new ArrayList<ClientConfiguration>();
            HashMap<String, DeviceClient> devicesToRegisterMap = new HashMap<String, DeviceClient>();
            for (DeviceClient deviceClientToRegister : deviceClients) {
                devicesToRegisterMap.put(deviceClientToRegister.getConfig().getDeviceId(), deviceClientToRegister);
                ClientConfiguration configToAdd = deviceClientToRegister.getConfig();
                configToAdd.setProxySettings(this.proxySettings);
                if (configToAdd.getAuthenticationType() != ClientConfiguration.AuthType.SAS_TOKEN) {
                    throw new UnsupportedOperationException("Can only register to multiplex a device client that uses SAS token based authentication");
                }
                if (configToAdd.getProtocol() != this.protocol) {
                    throw new UnsupportedOperationException("A device client cannot be registered to a multiplexing client that specifies a different transport protocol.");
                }
                if (this.protocol == IotHubClientProtocol.AMQPS && this.multiplexedDeviceClients.size() > 1000) {
                    throw new UnsupportedOperationException(String.format("Multiplexed connections over AMQPS only support up to %d devices", 1000));
                }
                if (this.protocol == IotHubClientProtocol.AMQPS_WS && this.multiplexedDeviceClients.size() > 500) {
                    throw new UnsupportedOperationException(String.format("Multiplexed connections over AMQPS_WS only support up to %d devices", 500));
                }
                if (!this.hostName.equalsIgnoreCase(configToAdd.getIotHubHostname())) {
                    throw new UnsupportedOperationException("A device client cannot be registered to a multiplexing client that specifies a different host name.");
                }
                if (deviceClientToRegister.getDeviceIO() != null && deviceClientToRegister.getDeviceIO().isOpen() && !deviceClientToRegister.isMultiplexed) {
                    throw new UnsupportedOperationException("Cannot register a device client to a multiplexed connection when the device client was already opened.");
                }
                deviceClientToRegister.setAsMultiplexed();
                deviceClientToRegister.setDeviceIO(this.deviceIO);
                deviceClientToRegister.markAsMultiplexed();
                boolean deviceAlreadyRegistered = this.multiplexedDeviceClients.containsKey(deviceClientToRegister.getConfig().getDeviceId());
                if (deviceAlreadyRegistered) {
                    log.debug("Device {} wasn't registered to the multiplexed connection because it is already registered.", (Object)configToAdd.getDeviceId());
                    continue;
                }
                clientConfigsToRegister.add(configToAdd);
            }
            for (ClientConfiguration configBeingRegistered : clientConfigsToRegister) {
                log.info("Registering device {} to multiplexing client", (Object)configBeingRegistered.getDeviceId());
            }
            try {
                this.deviceIO.registerMultiplexedDeviceClient(clientConfigsToRegister, timeoutMilliseconds);
                this.multiplexedDeviceClients.putAll(devicesToRegisterMap);
            }
            catch (MultiplexingClientRegistrationException e) {
                for (DeviceClient clientsThatAttemptedToRegister : deviceClients) {
                    String deviceIdThatAttemptedToRegister = clientsThatAttemptedToRegister.getConfig().getDeviceId();
                    if (e.getRegistrationExceptions().containsKey(deviceIdThatAttemptedToRegister)) continue;
                    this.multiplexedDeviceClients.put(deviceIdThatAttemptedToRegister, clientsThatAttemptedToRegister);
                }
                throw e;
            }
        }
    }

    public void unregisterDeviceClient(DeviceClient deviceClient) throws InterruptedException, IotHubClientException {
        this.unregisterDeviceClient(deviceClient, 60000L);
    }

    public void unregisterDeviceClient(DeviceClient deviceClient, long timeoutMilliseconds) throws InterruptedException, IotHubClientException {
        Objects.requireNonNull(deviceClient);
        ArrayList<DeviceClient> clientList = new ArrayList<DeviceClient>();
        clientList.add(deviceClient);
        this.unregisterDeviceClients(clientList, timeoutMilliseconds);
    }

    public void unregisterDeviceClients(Iterable<DeviceClient> deviceClients) throws InterruptedException, IotHubClientException {
        this.unregisterDeviceClients(deviceClients, 60000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterDeviceClients(Iterable<DeviceClient> deviceClients, long timeoutMilliseconds) throws InterruptedException, IotHubClientException {
        Objects.requireNonNull(deviceClients);
        if (timeoutMilliseconds <= 0L) {
            throw new IllegalArgumentException("Cannot set a device unregistration timeout of less than 0 milliseconds");
        }
        Object object = this.operationLock;
        synchronized (object) {
            ArrayList<ClientConfiguration> clientConfigsToRegister = new ArrayList<ClientConfiguration>();
            for (DeviceClient deviceClientToUnregister : deviceClients) {
                ClientConfiguration configToUnregister = deviceClientToUnregister.getConfig();
                clientConfigsToRegister.add(configToUnregister);
                log.info("Unregistering device {} from multiplexing client", (Object)deviceClientToUnregister.getConfig().getDeviceId());
                this.multiplexedDeviceClients.remove(deviceClientToUnregister.getConfig().getDeviceId());
                deviceClientToUnregister.setDeviceIO(null);
                deviceClientToUnregister.markTwinAsUnsubscribed();
                deviceClientToUnregister.markMethodsAsUnsubscribed();
                deviceClientToUnregister.setMessageCallback(null, null);
            }
            this.deviceIO.unregisterMultiplexedDeviceClient(clientConfigsToRegister, timeoutMilliseconds);
        }
    }

    public void setConnectionStatusChangeCallback(IotHubConnectionStatusChangeCallback callback, Object callbackContext) {
        this.deviceIO.setMultiplexingConnectionStateCallback(callback, callbackContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDeviceRegistered(String deviceId) {
        Object object = this.operationLock;
        synchronized (object) {
            return this.multiplexedDeviceClients.containsKey(deviceId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRegisteredDeviceCount() {
        Object object = this.operationLock;
        synchronized (object) {
            return this.multiplexedDeviceClients.size();
        }
    }

    public void setRetryPolicy(RetryPolicy retryPolicy) {
        this.deviceIO.setMultiplexingRetryPolicy(retryPolicy);
    }
}

