/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.microsoft.azure.sdk.iot.device.twin.ParserUtility;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;

public class FileUploadSasUriResponse {
    private static final String HTTPS_URL_STRING = "https://";
    private static final String CORRELATION_ID_TAG = "correlationId";
    @Expose
    @SerializedName(value="correlationId")
    private String correlationId = null;
    private static final String HOST_NAME_TAG = "hostName";
    @Expose
    @SerializedName(value="hostName")
    private String hostName = null;
    private static final String CONTAINER_NAME_TAG = "containerName";
    @Expose
    @SerializedName(value="containerName")
    private String containerName = null;
    private static final String BLOB_NAME_TAG = "blobName";
    @Expose
    @SerializedName(value="blobName")
    private String blobName = null;
    private static final String SAS_TOKEN_TAG = "sasToken";
    @Expose
    @SerializedName(value="sasToken")
    private String sasToken = null;

    public FileUploadSasUriResponse(String json) throws IllegalArgumentException {
        FileUploadSasUriResponse newFileUploadSasUriResponse;
        Gson gson = new GsonBuilder().disableHtmlEscaping().serializeNulls().create();
        ParserUtility.validateStringUTF8(json);
        try {
            newFileUploadSasUriResponse = (FileUploadSasUriResponse)gson.fromJson(json, FileUploadSasUriResponse.class);
        }
        catch (JsonSyntaxException malformed) {
            throw new IllegalArgumentException("Malformed json", malformed);
        }
        this.hostName = newFileUploadSasUriResponse.hostName;
        this.containerName = newFileUploadSasUriResponse.containerName;
        this.correlationId = newFileUploadSasUriResponse.correlationId;
        this.blobName = newFileUploadSasUriResponse.blobName;
        this.sasToken = newFileUploadSasUriResponse.sasToken;
    }

    public URI getBlobUri() throws UnsupportedEncodingException, URISyntaxException {
        String putString = HTTPS_URL_STRING + this.hostName + "/" + this.containerName + "/" + URLEncoder.encode(this.blobName, StandardCharsets.UTF_8.name()) + this.sasToken;
        return new URI(putString);
    }

    FileUploadSasUriResponse() {
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public String getBlobName() {
        return this.blobName;
    }

    public String getSasToken() {
        return this.sasToken;
    }
}

