/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device;

import com.microsoft.azure.sdk.iot.device.FileUploadCompletionNotification;
import com.microsoft.azure.sdk.iot.device.FileUploadSasUriRequest;
import com.microsoft.azure.sdk.iot.device.FileUploadSasUriResponse;
import com.microsoft.azure.sdk.iot.device.IotHubStatusCode;
import com.microsoft.azure.sdk.iot.device.exceptions.IotHubClientException;
import com.microsoft.azure.sdk.iot.device.transport.IotHubTransportMessage;
import com.microsoft.azure.sdk.iot.device.transport.https.HttpsMethod;
import com.microsoft.azure.sdk.iot.device.transport.https.HttpsResponse;
import com.microsoft.azure.sdk.iot.device.transport.https.HttpsTransportManager;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class FileUpload {
    private static final Logger log = LoggerFactory.getLogger(FileUpload.class);
    private static final Charset DEFAULT_IOTHUB_MESSAGE_CHARSET = StandardCharsets.UTF_8;
    private final HttpsTransportManager httpsTransportManager;

    FileUpload(HttpsTransportManager httpsTransportManager) {
        this.httpsTransportManager = httpsTransportManager;
    }

    FileUploadSasUriResponse getFileUploadSasUri(FileUploadSasUriRequest request) throws IotHubClientException {
        IotHubTransportMessage message = new IotHubTransportMessage(request.toJson());
        message.setIotHubMethod(HttpsMethod.POST);
        try {
            HttpsResponse responseMessage = this.httpsTransportManager.getFileUploadSasUri(message);
            String responseMessagePayload = this.validateServiceStatusCode(responseMessage);
            if (responseMessagePayload == null || responseMessagePayload.isEmpty()) {
                throw new IotHubClientException(IotHubStatusCode.ERROR, "SAS URI response message had no payload");
            }
            return new FileUploadSasUriResponse(responseMessagePayload);
        }
        catch (IOException e) {
            throw new IotHubClientException(IotHubStatusCode.IO_ERROR, "Failed to get file upload SAS URI", e);
        }
    }

    void sendNotification(FileUploadCompletionNotification fileUploadStatusParser) throws IotHubClientException {
        IotHubTransportMessage message = new IotHubTransportMessage(fileUploadStatusParser.toJson());
        message.setIotHubMethod(HttpsMethod.POST);
        try {
            HttpsResponse responseMessage = this.httpsTransportManager.sendFileUploadNotification(message);
            this.validateServiceStatusCode(responseMessage);
        }
        catch (IOException e) {
            throw new IotHubClientException(IotHubStatusCode.IO_ERROR, "Failed to send file upload completion notification", e);
        }
    }

    private String validateServiceStatusCode(HttpsResponse responseMessage) throws IotHubClientException {
        IotHubStatusCode statusCode;
        String responseMessagePayload = null;
        if (responseMessage.getBody() != null && responseMessage.getBody().length > 0) {
            responseMessagePayload = new String(responseMessage.getBody(), DEFAULT_IOTHUB_MESSAGE_CHARSET);
        }
        if (!IotHubStatusCode.isSuccessful(statusCode = IotHubStatusCode.getIotHubStatusCode(responseMessage.getStatus()))) {
            throw new IotHubClientException(statusCode, responseMessagePayload);
        }
        return responseMessagePayload;
    }
}

