/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.twin;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.util.Map;
import java.util.Set;

public class MethodParser {
    @Expose(serialize=false, deserialize=false)
    private Operation operation = Operation.none;
    private static final String METHOD_NAME_TAG = "methodName";
    @Expose(deserialize=false)
    @SerializedName(value="methodName")
    private String name = null;
    private static final String RESPONSE_TIMEOUT_IN_SECONDS_TAG = "responseTimeoutInSeconds";
    @Expose(deserialize=false)
    @SerializedName(value="responseTimeoutInSeconds")
    private Long responseTimeout = null;
    private static final String CONNECT_TIMEOUT_IN_SECONDS_TAG = "connectTimeoutInSeconds";
    @Expose(deserialize=false)
    @SerializedName(value="connectTimeoutInSeconds")
    private Long connectTimeout = null;
    private static final String STATUS_TAG = "status";
    @Expose(serialize=false)
    @SerializedName(value="status")
    private Integer status = null;
    private static final String PAYLOAD_TAG = "payload";
    @SerializedName(value="payload")
    private JsonElement payload = null;

    public MethodParser() {
    }

    public MethodParser(String name, Long responseTimeout, Long connectTimeout, JsonElement payload) throws IllegalArgumentException {
        this();
        this.validateKey(name);
        if (responseTimeout != null) {
            this.validateTimeout(responseTimeout);
        }
        if (connectTimeout != null) {
            this.validateTimeout(connectTimeout);
        }
        this.name = name;
        this.responseTimeout = responseTimeout;
        this.connectTimeout = connectTimeout;
        this.payload = payload;
        this.operation = Operation.invoke;
    }

    public MethodParser(JsonElement payload) {
        this();
        this.payload = payload;
        this.operation = Operation.payload;
    }

    public synchronized void fromJson(String json) throws IllegalArgumentException {
        block14: {
            if (json == null || json.isEmpty()) {
                throw new IllegalArgumentException("Invalid json.");
            }
            JsonParser jsonParser = new JsonParser();
            try {
                JsonElement jsonElement = jsonParser.parse(json);
                if (jsonElement instanceof JsonPrimitive || jsonElement instanceof JsonArray) {
                    this.operation = Operation.payload;
                    this.payload = jsonElement;
                    break block14;
                }
                if (jsonElement instanceof JsonObject) {
                    JsonObject jsonObject = (JsonObject)jsonElement;
                    JsonElement statusTagNode = jsonObject.get(STATUS_TAG);
                    JsonElement methodNameNode = jsonObject.get(METHOD_NAME_TAG);
                    if (methodNameNode == null) {
                        if (statusTagNode == null) {
                            this.operation = Operation.payload;
                            this.payload = jsonObject;
                        } else {
                            JsonElement payloadNode;
                            this.operation = Operation.response;
                            if (statusTagNode.isJsonPrimitive()) {
                                this.status = statusTagNode.getAsInt();
                            }
                            if ((payloadNode = jsonObject.get(PAYLOAD_TAG)) != null) {
                                this.payload = payloadNode;
                            }
                        }
                        break block14;
                    }
                    if (statusTagNode == null) {
                        JsonElement payloadNode;
                        JsonElement connetionTimeoutNode;
                        this.operation = Operation.invoke;
                        this.name = methodNameNode.getAsString();
                        JsonElement responseTimeoutNode = jsonObject.get(RESPONSE_TIMEOUT_IN_SECONDS_TAG);
                        if (responseTimeoutNode != null) {
                            this.responseTimeout = responseTimeoutNode.getAsLong();
                        }
                        if ((connetionTimeoutNode = jsonObject.get(CONNECT_TIMEOUT_IN_SECONDS_TAG)) != null) {
                            this.connectTimeout = connetionTimeoutNode.getAsLong();
                        }
                        if ((payloadNode = jsonObject.get(PAYLOAD_TAG)) != null) {
                            this.payload = payloadNode;
                        }
                        break block14;
                    }
                    throw new IllegalArgumentException("Invoke method name and Status reported in the same json");
                }
                throw new IllegalArgumentException("Invalid json.");
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Malformed json.", ex);
            }
        }
    }

    public JsonElement getPayloadFromJson(String json) {
        if (json == null || json.isEmpty()) {
            return new JsonObject();
        }
        JsonElement jsonElement = new JsonParser().parse(json);
        return jsonElement;
    }

    public JsonElement getPayload() {
        return this.payload;
    }

    public String toJson() throws IllegalArgumentException {
        return this.toJsonElement().toString();
    }

    private JsonElement jsonizePayload(Object payload) {
        if (payload == null) {
            return JsonNull.INSTANCE;
        }
        if (payload instanceof JsonElement) {
            return (JsonElement)payload;
        }
        if (payload instanceof Map) {
            JsonObject jsonObject = new JsonObject();
            Set entrySet = ((Map)payload).entrySet();
            for (Map.Entry entry : entrySet) {
                jsonObject.add((String)entry.getKey(), this.jsonizePayload(entry.getValue()));
            }
            return jsonObject;
        }
        JsonParser parser = new JsonParser();
        try {
            String json = payload.toString();
            JsonElement jsonElement = parser.parse(json);
            if (jsonElement.isJsonNull()) {
                return new JsonPrimitive(json);
            }
            return jsonElement;
        }
        catch (JsonSyntaxException e) {
            return new Gson().toJsonTree(payload);
        }
    }

    public JsonElement toJsonElement() throws IllegalArgumentException {
        if (this.operation == Operation.invoke) {
            if (this.name == null || this.name.isEmpty()) {
                throw new IllegalArgumentException("cannot invoke method with null name");
            }
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty(METHOD_NAME_TAG, this.name);
            if (this.responseTimeout != null) {
                jsonObject.addProperty(RESPONSE_TIMEOUT_IN_SECONDS_TAG, (Number)this.responseTimeout);
            }
            if (this.connectTimeout != null) {
                jsonObject.addProperty(CONNECT_TIMEOUT_IN_SECONDS_TAG, (Number)this.connectTimeout);
            }
            jsonObject.add(PAYLOAD_TAG, this.jsonizePayload(this.payload));
            return jsonObject;
        }
        if (this.operation == Operation.response) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty(STATUS_TAG, (Number)this.status);
            jsonObject.add(PAYLOAD_TAG, this.jsonizePayload(this.payload));
            return jsonObject;
        }
        if (this.operation == Operation.payload) {
            return this.jsonizePayload(this.payload);
        }
        throw new IllegalArgumentException("There is no content to parser");
    }

    private void validateKey(String key) throws IllegalArgumentException {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("Key cannot be null or empty");
        }
        if (key.length() > 128) {
            throw new IllegalArgumentException("Key cannot be longer than 128 characters");
        }
        if (key.contains("$") || key.contains(".") || key.contains(" ")) {
            throw new IllegalArgumentException("Key cannot contain '$', '.', or space");
        }
    }

    private void validateTimeout(Long timeout) throws IllegalArgumentException {
        if (timeout < 0L) {
            throw new IllegalArgumentException("Negative timeout");
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getResponseTimeout() {
        return this.responseTimeout;
    }

    public void setResponseTimeout(Long responseTimeout) {
        this.responseTimeout = responseTimeout;
    }

    public Long getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(Long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public void setPayload(JsonElement payload) {
        this.payload = payload;
    }

    protected static enum Operation {
        invoke,
        response,
        payload,
        none;

    }
}

