/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport.mqtt;

import com.microsoft.azure.sdk.iot.device.Message;
import com.microsoft.azure.sdk.iot.device.MessageType;
import com.microsoft.azure.sdk.iot.device.transport.IotHubTransportMessage;
import com.microsoft.azure.sdk.iot.device.transport.TransportException;
import com.microsoft.azure.sdk.iot.device.transport.mqtt.Mqtt;
import com.microsoft.azure.sdk.iot.device.transport.mqtt.TopicParser;
import com.microsoft.azure.sdk.iot.device.twin.DeviceOperations;
import java.util.Map;
import java.util.Queue;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MqttDirectMethod
extends Mqtt {
    private static final Logger log = LoggerFactory.getLogger(MqttDirectMethod.class);
    private final String subscribeTopic;
    private final String responseTopic;
    private boolean isStarted = false;
    private static final String POUND = "#";
    private static final String BACKSLASH = "/";
    private static final String QUESTION = "?";
    private static final String METHOD = "$iothub/methods/";
    private static final String POST = "$iothub/methods/POST";
    private static final String RES = "$iothub/methods/res";
    private static final String REQ_ID = "?$rid=";
    private static final int METHOD_TOKEN = 3;
    private static final int REQID_TOKEN = 4;

    public MqttDirectMethod(String deviceId, MqttConnectOptions connectOptions, Map<Integer, Message> unacknowledgedSentMessages, Queue<Pair<String, MqttMessage>> receivedMessages) {
        super(null, deviceId, connectOptions, unacknowledgedSentMessages, receivedMessages);
        this.subscribeTopic = "$iothub/methods/POST/#";
        this.responseTopic = RES;
    }

    public void start() {
        if (!this.isStarted) {
            this.isStarted = true;
        }
    }

    public void stop() {
        this.isStarted = false;
    }

    public void send(IotHubTransportMessage message) throws TransportException, IllegalArgumentException {
        if (message == null || message.getBytes() == null) {
            throw new IllegalArgumentException("Message cannot be null");
        }
        if (!this.isStarted) {
            throw new TransportException("Start device method before using send");
        }
        if (message.getMessageType() != MessageType.DEVICE_METHODS) {
            return;
        }
        switch (message.getDeviceOperationType()) {
            case DEVICE_OPERATION_METHOD_SUBSCRIBE_REQUEST: {
                this.subscribe(this.subscribeTopic);
                break;
            }
            case DEVICE_OPERATION_METHOD_SEND_RESPONSE: {
                if (message.getRequestId() == null || message.getRequestId().isEmpty()) {
                    throw new IllegalArgumentException("Request id cannot be null or empty");
                }
                String topic = this.responseTopic + BACKSLASH + message.getStatus() + BACKSLASH + REQ_ID + message.getRequestId();
                this.publish(topic, message);
                break;
            }
            default: {
                throw new TransportException("Mismatched device method operation");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IotHubTransportMessage receive() {
        Object object = this.receivedMessagesLock;
        synchronized (object) {
            String topic;
            IotHubTransportMessage message = null;
            Pair messagePair = (Pair)this.receivedMessages.peek();
            if (messagePair != null && (topic = (String)messagePair.getKey()) != null && topic.length() > 0) {
                MqttMessage mqttMessage = (MqttMessage)messagePair.getValue();
                byte[] data = mqttMessage.getPayload();
                if (topic.length() > METHOD.length() && topic.startsWith(METHOD) && topic.length() > POST.length() && topic.startsWith(POST)) {
                    this.receivedMessages.poll();
                    TopicParser topicParser = new TopicParser(topic);
                    message = data != null && data.length > 0 ? new IotHubTransportMessage(data, MessageType.DEVICE_METHODS) : new IotHubTransportMessage(new byte[0], MessageType.DEVICE_METHODS);
                    message.setDeviceOperationType(DeviceOperations.DEVICE_OPERATION_UNKNOWN);
                    message.setQualityOfService(mqttMessage.getQos());
                    String methodName = topicParser.getMethodName(3);
                    message.setMethodName(methodName);
                    String reqId = topicParser.getRequestId(4);
                    if (reqId != null) {
                        message.setRequestId(reqId);
                        message.setDeviceOperationType(DeviceOperations.DEVICE_OPERATION_METHOD_RECEIVE_REQUEST);
                    } else {
                        log.warn("Request ID cannot be null");
                    }
                }
            }
            return message;
        }
    }
}

