/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport;

import com.microsoft.azure.sdk.iot.device.ClientConfiguration;
import com.microsoft.azure.sdk.iot.device.ConnectionStatusChangeContext;
import com.microsoft.azure.sdk.iot.device.CorrelatingMessageCallback;
import com.microsoft.azure.sdk.iot.device.IotHubClientProtocol;
import com.microsoft.azure.sdk.iot.device.IotHubConnectionStatusChangeCallback;
import com.microsoft.azure.sdk.iot.device.IotHubConnectionStatusChangeReason;
import com.microsoft.azure.sdk.iot.device.IotHubMessageResult;
import com.microsoft.azure.sdk.iot.device.IotHubStatusCode;
import com.microsoft.azure.sdk.iot.device.Message;
import com.microsoft.azure.sdk.iot.device.MessageCallback;
import com.microsoft.azure.sdk.iot.device.MessageSentCallback;
import com.microsoft.azure.sdk.iot.device.ProxySettings;
import com.microsoft.azure.sdk.iot.device.exceptions.IotHubClientException;
import com.microsoft.azure.sdk.iot.device.exceptions.MultiplexingClientRegistrationException;
import com.microsoft.azure.sdk.iot.device.transport.CorrelationCallbackContext;
import com.microsoft.azure.sdk.iot.device.transport.ExponentialBackoffWithJitter;
import com.microsoft.azure.sdk.iot.device.transport.IotHubConnectionStatus;
import com.microsoft.azure.sdk.iot.device.transport.IotHubListener;
import com.microsoft.azure.sdk.iot.device.transport.IotHubTransportConnection;
import com.microsoft.azure.sdk.iot.device.transport.IotHubTransportMessage;
import com.microsoft.azure.sdk.iot.device.transport.IotHubTransportPacket;
import com.microsoft.azure.sdk.iot.device.transport.MultiplexedDeviceState;
import com.microsoft.azure.sdk.iot.device.transport.RetryDecision;
import com.microsoft.azure.sdk.iot.device.transport.RetryPolicy;
import com.microsoft.azure.sdk.iot.device.transport.TransportException;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsIotHubConnection;
import com.microsoft.azure.sdk.iot.device.transport.amqps.exceptions.AmqpUnauthorizedAccessException;
import com.microsoft.azure.sdk.iot.device.transport.https.HttpsIotHubConnection;
import com.microsoft.azure.sdk.iot.device.transport.https.exceptions.UnauthorizedException;
import com.microsoft.azure.sdk.iot.device.transport.mqtt.MqttIotHubConnection;
import com.microsoft.azure.sdk.iot.device.transport.mqtt.exceptions.MqttUnauthorizedException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IotHubTransport
implements IotHubListener {
    private static final Logger log = LoggerFactory.getLogger(IotHubTransport.class);
    private static final int DEFAULT_MAX_MESSAGES_TO_SEND_PER_THREAD = 10;
    private static final int DEFAULT_CORRELATION_ID_LIVE_TIME = 60000;
    private IotHubConnectionStatus connectionStatus;
    private Throwable connectionStatusLastException;
    private int maxNumberOfMessagesToSendPerThread = 10;
    private final Map<String, MultiplexedDeviceState> multiplexedDeviceConnectionStates = new HashMap<String, MultiplexedDeviceState>();
    private final Map<String, Exception> multiplexingDeviceRegistrationFailures = new ConcurrentHashMap<String, Exception>();
    private IotHubTransportConnection iotHubTransportConnection;
    private final Queue<IotHubTransportPacket> waitingPacketsQueue = new ConcurrentLinkedQueue<IotHubTransportPacket>();
    private final Map<String, IotHubTransportPacket> inProgressPackets = new ConcurrentHashMap<String, IotHubTransportPacket>();
    private final Queue<IotHubTransportMessage> receivedMessagesQueue = new ConcurrentLinkedQueue<IotHubTransportMessage>();
    private final Queue<IotHubTransportPacket> callbackPacketsQueue = new ConcurrentLinkedQueue<IotHubTransportPacket>();
    private final Map<String, IotHubConnectionStatusChangeCallback> connectionStatusChangeCallbacks = new ConcurrentHashMap<String, IotHubConnectionStatusChangeCallback>();
    private final Map<String, Object> connectionStatusChangeCallbackContexts = new ConcurrentHashMap<String, Object>();
    private IotHubConnectionStatusChangeCallback multiplexingStateCallback;
    private Object multiplexingStateCallbackContext;
    private RetryPolicy multiplexingRetryPolicy = new ExponentialBackoffWithJitter();
    private final IotHubConnectionStatusChangeCallback deviceIOConnectionStatusChangeCallback;
    private final Object inProgressMessagesLock = new Object();
    private final Object multiplexingDeviceStateLock = new Object();
    private final Map<String, ClientConfiguration> deviceClientConfigs = new ConcurrentHashMap<String, ClientConfiguration>();
    private final String transportUniqueIdentifier = UUID.randomUUID().toString().substring(0, 8);
    private ScheduledExecutorService taskScheduler;
    private final Object reconnectionLock = new Object();
    private final Semaphore sendThreadSemaphore = new Semaphore(0);
    private final Semaphore receiveThreadSemaphore = new Semaphore(0);
    private final Semaphore reconnectThreadSemaphore = new Semaphore(0);
    private final IotHubClientProtocol protocol;
    private final String hostName;
    private final ProxySettings proxySettings;
    private final int keepAliveInterval;
    private final int sendInterval;
    private SSLContext sslContext;
    private final boolean isMultiplexing;
    private final String threadNamePrefix;
    private final String threadNameSuffix;
    private final boolean useIdentifiableThreadNames;
    private boolean isClosing;
    private final Map<String, CorrelationCallbackContext> correlationCallbacks = new ConcurrentHashMap<String, CorrelationCallbackContext>();
    private final Thread correlationCallbackCleanupThread = new Thread(() -> this.checkForOldMessages());
    private static final int CORRELATION_CALLBACK_CLEANUP_PERIOD_MILLISECONDS = 3600000;

    public IotHubTransport(ClientConfiguration defaultConfig, IotHubConnectionStatusChangeCallback deviceIOConnectionStatusChangeCallback, boolean isMultiplexing) throws IllegalArgumentException {
        if (defaultConfig == null) {
            throw new IllegalArgumentException("Config cannot be null");
        }
        this.protocol = defaultConfig.getProtocol();
        this.hostName = defaultConfig.getIotHubHostname();
        this.deviceClientConfigs.put(defaultConfig.getDeviceId(), defaultConfig);
        this.multiplexedDeviceConnectionStates.put(defaultConfig.getDeviceId(), new MultiplexedDeviceState(IotHubConnectionStatus.DISCONNECTED));
        this.proxySettings = defaultConfig.getProxySettings();
        this.connectionStatus = IotHubConnectionStatus.DISCONNECTED;
        this.isMultiplexing = isMultiplexing;
        this.deviceIOConnectionStatusChangeCallback = deviceIOConnectionStatusChangeCallback;
        this.keepAliveInterval = defaultConfig.getKeepAliveInterval();
        this.sendInterval = defaultConfig.getSendInterval();
        this.useIdentifiableThreadNames = defaultConfig.isUsingIdentifiableThreadNames();
        this.threadNamePrefix = defaultConfig.getThreadNamePrefix();
        this.threadNameSuffix = defaultConfig.getThreadNameSuffix();
    }

    public IotHubTransport(String hostName, IotHubClientProtocol protocol, SSLContext sslContext, ProxySettings proxySettings, IotHubConnectionStatusChangeCallback deviceIOConnectionStatusChangeCallback, int keepAliveInterval, int sendInterval, boolean useIdentifiableThreadNames, String threadNamePrefix, String threadNameSuffix) throws IllegalArgumentException {
        this.protocol = protocol;
        this.hostName = hostName;
        this.sslContext = sslContext;
        this.proxySettings = proxySettings;
        this.connectionStatus = IotHubConnectionStatus.DISCONNECTED;
        this.deviceIOConnectionStatusChangeCallback = deviceIOConnectionStatusChangeCallback;
        this.isMultiplexing = true;
        this.keepAliveInterval = keepAliveInterval;
        this.sendInterval = sendInterval;
        this.useIdentifiableThreadNames = useIdentifiableThreadNames;
        this.threadNamePrefix = threadNamePrefix;
        this.threadNameSuffix = threadNameSuffix;
    }

    public Semaphore getSendThreadSemaphore() {
        return this.sendThreadSemaphore;
    }

    public Semaphore getReceiveThreadSemaphore() {
        return this.receiveThreadSemaphore;
    }

    public Semaphore getReconnectThreadSemaphore() {
        return this.reconnectThreadSemaphore;
    }

    public boolean hasMessagesToSend() {
        return this.waitingPacketsQueue.size() > 0;
    }

    public boolean hasReceivedMessagesToHandle() {
        return this.receivedMessagesQueue.size() > 0;
    }

    public boolean hasCallbacksToExecute() {
        return this.callbackPacketsQueue.size() > 0;
    }

    public boolean needsReconnect() {
        if (this.connectionStatus == IotHubConnectionStatus.DISCONNECTED_RETRYING) {
            return true;
        }
        for (MultiplexedDeviceState multiplexedDeviceState : this.multiplexedDeviceConnectionStates.values()) {
            if (multiplexedDeviceState.getConnectionStatus() != IotHubConnectionStatus.DISCONNECTED_RETRYING) continue;
            return true;
        }
        return false;
    }

    public boolean isClosed() {
        return this.connectionStatus == IotHubConnectionStatus.DISCONNECTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessageSent(Message message, String deviceId, TransportException e) {
        IotHubTransportPacket packet;
        if (message == null) {
            log.warn("onMessageSent called with null message");
            return;
        }
        log.debug("IotHub message was acknowledged. Checking if there is record of sending this message ({})", (Object)message);
        Object object = this.inProgressMessagesLock;
        synchronized (object) {
            packet = this.inProgressPackets.remove(message.getMessageId());
        }
        if (packet != null) {
            if (e == null) {
                log.trace("Message was sent by this client, adding it to callbacks queue with OK ({})", (Object)message);
                packet.setStatus(IotHubStatusCode.OK);
                this.addToCallbackQueue(packet);
            } else {
                this.handleMessageException(packet, e);
            }
            try {
                CorrelationCallbackContext callbackContext;
                String correlationId = message.getCorrelationId();
                if (!correlationId.isEmpty() && (callbackContext = this.correlationCallbacks.get(correlationId)) != null && callbackContext.getCallback() != null) {
                    IotHubClientException clientException = null;
                    if (e != null) {
                        clientException = e.toIotHubClientException();
                    }
                    callbackContext.getCallback().onRequestAcknowledged(packet.getMessage(), callbackContext.getUserContext(), clientException);
                }
            }
            catch (Exception ex) {
                log.warn("Exception thrown while calling the onRequestAcknowledged callback in onMessageSent", (Throwable)ex);
            }
        } else {
            log.trace("A message was acknowledged by IoT hub, but this client has already stopped tracking it ({})", (Object)message);
        }
    }

    @Override
    public void onMessageReceived(IotHubTransportMessage message, TransportException e) {
        if (message != null && e != null) {
            log.error("Exception encountered while receiving a message from service {}", (Object)message, (Object)e);
        } else if (message != null) {
            log.debug("Message was received from IotHub ({})", (Object)message);
            this.addToReceivedMessagesQueue(message);
        } else {
            log.error("Exception encountered while receiving messages from service", (Throwable)e);
        }
        try {
            CorrelationCallbackContext callbackContext;
            String correlationId;
            if (message != null && !(correlationId = message.getCorrelationId()).isEmpty() && (callbackContext = this.correlationCallbacks.get(correlationId)) != null && callbackContext.getCallback() != null) {
                IotHubClientException clientException = null;
                if (e != null) {
                    clientException = e.toIotHubClientException();
                } else {
                    IotHubStatusCode statusCode = IotHubStatusCode.getIotHubStatusCode(Integer.parseInt(message.getStatus()));
                    if (!IotHubStatusCode.isSuccessful(statusCode)) {
                        clientException = new IotHubClientException(statusCode, "Received an unsuccessful operation error code from the service: " + (Object)((Object)statusCode));
                    }
                }
                callbackContext.getCallback().onResponseReceived(message, callbackContext.getUserContext(), clientException);
            }
        }
        catch (Exception ex) {
            log.warn("Exception thrown while calling the onResponseReceived callback in onMessageReceived", (Throwable)ex);
        }
    }

    @Override
    public void onConnectionLost(TransportException e, String connectionId) {
        if (!connectionId.equals(this.iotHubTransportConnection.getConnectionId())) {
            log.trace("OnConnectionLost was fired, but for an outdated connection. Ignoring...");
            return;
        }
        if (this.connectionStatus != IotHubConnectionStatus.CONNECTED) {
            log.trace("OnConnectionLost was fired, but connection is already disconnected. Ignoring...", (Throwable)e);
            return;
        }
        this.updateStatus(IotHubConnectionStatus.DISCONNECTED_RETRYING, this.exceptionToStatusChangeReason(e), e);
        log.trace("Waking up reconnection thread");
        this.reconnectThreadSemaphore.release();
    }

    @Override
    public void onConnectionEstablished(String connectionId) {
        if (connectionId.equals(this.iotHubTransportConnection.getConnectionId())) {
            log.debug("The connection to the IoT Hub has been established");
            this.updateStatus(IotHubConnectionStatus.CONNECTED, IotHubConnectionStatusChangeReason.CONNECTION_OK, null);
        }
    }

    @Override
    public void onMultiplexedDeviceSessionEstablished(String connectionId, String deviceId) {
        if (connectionId.equals(this.iotHubTransportConnection.getConnectionId())) {
            log.debug("The device session in the multiplexed connection to the IoT Hub has been established for device {}", (Object)deviceId);
            this.updateStatus(IotHubConnectionStatus.CONNECTED, IotHubConnectionStatusChangeReason.CONNECTION_OK, null, deviceId);
        }
    }

    @Override
    public void onMultiplexedDeviceSessionLost(TransportException e, String connectionId, String deviceId, boolean shouldReconnect) {
        if (connectionId.equals(this.iotHubTransportConnection.getConnectionId())) {
            log.debug("The device session in the multiplexed connection to the IoT Hub has been lost for device {}", (Object)deviceId);
            if (shouldReconnect) {
                this.updateStatus(IotHubConnectionStatus.DISCONNECTED_RETRYING, this.exceptionToStatusChangeReason(e), e, deviceId);
                log.trace("Waking up reconnection thread");
                this.reconnectThreadSemaphore.release();
            } else {
                this.updateStatus(IotHubConnectionStatus.DISCONNECTED, IotHubConnectionStatusChangeReason.CLIENT_CLOSE, null, deviceId);
            }
        }
    }

    @Override
    public void onMultiplexedDeviceSessionRegistrationFailed(String connectionId, String deviceId, Exception e) {
        if (connectionId != null && connectionId.equals(this.iotHubTransportConnection.getConnectionId())) {
            this.multiplexingDeviceRegistrationFailures.put(deviceId, e);
        }
    }

    public void setMultiplexingRetryPolicy(RetryPolicy retryPolicy) {
        this.multiplexingRetryPolicy = retryPolicy;
    }

    public void open(boolean withRetry) throws TransportException, IotHubClientException {
        block10: {
            if (this.connectionStatus == IotHubConnectionStatus.CONNECTED) {
                return;
            }
            if (this.connectionStatus == IotHubConnectionStatus.DISCONNECTED_RETRYING) {
                throw new TransportException("Open cannot be called while transport is reconnecting");
            }
            this.isClosing = false;
            this.taskScheduler = Executors.newScheduledThreadPool(1);
            if (withRetry) {
                int connectionAttempt = 0;
                long startTime = System.currentTimeMillis();
                while (true) {
                    RetryPolicy retryPolicy = this.isMultiplexing ? this.multiplexingRetryPolicy : this.getDefaultConfig().getRetryPolicy();
                    try {
                        this.openConnection();
                        break block10;
                    }
                    catch (TransportException transportException) {
                        log.debug("Encountered an exception while opening the client. Checking the configured retry policy to see if another attempt should be made.", (Throwable)transportException);
                        RetryDecision retryDecision = retryPolicy.getRetryDecision(connectionAttempt, transportException);
                        if (!retryDecision.shouldRetry()) {
                            throw new TransportException("Retry expired while attempting to open the connection", transportException);
                        }
                        ++connectionAttempt;
                        if (this.hasOperationTimedOut(startTime)) {
                            throw new TransportException("Open operation timed out. The nested exception is the most recent exception thrown while attempting to open the connection", transportException);
                        }
                        try {
                            log.trace("The configured retry policy allows for another attempt. Sleeping for {} milliseconds before the next attempt", (Object)retryDecision.getDuration());
                            Thread.sleep(retryDecision.getDuration());
                        }
                        catch (InterruptedException e) {
                            throw new TransportException("InterruptedException thrown while sleeping between connection attempts", e);
                        }
                    }
                }
            }
            this.openConnection();
        }
        log.debug("Client connection opened successfully");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(IotHubConnectionStatusChangeReason reason, Throwable cause) {
        if (reason == null) {
            throw new IllegalArgumentException("reason cannot be null");
        }
        this.isClosing = true;
        Object object = this.reconnectionLock;
        synchronized (object) {
            this.cancelPendingPackets();
            this.invokeCallbacks();
            if (this.taskScheduler != null) {
                this.taskScheduler.shutdown();
            }
            try {
                if (this.iotHubTransportConnection != null) {
                    this.iotHubTransportConnection.close();
                }
            }
            finally {
                this.updateStatus(IotHubConnectionStatus.DISCONNECTED, reason, cause);
                this.sendThreadSemaphore.release();
                this.receiveThreadSemaphore.release();
                this.reconnectThreadSemaphore.release();
                log.debug("Client connection closed successfully");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconnect() throws InterruptedException {
        Object object = this.reconnectionLock;
        synchronized (object) {
            RetryPolicy retryPolicy;
            long reconnectionStartTimeMillis = 0L;
            int reconnectionAttempt = 0;
            String deviceSessionToReconnect = null;
            RetryPolicy retryPolicy2 = retryPolicy = this.isMultiplexing ? this.multiplexingRetryPolicy : this.getDefaultConfig().getRetryPolicy();
            while (this.needsReconnect()) {
                if (this.isClosing) {
                    log.trace("Abandoning reconnection logic since this client has started closing");
                    return;
                }
                if (this.connectionStatus == IotHubConnectionStatus.DISCONNECTED_RETRYING) {
                    this.clearInProgressMessages();
                    if (reconnectionStartTimeMillis == 0L) {
                        reconnectionStartTimeMillis = System.currentTimeMillis();
                    }
                    this.singleReconnectAttempt(retryPolicy, reconnectionAttempt, reconnectionStartTimeMillis);
                    ++reconnectionAttempt;
                    continue;
                }
                if ((deviceSessionToReconnect = this.pickDeviceSessionToReconnect(deviceSessionToReconnect)) == null) continue;
                this.singleDeviceReconnectAttemptAsync(deviceSessionToReconnect);
            }
        }
    }

    private boolean checkIfPreviousReconnectionAttemptFinished(String deviceSessionToReconnect) {
        MultiplexedDeviceState lastReconnectAttemptsDeviceSession = this.multiplexedDeviceConnectionStates.get(deviceSessionToReconnect);
        if (lastReconnectAttemptsDeviceSession == null) {
            return true;
        }
        if (lastReconnectAttemptsDeviceSession.getConnectionStatus() != IotHubConnectionStatus.DISCONNECTED_RETRYING) {
            log.trace("Finished reconnection logic for device session for device {} with terminal state {}", (Object)deviceSessionToReconnect, (Object)lastReconnectAttemptsDeviceSession.getConnectionStatus());
            return true;
        }
        return false;
    }

    private String pickDeviceSessionToReconnect(String previousDeviceSessionToReconnect) {
        boolean previousReconnectionAttemptFinished = this.checkIfPreviousReconnectionAttemptFinished(previousDeviceSessionToReconnect);
        if (previousReconnectionAttemptFinished) {
            for (String deviceId : this.multiplexedDeviceConnectionStates.keySet()) {
                IotHubConnectionStatus status = this.multiplexedDeviceConnectionStates.get(deviceId).getConnectionStatus();
                if (status != IotHubConnectionStatus.DISCONNECTED_RETRYING) continue;
                return deviceId;
            }
            return null;
        }
        return previousDeviceSessionToReconnect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearInProgressMessages() {
        Object object = this.inProgressMessagesLock;
        synchronized (object) {
            if (this.inProgressPackets.size() > 0) {
                log.trace("Due to disconnection event, clearing active queues, and re-queueing them to waiting queues to be re-processed later upon reconnection");
                for (IotHubTransportPacket packetToRequeue : this.inProgressPackets.values()) {
                    this.addToWaitingQueue(packetToRequeue);
                }
                this.inProgressPackets.clear();
            }
        }
    }

    public void addMessage(Message message, MessageSentCallback callback, Object callbackContext, String deviceId) {
        if (this.connectionStatus == IotHubConnectionStatus.DISCONNECTED) {
            throw new IllegalStateException("Cannot add a message when the transport is closed.");
        }
        IotHubTransportPacket packet = new IotHubTransportPacket(message, callback, callbackContext, null, System.currentTimeMillis(), deviceId);
        this.addToWaitingQueue(packet);
        log.debug("Message was queued to be sent later ({})", (Object)message);
    }

    public IotHubClientProtocol getProtocol() {
        return this.protocol;
    }

    public void sendMessages() {
        this.checkForExpiredMessages();
        if (this.connectionStatus == IotHubConnectionStatus.DISCONNECTED || this.connectionStatus == IotHubConnectionStatus.DISCONNECTED_RETRYING) {
            return;
        }
        int timeSlice = this.maxNumberOfMessagesToSendPerThread;
        while (this.connectionStatus == IotHubConnectionStatus.CONNECTED && timeSlice-- > 0) {
            IotHubTransportPacket packet = this.waitingPacketsQueue.poll();
            if (packet == null) continue;
            Message message = packet.getMessage();
            log.trace("Dequeued a message from waiting queue to be sent ({})", (Object)message);
            if (message == null || !this.isMessageValid(packet)) continue;
            this.sendPacket(packet);
            try {
                CorrelationCallbackContext callbackContext;
                String correlationId = message.getCorrelationId();
                if (correlationId.isEmpty() || (callbackContext = this.correlationCallbacks.get(correlationId)) == null || callbackContext.getCallback() == null) continue;
                callbackContext.getCallback().onRequestSent(message, callbackContext.getUserContext());
            }
            catch (Exception e) {
                log.warn("Exception thrown while calling the onRequestSent callback in sendMessages", (Throwable)e);
            }
        }
    }

    String getTransportConnectionId() {
        return this.iotHubTransportConnection.getConnectionId();
    }

    String getDeviceClientUniqueIdentifier() {
        if (!this.isMultiplexing && this.getDefaultConfig() != null) {
            return this.hostName + "-" + this.getDefaultConfig().getDeviceClientUniqueIdentifier();
        }
        return this.hostName + "-Multiplexed-" + this.transportUniqueIdentifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForExpiredMessages() {
        IotHubTransportPacket packet = this.waitingPacketsQueue.poll();
        LinkedBlockingQueue<IotHubTransportPacket> packetsToAddBackIntoWaitingPacketsQueue = new LinkedBlockingQueue<IotHubTransportPacket>();
        while (packet != null) {
            if (packet.getMessage().isExpired()) {
                packet.setStatus(IotHubStatusCode.MESSAGE_EXPIRED);
                this.addToCallbackQueue(packet);
            } else {
                packetsToAddBackIntoWaitingPacketsQueue.add(packet);
            }
            packet = this.waitingPacketsQueue.poll();
        }
        this.waitingPacketsQueue.addAll(packetsToAddBackIntoWaitingPacketsQueue);
        Object object = this.inProgressMessagesLock;
        synchronized (object) {
            ArrayList<String> expiredPacketMessageIds = new ArrayList<String>();
            for (String messageId : this.inProgressPackets.keySet()) {
                if (!this.inProgressPackets.get(messageId).getMessage().isExpired()) continue;
                expiredPacketMessageIds.add(messageId);
            }
            for (String messageId : expiredPacketMessageIds) {
                IotHubTransportPacket expiredPacket = this.inProgressPackets.remove(messageId);
                expiredPacket.setStatus(IotHubStatusCode.MESSAGE_EXPIRED);
                this.addToCallbackQueue(expiredPacket);
            }
        }
    }

    private void checkForOldMessages() {
        try {
            Thread.currentThread().setName("azure-iot-sdk-IotHubCleanupTask");
            block2: while (true) {
                Thread.sleep(3600000L);
                ArrayList<String> correlationIdsToRemove = new ArrayList<String>();
                for (String correlationId : this.correlationCallbacks.keySet()) {
                    if (System.currentTimeMillis() - this.correlationCallbacks.get(correlationId).getStartTimeMillis() < 60000L) continue;
                    correlationIdsToRemove.add(correlationId);
                }
                Iterator<String> iterator = correlationIdsToRemove.iterator();
                while (true) {
                    String correlationId;
                    if (!iterator.hasNext()) continue block2;
                    correlationId = iterator.next();
                    this.correlationCallbacks.remove(correlationId);
                }
                break;
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public void invokeCallbacks() {
        IotHubTransportPacket packet = this.callbackPacketsQueue.poll();
        while (packet != null) {
            IotHubStatusCode status = packet.getStatus();
            MessageSentCallback callback = packet.getCallback();
            Object context = packet.getContext();
            log.debug("Invoking the callback function for sent message, IoT Hub responded to message ({}) with status {}", (Object)packet.getMessage(), (Object)status);
            IotHubClientException clientException = null;
            if (status != IotHubStatusCode.OK) {
                clientException = new IotHubClientException(status, "Received an unsuccessful operation error code from the service: " + (Object)((Object)status));
            }
            callback.onMessageSent(packet.getMessage(), clientException, context);
            packet = this.callbackPacketsQueue.poll();
        }
    }

    public void handleMessage() throws TransportException {
        if (this.connectionStatus == IotHubConnectionStatus.CONNECTED) {
            IotHubTransportMessage receivedMessage;
            if (this.iotHubTransportConnection instanceof HttpsIotHubConnection) {
                log.trace("Sending http request to check for any cloud to device messages...");
                this.addReceivedMessagesOverHttpToReceivedQueue();
            }
            if ((receivedMessage = this.receivedMessagesQueue.poll()) != null) {
                this.acknowledgeReceivedMessage(receivedMessage);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.inProgressMessagesLock;
        synchronized (object) {
            return this.waitingPacketsQueue.isEmpty() && this.inProgressPackets.size() == 0 && this.callbackPacketsQueue.isEmpty();
        }
    }

    public void setConnectionStatusChangeCallback(IotHubConnectionStatusChangeCallback callback, Object callbackContext, String deviceId) {
        if (callbackContext != null && callback == null) {
            throw new IllegalArgumentException("Callback cannot be null if callback context is null");
        }
        if (callback == null) {
            this.connectionStatusChangeCallbacks.remove(deviceId);
            this.connectionStatusChangeCallbackContexts.remove(deviceId);
        } else {
            this.connectionStatusChangeCallbacks.put(deviceId, callback);
            if (callbackContext != null) {
                this.connectionStatusChangeCallbackContexts.put(deviceId, callbackContext);
            }
        }
    }

    public void setMultiplexingConnectionStateCallback(IotHubConnectionStatusChangeCallback callback, Object callbackContext) {
        if (callback == null && callbackContext != null) {
            throw new IllegalArgumentException("Cannot have a null callback and a non-null context associated with it");
        }
        this.multiplexingStateCallback = callback;
        this.multiplexingStateCallbackContext = callbackContext;
    }

    public void registerMultiplexedDeviceClient(List<ClientConfiguration> configs, long timeoutMilliseconds) throws InterruptedException, IotHubClientException, MultiplexingClientRegistrationException {
        if (this.getProtocol() != IotHubClientProtocol.AMQPS && this.getProtocol() != IotHubClientProtocol.AMQPS_WS) {
            throw new UnsupportedOperationException("Cannot add a multiplexed device unless connection is over AMQPS or AMQPS_WS");
        }
        this.multiplexingDeviceRegistrationFailures.clear();
        for (ClientConfiguration configToRegister : configs) {
            this.deviceClientConfigs.put(configToRegister.getDeviceId(), configToRegister);
            this.multiplexedDeviceConnectionStates.put(configToRegister.getDeviceId(), new MultiplexedDeviceState(IotHubConnectionStatus.DISCONNECTED));
            if (this.iotHubTransportConnection == null) continue;
            ((AmqpsIotHubConnection)this.iotHubTransportConnection).registerMultiplexedDevice(configToRegister);
        }
        long timeoutTime = System.currentTimeMillis() + timeoutMilliseconds;
        MultiplexingClientRegistrationException registrationException = null;
        if (this.connectionStatus != IotHubConnectionStatus.DISCONNECTED) {
            for (ClientConfiguration newlyRegisteredConfig : configs) {
                String deviceId = newlyRegisteredConfig.getDeviceId();
                boolean deviceIsNotConnected = this.multiplexedDeviceConnectionStates.get(deviceId).getConnectionStatus() != IotHubConnectionStatus.CONNECTED;
                Exception deviceRegistrationException = this.multiplexingDeviceRegistrationFailures.remove(deviceId);
                while (deviceIsNotConnected && deviceRegistrationException == null) {
                    Thread.sleep(100L);
                    deviceIsNotConnected = this.multiplexedDeviceConnectionStates.get(deviceId).getConnectionStatus() != IotHubConnectionStatus.CONNECTED;
                    deviceRegistrationException = this.multiplexingDeviceRegistrationFailures.remove(deviceId);
                    boolean operationHasTimedOut = System.currentTimeMillis() >= timeoutTime;
                    if (!operationHasTimedOut) continue;
                    throw new IotHubClientException(IotHubStatusCode.DEVICE_OPERATION_TIMED_OUT, "Timed out waiting for all device registrations to finish.");
                }
                if (deviceRegistrationException == null) continue;
                if (registrationException == null) {
                    registrationException = new MultiplexingClientRegistrationException("Failed to register one or more devices to the multiplexed connection.");
                }
                registrationException.addRegistrationException(deviceId, deviceRegistrationException);
                ClientConfiguration configThatFailedToRegister = this.deviceClientConfigs.remove(deviceId);
                this.multiplexedDeviceConnectionStates.remove(deviceId);
                ((AmqpsIotHubConnection)this.iotHubTransportConnection).unregisterMultiplexedDevice(configThatFailedToRegister, false);
            }
            if (registrationException != null) {
                throw registrationException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterMultiplexedDeviceClient(List<ClientConfiguration> configs, long timeoutMilliseconds) throws InterruptedException, IotHubClientException {
        if (this.getProtocol() != IotHubClientProtocol.AMQPS && this.getProtocol() != IotHubClientProtocol.AMQPS_WS) {
            throw new UnsupportedOperationException("Cannot add a multiplexed device unless connection is over AMQPS or AMQPS_WS.");
        }
        for (ClientConfiguration configToRegister : configs) {
            if (this.iotHubTransportConnection != null) {
                ((AmqpsIotHubConnection)this.iotHubTransportConnection).unregisterMultiplexedDevice(configToRegister, false);
            } else {
                this.multiplexedDeviceConnectionStates.remove(configToRegister.getDeviceId());
            }
            this.deviceClientConfigs.remove(configToRegister.getDeviceId());
        }
        long timeoutTime = System.currentTimeMillis() + timeoutMilliseconds;
        if (this.connectionStatus != IotHubConnectionStatus.DISCONNECTED) {
            for (ClientConfiguration newlyUnregisteredConfig : configs) {
                while (this.multiplexedDeviceConnectionStates.get(newlyUnregisteredConfig.getDeviceId()).getConnectionStatus() != IotHubConnectionStatus.DISCONNECTED) {
                    Thread.sleep(100L);
                    boolean operationHasTimedOut = System.currentTimeMillis() >= timeoutTime;
                    if (!operationHasTimedOut) continue;
                    throw new IotHubClientException(IotHubStatusCode.DEVICE_OPERATION_TIMED_OUT, "Timed out waiting for all device unregistrations to finish.");
                }
                this.multiplexedDeviceConnectionStates.remove(newlyUnregisteredConfig.getDeviceId());
            }
        }
        for (IotHubTransportPacket waitingPacket : this.waitingPacketsQueue) {
            String deviceIdForMessage = waitingPacket.getDeviceId();
            for (ClientConfiguration unregisteredConfig : configs) {
                if (!unregisteredConfig.getDeviceId().equals(deviceIdForMessage)) continue;
                this.waitingPacketsQueue.remove(waitingPacket);
                waitingPacket.setStatus(IotHubStatusCode.MESSAGE_CANCELLED_ONCLOSE);
                this.addToCallbackQueue(waitingPacket);
            }
        }
        Object object = this.inProgressMessagesLock;
        synchronized (object) {
            for (String messageId : this.inProgressPackets.keySet()) {
                String deviceIdForMessage = this.inProgressPackets.get(messageId).getDeviceId();
                for (ClientConfiguration unregisteredConfig : configs) {
                    if (!unregisteredConfig.getDeviceId().equals(deviceIdForMessage)) continue;
                    IotHubTransportPacket cancelledPacket = this.inProgressPackets.remove(messageId);
                    cancelledPacket.setStatus(IotHubStatusCode.MESSAGE_CANCELLED_ONCLOSE);
                    this.addToCallbackQueue(cancelledPacket);
                }
            }
        }
    }

    public void setMaxNumberOfMessagesSentPerSendThread(int maxNumberOfMessagesSentPerSendThread) {
        if (maxNumberOfMessagesSentPerSendThread < 0) {
            throw new IllegalArgumentException("Maximum messages sent per thread cannot be negative");
        }
        this.maxNumberOfMessagesToSendPerThread = maxNumberOfMessagesSentPerSendThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelPendingPackets() {
        IotHubTransportPacket packet = this.waitingPacketsQueue.poll();
        while (packet != null) {
            packet.setStatus(IotHubStatusCode.MESSAGE_CANCELLED_ONCLOSE);
            this.addToCallbackQueue(packet);
            packet = this.waitingPacketsQueue.poll();
        }
        Object object = this.inProgressMessagesLock;
        synchronized (object) {
            for (Map.Entry<String, IotHubTransportPacket> packetEntry : this.inProgressPackets.entrySet()) {
                IotHubTransportPacket inProgressPacket = packetEntry.getValue();
                inProgressPacket.setStatus(IotHubStatusCode.MESSAGE_CANCELLED_ONCLOSE);
                this.addToCallbackQueue(inProgressPacket);
            }
            this.inProgressPackets.clear();
        }
    }

    private void acknowledgeReceivedMessage(IotHubTransportMessage receivedMessage) throws TransportException {
        MessageCallback messageCallback = receivedMessage.getMessageCallback();
        Object messageCallbackContext = receivedMessage.getMessageCallbackContext();
        if (messageCallback != null) {
            IotHubMessageResult result;
            try {
                log.debug("Executing callback for received message ({})", (Object)receivedMessage);
                result = messageCallback.onCloudToDeviceMessageReceived(receivedMessage, messageCallbackContext);
            }
            catch (Throwable ex) {
                log.warn("Exception thrown while calling the message callback for received message {} in acknowledgeReceivedMessage. This exception is preventing the completion of message delivery and can result in messages beingstuck in IoT hub until they expire. This can prevent the client from receiving futher messages.", (Object)receivedMessage, (Object)ex);
                throw ex;
            }
            try {
                log.debug("Sending acknowledgement for received cloud to device message ({})", (Object)receivedMessage);
                this.iotHubTransportConnection.sendMessageResult(receivedMessage, result);
                try {
                    String correlationId = receivedMessage.getCorrelationId();
                    if (!correlationId.isEmpty()) {
                        CorrelationCallbackContext callbackContext = this.correlationCallbacks.get(correlationId);
                        if (callbackContext != null && callbackContext.getCallback() != null) {
                            callbackContext.getCallback().onResponseAcknowledged(receivedMessage, callbackContext.getUserContext());
                        }
                        new Thread(() -> this.correlationCallbacks.remove(correlationId)).start();
                    }
                }
                catch (Exception ex) {
                    log.warn("Exception thrown while calling the onResponseAcknowledged callback in acknowledgeReceivedMessage", (Throwable)ex);
                }
            }
            catch (TransportException e) {
                log.warn("Sending acknowledgement for received cloud to device message failed, adding it back to the queue ({})", (Object)receivedMessage, (Object)e);
                this.addToReceivedMessagesQueue(receivedMessage);
                throw e;
            }
        }
    }

    private void addReceivedMessagesOverHttpToReceivedQueue() throws TransportException {
        IotHubTransportMessage transportMessage = ((HttpsIotHubConnection)this.iotHubTransportConnection).receiveMessage();
        if (transportMessage != null) {
            log.debug("Message was received from IotHub ({})", (Object)transportMessage);
            this.addToReceivedMessagesQueue(transportMessage);
            try {
                CorrelationCallbackContext callbackContext;
                String correlationId = transportMessage.getCorrelationId();
                if (!correlationId.isEmpty() && (callbackContext = this.correlationCallbacks.get(correlationId)) != null && callbackContext.getCallback() != null) {
                    callbackContext.getCallback().onResponseReceived(transportMessage, callbackContext.getUserContext(), null);
                }
            }
            catch (Exception e) {
                log.warn("Exception thrown while calling the onResponseReceived callback in addReceivedMessagesOverHttpToReceivedQueue", (Throwable)e);
            }
        }
    }

    private IotHubConnectionStatusChangeReason exceptionToStatusChangeReason(Throwable e) {
        if (e instanceof TransportException) {
            TransportException transportException = (TransportException)e;
            if (this.isSasTokenExpired()) {
                log.debug("Mapping throwable to EXPIRED_SAS_TOKEN because it was a non-retryable exception and the saved sas token has expired", e);
                return IotHubConnectionStatusChangeReason.EXPIRED_SAS_TOKEN;
            }
            if (e instanceof UnauthorizedException || e instanceof MqttUnauthorizedException || e instanceof AmqpUnauthorizedAccessException) {
                log.debug("Mapping throwable to BAD_CREDENTIAL because it was a non-retryable exception authorization exception but the saved sas token has not expired yet", e);
                return IotHubConnectionStatusChangeReason.BAD_CREDENTIAL;
            }
            if (transportException.isRetryable()) {
                log.debug("Mapping throwable to NO_NETWORK because it was a retryable exception", e);
                return IotHubConnectionStatusChangeReason.NO_NETWORK;
            }
        }
        log.debug("Mapping exception throwable to COMMUNICATION_ERROR because the sdk was unable to classify the thrown exception to anything other category", e);
        return IotHubConnectionStatusChangeReason.COMMUNICATION_ERROR;
    }

    private void openConnection() throws TransportException {
        if (this.iotHubTransportConnection == null) {
            switch (this.protocol) {
                case HTTPS: {
                    this.iotHubTransportConnection = new HttpsIotHubConnection(this.getDefaultConfig());
                    break;
                }
                case MQTT: 
                case MQTT_WS: {
                    this.iotHubTransportConnection = new MqttIotHubConnection(this.getDefaultConfig());
                    break;
                }
                case AMQPS: 
                case AMQPS_WS: {
                    if (this.isMultiplexing) {
                        this.iotHubTransportConnection = new AmqpsIotHubConnection(this.hostName, this.transportUniqueIdentifier, this.protocol == IotHubClientProtocol.AMQPS_WS, this.sslContext, this.proxySettings, this.keepAliveInterval, this.sendInterval, this.useIdentifiableThreadNames, this.threadNamePrefix, this.threadNameSuffix);
                        for (ClientConfiguration config : this.deviceClientConfigs.values()) {
                            ((AmqpsIotHubConnection)this.iotHubTransportConnection).registerMultiplexedDevice(config);
                        }
                        break;
                    }
                    this.iotHubTransportConnection = new AmqpsIotHubConnection(this.getDefaultConfig(), this.transportUniqueIdentifier);
                    break;
                }
                default: {
                    throw new TransportException("Protocol not supported");
                }
            }
        }
        this.iotHubTransportConnection.setListener(this);
        this.iotHubTransportConnection.open();
        this.updateStatus(IotHubConnectionStatus.CONNECTED, IotHubConnectionStatusChangeReason.CONNECTION_OK, null);
    }

    private void singleDeviceReconnectAttemptAsync(String deviceSessionToReconnect) throws InterruptedException {
        MultiplexedDeviceState multiplexedDeviceState = this.multiplexedDeviceConnectionStates.get(deviceSessionToReconnect);
        if (multiplexedDeviceState.getConnectionStatus() == IotHubConnectionStatus.DISCONNECTED_RETRYING) {
            TransportException transportException = IotHubTransport.getTransportExceptionFromThrowable(multiplexedDeviceState.getLastException());
            if (multiplexedDeviceState.getReconnectionAttemptNumber() == 0) {
                multiplexedDeviceState.setStartReconnectTime(System.currentTimeMillis());
            }
            if (this.hasOperationTimedOut(multiplexedDeviceState.getStartReconnectTime())) {
                this.updateStatus(IotHubConnectionStatus.DISCONNECTED, IotHubConnectionStatusChangeReason.RETRY_EXPIRED, transportException, deviceSessionToReconnect);
                log.debug("Reconnection for device {} was abandoned due to the operation timeout", (Object)deviceSessionToReconnect);
            }
            multiplexedDeviceState.incrementReconnectionAttemptNumber();
            ClientConfiguration config = this.getConfig(deviceSessionToReconnect);
            if (config == null) {
                log.debug("Reconnection for device {} was abandoned because it was unregistered while reconnecting", (Object)deviceSessionToReconnect);
                return;
            }
            RetryPolicy retryPolicy = config.getRetryPolicy();
            RetryDecision retryDecision = retryPolicy.getRetryDecision(multiplexedDeviceState.getReconnectionAttemptNumber(), transportException);
            if (!retryDecision.shouldRetry()) {
                this.updateStatus(IotHubConnectionStatus.DISCONNECTED, IotHubConnectionStatusChangeReason.RETRY_EXPIRED, transportException, deviceSessionToReconnect);
                log.debug("Reconnection for device {} was abandoned due to the retry policy", (Object)deviceSessionToReconnect);
            }
            log.trace("Attempting to reconnect device session: attempt {}", (Object)multiplexedDeviceState.getReconnectionAttemptNumber());
            ((AmqpsIotHubConnection)this.iotHubTransportConnection).unregisterMultiplexedDevice(config, true);
            ((AmqpsIotHubConnection)this.iotHubTransportConnection).registerMultiplexedDevice(config);
            log.trace("Sleeping between device reconnect attempts for device {}", (Object)deviceSessionToReconnect);
            TimeUnit.MILLISECONDS.sleep(retryDecision.getDuration());
            if (!transportException.isRetryable()) {
                this.updateStatus(IotHubConnectionStatus.DISCONNECTED, this.exceptionToStatusChangeReason(transportException), transportException, deviceSessionToReconnect);
                log.error("Reconnection for device {} was abandoned due to encountering a non-retryable exception", (Object)deviceSessionToReconnect, (Object)transportException);
            }
        }
    }

    private ClientConfiguration getConfig(String deviceId) {
        return this.deviceClientConfigs.get(deviceId);
    }

    private void singleReconnectAttempt(RetryPolicy retryPolicy, int reconnectionAttempt, long reconnectionStartTimeMillis) throws InterruptedException {
        if (this.hasOperationTimedOut(reconnectionStartTimeMillis)) {
            log.debug("Reconnection was abandoned due to the operation timeout");
            this.close(IotHubConnectionStatusChangeReason.RETRY_EXPIRED, new IotHubClientException(IotHubStatusCode.DEVICE_OPERATION_TIMED_OUT, "Device operation for reconnection timed out"));
            return;
        }
        TransportException transportException = IotHubTransport.getTransportExceptionFromThrowable(this.connectionStatusLastException);
        log.trace("Attempting reconnect attempt {}", (Object)reconnectionAttempt);
        RetryDecision retryDecision = retryPolicy.getRetryDecision(reconnectionAttempt, transportException);
        if (!retryDecision.shouldRetry()) {
            log.debug("Reconnection was abandoned due to the retry policy");
            this.close(IotHubConnectionStatusChangeReason.RETRY_EXPIRED, transportException);
            return;
        }
        log.trace("Sleeping between reconnect attempts");
        TimeUnit.MILLISECONDS.sleep(retryDecision.getDuration());
        try {
            log.trace("Attempting to close and re-open the iot hub transport connection...");
            this.iotHubTransportConnection.close();
            this.openConnection();
            log.trace("Successfully closed and re-opened the iot hub transport connection");
        }
        catch (TransportException newTransportException) {
            this.checkForUnauthorizedException(newTransportException);
            log.warn("Failed to close and re-open the iot hub transport connection, checking if another retry attempt should be made", (Throwable)newTransportException);
            transportException = newTransportException;
        }
        if (!transportException.isRetryable()) {
            log.error("Reconnection was abandoned due to encountering a non-retryable exception", (Throwable)transportException);
            this.close(this.exceptionToStatusChangeReason(transportException), transportException);
        }
    }

    private void handleMessageException(IotHubTransportPacket packet, TransportException transportException) {
        log.warn("Handling an exception from sending message: Attempt number {}", (Object)packet.getCurrentRetryAttempt(), (Object)transportException);
        packet.incrementRetryAttempt();
        if (!this.hasOperationTimedOut(packet.getStartTimeMillis())) {
            String deviceId = packet.getDeviceId();
            if (transportException.isRetryable()) {
                ClientConfiguration config = this.getConfig(deviceId);
                if (config == null) {
                    log.debug("Abandoning handling the message exception since the device it was associated with has been unregistered.");
                    return;
                }
                RetryDecision retryDecision = config.getRetryPolicy().getRetryDecision(packet.getCurrentRetryAttempt(), transportException);
                if (retryDecision.shouldRetry()) {
                    this.taskScheduler.schedule(new MessageRetryRunnable(this.waitingPacketsQueue, packet, this.sendThreadSemaphore), retryDecision.getDuration(), TimeUnit.MILLISECONDS);
                    return;
                }
                log.warn("Retry policy dictated that the message should be abandoned, so it has been abandoned ({})", (Object)packet.getMessage(), (Object)transportException);
            } else {
                log.warn("Encountering an non-retryable exception while sending a message, so it has been abandoned ({})", (Object)packet.getMessage(), (Object)transportException);
            }
        } else {
            log.warn("The device operation timeout has been exceeded for the message, so it has been abandoned ({})", (Object)packet.getMessage(), (Object)transportException);
        }
        packet.setStatus(transportException.toIotHubClientException().getStatusCode());
        this.addToCallbackQueue(packet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPacket(IotHubTransportPacket packet) {
        Message message = packet.getMessage();
        boolean messageAckExpected = !(message instanceof IotHubTransportMessage) || ((IotHubTransportMessage)message).isMessageAckNeeded(this.protocol);
        try {
            if (messageAckExpected) {
                Object object = this.inProgressMessagesLock;
                synchronized (object) {
                    log.trace("Adding transport message to the inProgressPackets to wait for acknowledgement ({})", (Object)message);
                    this.inProgressPackets.put(message.getMessageId(), packet);
                }
            }
            log.debug("Sending message ({})", (Object)message);
            IotHubStatusCode statusCode = this.iotHubTransportConnection.sendMessage(message);
            log.trace("Sent message ({}) to protocol level, returned status code was {}", (Object)message, (Object)statusCode);
            if (statusCode != IotHubStatusCode.OK) {
                this.inProgressPackets.remove(message.getMessageId());
                this.handleMessageException(packet, IotHubStatusCode.getConnectionStatusException(statusCode, ""));
            } else if (!messageAckExpected) {
                packet.setStatus(statusCode);
                this.addToCallbackQueue(packet);
            }
        }
        catch (TransportException transportException) {
            log.warn("Encountered exception while sending message with correlation id {}", (Object)message.getCorrelationId(), (Object)transportException);
            if (messageAckExpected) {
                Object object = this.inProgressMessagesLock;
                synchronized (object) {
                    this.inProgressPackets.remove(message.getMessageId());
                }
            }
            this.handleMessageException(packet, transportException);
        }
    }

    private boolean isMessageValid(IotHubTransportPacket packet) {
        Message message = packet.getMessage();
        if (message.isExpired()) {
            log.warn("Message with has expired, adding to callbacks queue with MESSAGE_EXPIRED ({})", (Object)message);
            packet.setStatus(IotHubStatusCode.MESSAGE_EXPIRED);
            this.addToCallbackQueue(packet);
            return false;
        }
        return true;
    }

    private void updateStatus(IotHubConnectionStatus newConnectionStatus, IotHubConnectionStatusChangeReason reason, Throwable throwable) {
        if (this.connectionStatus != newConnectionStatus) {
            if (throwable == null) {
                log.debug("Updating transport status to new status {} with reason {}", (Object)newConnectionStatus, (Object)reason);
            } else {
                log.warn("Updating transport status to new status {} with reason {}", new Object[]{newConnectionStatus, reason, throwable});
            }
            ConnectionStatusChangeContext connectionStatusChangeContext = new ConnectionStatusChangeContext(newConnectionStatus, this.connectionStatus, reason, throwable, null);
            this.connectionStatus = newConnectionStatus;
            this.connectionStatusLastException = throwable;
            this.deviceIOConnectionStatusChangeCallback.onStatusChanged(connectionStatusChangeContext);
            log.debug("Invoking connection status callbacks with new status details");
            if (!this.isMultiplexing || newConnectionStatus != IotHubConnectionStatus.CONNECTED) {
                this.invokeConnectionStatusChangeCallback(newConnectionStatus, reason, throwable);
                for (ClientConfiguration config : this.deviceClientConfigs.values()) {
                    MultiplexedDeviceState deviceState = this.multiplexedDeviceConnectionStates.get(config.getDeviceId());
                    deviceState.setConnectionStatus(newConnectionStatus);
                    deviceState.setReconnectionAttemptNumber(0);
                }
            }
            if (this.isMultiplexing && this.multiplexingStateCallback != null) {
                this.multiplexingStateCallback.onStatusChanged(connectionStatusChangeContext);
            }
            if (newConnectionStatus == IotHubConnectionStatus.CONNECTED) {
                try {
                    this.correlationCallbackCleanupThread.start();
                }
                catch (IllegalThreadStateException illegalThreadStateException) {}
            } else if (newConnectionStatus == IotHubConnectionStatus.DISCONNECTED) {
                this.correlationCallbackCleanupThread.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStatus(IotHubConnectionStatus newConnectionStatus, IotHubConnectionStatusChangeReason reason, Throwable throwable, String deviceId) {
        if (!this.multiplexedDeviceConnectionStates.containsKey(deviceId)) {
            return;
        }
        IotHubConnectionStatus previousStatus = this.multiplexedDeviceConnectionStates.get(deviceId).getConnectionStatus();
        if (previousStatus == newConnectionStatus) {
            return;
        }
        if (throwable == null) {
            log.debug("Updating device {} status to new status {} with reason {}", new Object[]{deviceId, newConnectionStatus, reason});
        } else {
            log.warn("Updating device {} status to new status {} with reason {}", new Object[]{deviceId, newConnectionStatus, reason, throwable});
        }
        Object object = this.multiplexingDeviceStateLock;
        synchronized (object) {
            MultiplexedDeviceState deviceState = new MultiplexedDeviceState(newConnectionStatus, throwable);
            if (newConnectionStatus == IotHubConnectionStatus.DISCONNECTED_RETRYING) {
                deviceState.setReconnectionAttemptNumber(0);
            }
            this.multiplexedDeviceConnectionStates.put(deviceId, deviceState);
            log.debug("Invoking connection status callbacks with new status details");
            this.invokeConnectionStatusChangeCallback(newConnectionStatus, previousStatus, reason, throwable, deviceId);
        }
        if (newConnectionStatus == IotHubConnectionStatus.CONNECTED) {
            try {
                this.correlationCallbackCleanupThread.start();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {}
        } else if (newConnectionStatus == IotHubConnectionStatus.DISCONNECTED) {
            this.correlationCallbackCleanupThread.interrupt();
        }
    }

    private void invokeConnectionStatusChangeCallback(IotHubConnectionStatus status, IotHubConnectionStatusChangeReason reason, Throwable e) {
        for (String registeredDeviceId : this.connectionStatusChangeCallbacks.keySet()) {
            MultiplexedDeviceState multiplexedDeviceState = this.multiplexedDeviceConnectionStates.get(registeredDeviceId);
            if (multiplexedDeviceState == null || multiplexedDeviceState.getConnectionStatus() == status) continue;
            ConnectionStatusChangeContext connectionStatusChangeContext = new ConnectionStatusChangeContext(status, multiplexedDeviceState.getConnectionStatus(), reason, e, this.connectionStatusChangeCallbackContexts.get(registeredDeviceId));
            this.connectionStatusChangeCallbacks.get(registeredDeviceId).onStatusChanged(connectionStatusChangeContext);
        }
    }

    private void invokeConnectionStatusChangeCallback(IotHubConnectionStatus newStatus, IotHubConnectionStatus previousStatus, IotHubConnectionStatusChangeReason reason, Throwable e, String deviceId) {
        if (deviceId == null) {
            for (String registeredDeviceId : this.connectionStatusChangeCallbacks.keySet()) {
                ConnectionStatusChangeContext connectionStatusChangeContext = new ConnectionStatusChangeContext(newStatus, previousStatus, reason, e, this.connectionStatusChangeCallbackContexts.get(registeredDeviceId));
                this.connectionStatusChangeCallbacks.get(registeredDeviceId).onStatusChanged(connectionStatusChangeContext);
            }
        } else if (this.connectionStatusChangeCallbacks.containsKey(deviceId)) {
            ConnectionStatusChangeContext connectionStatusChangeContext = new ConnectionStatusChangeContext(newStatus, previousStatus, reason, e, this.connectionStatusChangeCallbackContexts.get(deviceId));
            this.connectionStatusChangeCallbacks.get(deviceId).onStatusChanged(connectionStatusChangeContext);
        } else {
            log.trace("Device {} did not have a connection status change callback registered, so no callback was fired.", (Object)deviceId);
        }
    }

    private boolean isAuthenticationProviderExpired() {
        if (this.getDefaultConfig() == null) {
            return false;
        }
        return this.getDefaultConfig().getAuthenticationType() == ClientConfiguration.AuthType.SAS_TOKEN && this.getDefaultConfig().getSasTokenAuthentication().isAuthenticationProviderRenewalNecessary();
    }

    private boolean isSasTokenExpired() {
        if (this.getDefaultConfig() == null) {
            return false;
        }
        return this.getDefaultConfig().getAuthenticationType() == ClientConfiguration.AuthType.SAS_TOKEN && this.getDefaultConfig().getSasTokenAuthentication().isSasTokenExpired();
    }

    private boolean hasOperationTimedOut(long startTime) {
        if (startTime == 0L || this.getDefaultConfig() == null) {
            return false;
        }
        return System.currentTimeMillis() - startTime > this.getDefaultConfig().getOperationTimeout();
    }

    private boolean hasOperationTimedOut(long startTime, String deviceId) {
        if (startTime == 0L) {
            return false;
        }
        ClientConfiguration config = this.getConfig(deviceId);
        if (config == null) {
            log.debug("Operation has not timed out since the device it was associated with has been unregistered already.");
            return false;
        }
        return System.currentTimeMillis() - startTime > config.getOperationTimeout();
    }

    private void addToCallbackQueue(IotHubTransportPacket packet) {
        if (packet.getCallback() != null) {
            this.callbackPacketsQueue.add(packet);
            this.sendThreadSemaphore.release();
        }
    }

    private ClientConfiguration getDefaultConfig() {
        Iterator<ClientConfiguration> iterator = this.deviceClientConfigs.values().iterator();
        if (iterator.hasNext()) {
            ClientConfiguration config = iterator.next();
            return config;
        }
        return null;
    }

    private void addToWaitingQueue(IotHubTransportPacket packet) {
        try {
            Message message;
            if (packet != null && (message = packet.getMessage()) != null) {
                String correlationId = message.getCorrelationId();
                CorrelatingMessageCallback correlationCallback = message.getCorrelatingMessageCallback();
                if (!correlationId.isEmpty() && correlationCallback != null) {
                    Object correlationCallbackContext = message.getCorrelatingMessageCallbackContext();
                    this.correlationCallbacks.put(correlationId, new CorrelationCallbackContext(correlationCallback, correlationCallbackContext, System.currentTimeMillis()));
                    correlationCallback.onRequestQueued(message, correlationCallbackContext);
                }
            }
        }
        catch (Exception ex) {
            log.warn("Exception thrown while calling the onQueueRequest callback in addToWaitingQueue", (Throwable)ex);
        }
        this.waitingPacketsQueue.add(packet);
        this.sendThreadSemaphore.release();
    }

    private void addToReceivedMessagesQueue(IotHubTransportMessage message) {
        this.receivedMessagesQueue.add(message);
        this.receiveThreadSemaphore.release();
    }

    private void checkForUnauthorizedException(TransportException transportException) {
        if (!this.isAuthenticationProviderExpired() && (transportException instanceof MqttUnauthorizedException || transportException instanceof UnauthorizedException || transportException instanceof AmqpUnauthorizedAccessException)) {
            transportException.setRetryable(true);
        }
    }

    private static TransportException getTransportExceptionFromThrowable(Throwable cause) {
        if (cause instanceof TransportException) {
            return (TransportException)cause;
        }
        TransportException transportException = new TransportException(cause);
        transportException.setRetryable(true);
        return transportException;
    }

    public static class MessageRetryRunnable
    implements Runnable {
        final IotHubTransportPacket transportPacket;
        final Queue<IotHubTransportPacket> waitingPacketsQueue;
        final Semaphore sendThreadSemaphore;

        MessageRetryRunnable(Queue<IotHubTransportPacket> waitingPacketsQueue, IotHubTransportPacket transportPacket, Semaphore sendThreadSemaphore) {
            this.waitingPacketsQueue = waitingPacketsQueue;
            this.transportPacket = transportPacket;
            this.sendThreadSemaphore = sendThreadSemaphore;
        }

        @Override
        public void run() {
            this.waitingPacketsQueue.add(this.transportPacket);
            this.sendThreadSemaphore.release();
        }
    }
}

