/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.auth;

import com.microsoft.azure.sdk.iot.device.auth.IotHubSasToken;
import com.microsoft.azure.sdk.iot.device.auth.IotHubSasTokenAuthenticationProvider;
import javax.net.ssl.SSLContext;

public class IotHubSasTokenSoftwareAuthenticationProvider
extends IotHubSasTokenAuthenticationProvider {
    private final String deviceKey;

    public IotHubSasTokenSoftwareAuthenticationProvider(String hostname, String gatewayHostname, String deviceId, String moduleId, String deviceKey, String sharedAccessToken, int tokenValidSecs, int timeBufferPercentage) {
        super(hostname, gatewayHostname, deviceId, moduleId, tokenValidSecs, timeBufferPercentage);
        this.deviceKey = deviceKey;
        this.sasToken = new IotHubSasToken(hostname, deviceId, deviceKey, sharedAccessToken, moduleId, this.getExpiryTimeInSeconds());
    }

    public IotHubSasTokenSoftwareAuthenticationProvider(String hostname, String gatewayHostname, String deviceId, String moduleId, String deviceKey, String sharedAccessToken) {
        super(hostname, gatewayHostname, deviceId, moduleId);
        this.deviceKey = deviceKey;
        this.sasToken = new IotHubSasToken(hostname, deviceId, deviceKey, sharedAccessToken, moduleId, this.getExpiryTimeInSeconds());
    }

    public IotHubSasTokenSoftwareAuthenticationProvider(String hostname, String gatewayHostname, String deviceId, String moduleId, String deviceKey, String sharedAccessToken, SSLContext sslContext) {
        super(hostname, gatewayHostname, deviceId, moduleId, sslContext);
        this.deviceKey = deviceKey;
        this.sasToken = new IotHubSasToken(hostname, deviceId, deviceKey, sharedAccessToken, moduleId, this.getExpiryTimeInSeconds());
    }

    @Override
    public boolean isAuthenticationProviderRenewalNecessary() {
        return super.isAuthenticationProviderRenewalNecessary() && this.deviceKey == null;
    }

    @Override
    public void setTokenValidSecs(long tokenValidSecs) {
        super.setTokenValidSecs(tokenValidSecs);
        if (this.deviceKey != null) {
            this.sasToken = new IotHubSasToken(this.hostname, this.deviceId, this.deviceKey, null, this.moduleId, this.getExpiryTimeInSeconds());
        }
    }

    @Override
    public boolean canRefreshToken() {
        return this.deviceKey != null;
    }

    @Override
    public char[] getSasToken() {
        if (this.deviceKey != null) {
            this.sasToken = new IotHubSasToken(this.hostname, this.deviceId, this.deviceKey, null, this.moduleId, this.getExpiryTimeInSeconds());
        }
        return this.sasToken.toString().toCharArray();
    }
}

