/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IotHubConnectionString {
    private static final Logger log = LoggerFactory.getLogger(IotHubConnectionString.class);
    private static final String HOSTNAME_ATTRIBUTE = "HostName=";
    private static final String DEVICE_ID_ATTRIBUTE = "DeviceId=";
    private static final String SHARED_ACCESS_KEY_ATTRIBUTE = "SharedAccessKey=";
    private static final String SHARED_ACCESS_TOKEN_ATTRIBUTE = "SharedAccessSignature=";
    private static final String MODULE_ID_ATTRIBUTE = "ModuleId=";
    private static final String GATEWAY_HOST_NAME_ATTRIBUTE = "GatewayHostName=";
    private static final String X509_ENABLED_ATTRIBUTE = "x509=true";
    private static final Charset CONNECTION_STRING_CHARSET = StandardCharsets.UTF_8;
    private String hostName;
    private final String hubName;
    private String deviceId;
    private String sharedAccessKey;
    private String sharedAccessToken;
    private String moduleId;
    private final boolean isUsingX509;
    private String gatewayHostName;

    public IotHubConnectionString(String connectionString) throws IllegalArgumentException {
        String[] connStringAttrs;
        if (connectionString == null || connectionString.isEmpty()) {
            throw new IllegalArgumentException("The connection string cannot be null or empty.");
        }
        for (String attr : connStringAttrs = connectionString.split(";")) {
            if (attr.toLowerCase().startsWith(HOSTNAME_ATTRIBUTE.toLowerCase())) {
                this.hostName = attr.substring(HOSTNAME_ATTRIBUTE.length());
                continue;
            }
            if (attr.toLowerCase().startsWith(DEVICE_ID_ATTRIBUTE.toLowerCase())) {
                String urlEncodedDeviceId = attr.substring(DEVICE_ID_ATTRIBUTE.length());
                try {
                    this.deviceId = URLDecoder.decode(urlEncodedDeviceId, CONNECTION_STRING_CHARSET.name());
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalStateException(e);
                }
            }
            if (attr.toLowerCase().startsWith(SHARED_ACCESS_KEY_ATTRIBUTE.toLowerCase())) {
                this.sharedAccessKey = attr.substring(SHARED_ACCESS_KEY_ATTRIBUTE.length());
                continue;
            }
            if (attr.toLowerCase().startsWith(SHARED_ACCESS_TOKEN_ATTRIBUTE.toLowerCase())) {
                this.sharedAccessToken = attr.substring(SHARED_ACCESS_TOKEN_ATTRIBUTE.length());
                continue;
            }
            if (attr.toLowerCase().startsWith(MODULE_ID_ATTRIBUTE.toLowerCase())) {
                this.moduleId = attr.substring(MODULE_ID_ATTRIBUTE.length());
                continue;
            }
            if (!attr.toLowerCase().startsWith(GATEWAY_HOST_NAME_ATTRIBUTE.toLowerCase())) continue;
            this.gatewayHostName = attr.substring(GATEWAY_HOST_NAME_ATTRIBUTE.length());
        }
        this.isUsingX509 = connectionString.contains(X509_ENABLED_ATTRIBUTE);
        IotHubConnectionString.validateTerms(this.hostName, this.deviceId, this.sharedAccessKey, this.sharedAccessToken, this.isUsingX509);
        this.hubName = IotHubConnectionString.parseHubName(this.hostName);
    }

    public IotHubConnectionString(String hostName, String deviceId, String sharedAccessKey, String sharedAccessToken) throws IllegalArgumentException {
        this(hostName, deviceId, sharedAccessKey, sharedAccessToken, null);
    }

    private IotHubConnectionString(String hostName, String deviceId, String sharedAccessKey, String sharedAccessToken, String gatewayHostName) throws IllegalArgumentException {
        this.isUsingX509 = sharedAccessKey == null && sharedAccessToken == null;
        IotHubConnectionString.validateTerms(hostName, deviceId, sharedAccessKey, sharedAccessToken, this.isUsingX509);
        this.hostName = hostName;
        this.hubName = IotHubConnectionString.parseHubName(this.hostName);
        this.deviceId = deviceId;
        this.sharedAccessKey = sharedAccessKey;
        this.sharedAccessToken = sharedAccessToken;
        this.gatewayHostName = gatewayHostName;
        if (this.gatewayHostName != null && !this.gatewayHostName.isEmpty()) {
            this.hostName = gatewayHostName;
        }
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getGatewayHostName() {
        return this.gatewayHostName;
    }

    public String getHubName() {
        return this.hubName;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getSharedAccessKey() {
        return this.sharedAccessKey;
    }

    public String getSharedAccessToken() {
        return this.sharedAccessToken;
    }

    public String getModuleId() {
        return this.moduleId;
    }

    public boolean isUsingX509() {
        return this.isUsingX509;
    }

    public void setSharedAccessToken(String sharedAccessToken) throws IllegalArgumentException {
        if (sharedAccessToken == null || sharedAccessToken.isEmpty()) {
            throw new IllegalArgumentException("Shared access token cannot be set to null or empty");
        }
        this.sharedAccessToken = sharedAccessToken;
    }

    private static void validateTerms(String hostName, String deviceId, String sharedAccessKey, String sharedAccessToken, boolean usingX509) throws IllegalArgumentException {
        if (hostName == null || hostName.isEmpty()) {
            throw new IllegalArgumentException("IoT Hub hostName cannot be null.");
        }
        try {
            new URI(hostName);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Host name did not contain a valid URI", e);
        }
        IotHubConnectionString.parseHubName(hostName);
        if (deviceId == null || deviceId.isEmpty()) {
            throw new IllegalArgumentException("Device ID cannot be null.");
        }
        if (sharedAccessKey != null && sharedAccessToken != null) {
            throw new IllegalArgumentException("Either of device key or Shared Access Signature should be provided, but not both.");
        }
        if (!(usingX509 || sharedAccessKey != null && !sharedAccessKey.isEmpty() || sharedAccessToken != null && !sharedAccessToken.isEmpty())) {
            throw new IllegalArgumentException("Device key and Shared Access Signature both cannot be null unless using x509 authentication.");
        }
    }

    static String parseHubName(String hostName) throws IllegalArgumentException {
        int iotHubNameEndIdx = hostName.indexOf(".");
        if (iotHubNameEndIdx == -1) {
            String errStr = "Provided hostname did not include a valid IoT Hub name as its prefix. An IoT Hub hostname has the following format: [iotHubName].[valid URI chars]";
            throw new IllegalArgumentException(errStr);
        }
        return hostName.substring(0, iotHubNameEndIdx);
    }
}

