/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device;

import com.microsoft.azure.sdk.iot.device.ClientOptions;
import com.microsoft.azure.sdk.iot.device.DeviceClientType;
import com.microsoft.azure.sdk.iot.device.FileUpload;
import com.microsoft.azure.sdk.iot.device.FileUploadCompletionNotification;
import com.microsoft.azure.sdk.iot.device.FileUploadSasUriRequest;
import com.microsoft.azure.sdk.iot.device.FileUploadSasUriResponse;
import com.microsoft.azure.sdk.iot.device.InternalClient;
import com.microsoft.azure.sdk.iot.device.IotHubClientProtocol;
import com.microsoft.azure.sdk.iot.device.IotHubConnectionString;
import com.microsoft.azure.sdk.iot.device.MessageCallback;
import com.microsoft.azure.sdk.iot.device.SasTokenProvider;
import com.microsoft.azure.sdk.iot.device.exceptions.IotHubClientException;
import com.microsoft.azure.sdk.iot.device.transport.TransportUtils;
import com.microsoft.azure.sdk.iot.device.transport.https.HttpsTransportManager;
import com.microsoft.azure.sdk.iot.provisioning.security.SecurityProvider;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DeviceClient
extends InternalClient {
    private static final Logger log = LoggerFactory.getLogger(DeviceClient.class);
    private DeviceClientType deviceClientType = DeviceClientType.SINGLE_CLIENT;
    private FileUpload fileUpload;
    private static final String MULTIPLEXING_CLOSE_ERROR_MESSAGE = "Cannot close a multiplexed client through this method. Must use multiplexingClient.unregisterDeviceClient(deviceClient)";
    private static final String MULTIPLEXING_OPEN_ERROR_MESSAGE = "Cannot open a multiplexed client through this method. Must use multiplexingClient.registerDeviceClient(deviceClient)";

    public DeviceClient(String connectionString, IotHubClientProtocol protocol) throws IllegalArgumentException {
        this(connectionString, protocol, null);
    }

    public DeviceClient(String connectionString, IotHubClientProtocol protocol, ClientOptions clientOptions) throws IllegalArgumentException {
        super(new IotHubConnectionString(connectionString), protocol, clientOptions);
        this.commonConstructorVerifications();
        this.commonConstructorSetup();
    }

    public DeviceClient(String hostName, String deviceId, SasTokenProvider sasTokenProvider, IotHubClientProtocol protocol) {
        this(hostName, deviceId, sasTokenProvider, protocol, null);
    }

    public DeviceClient(String hostName, String deviceId, SasTokenProvider sasTokenProvider, IotHubClientProtocol protocol, ClientOptions clientOptions) {
        super(hostName, deviceId, null, sasTokenProvider, protocol, clientOptions);
        this.commonConstructorVerifications();
        this.commonConstructorSetup();
    }

    public DeviceClient(String uri, String deviceId, SecurityProvider securityProvider, IotHubClientProtocol protocol) throws IOException {
        this(uri, deviceId, securityProvider, protocol, null);
    }

    public DeviceClient(String uri, String deviceId, SecurityProvider securityProvider, IotHubClientProtocol protocol, ClientOptions clientOptions) throws IOException {
        super(uri, deviceId, securityProvider, protocol, clientOptions);
        this.commonConstructorSetup();
    }

    public DeviceClient setMessageCallback(MessageCallback callback, Object context) throws IllegalArgumentException {
        this.setMessageCallbackInternal(callback, context);
        return this;
    }

    private void commonConstructorSetup() {
        log.debug("Initialized a DeviceClient instance using SDK version {}", (Object)TransportUtils.CLIENT_VERSION);
    }

    private void commonConstructorVerifications() throws UnsupportedOperationException {
        if (this.getConfig().getModuleId() != null && !this.getConfig().getModuleId().isEmpty()) {
            throw new UnsupportedOperationException("DeviceClient connection string cannot contain module id. Use ModuleClient instead.");
        }
    }

    @Override
    public void open(boolean withRetry) throws IotHubClientException {
        if (this.deviceClientType == DeviceClientType.USE_MULTIPLEXING_CLIENT) {
            throw new UnsupportedOperationException(MULTIPLEXING_OPEN_ERROR_MESSAGE);
        }
        super.open(withRetry);
        log.info("Device client opened successfully");
    }

    @Override
    public void close() {
        if (this.deviceClientType == DeviceClientType.USE_MULTIPLEXING_CLIENT) {
            throw new UnsupportedOperationException(MULTIPLEXING_CLOSE_ERROR_MESSAGE);
        }
        log.info("Closing device client...");
        super.close();
        log.info("Device client closed successfully");
    }

    public FileUploadSasUriResponse getFileUploadSasUri(FileUploadSasUriRequest request) throws IotHubClientException {
        if (this.fileUpload == null) {
            this.fileUpload = new FileUpload(new HttpsTransportManager(this.config));
        }
        return this.fileUpload.getFileUploadSasUri(request);
    }

    public void completeFileUpload(FileUploadCompletionNotification notification) throws IotHubClientException {
        if (this.fileUpload == null) {
            this.fileUpload = new FileUpload(new HttpsTransportManager(this.config));
        }
        this.fileUpload.sendNotification(notification);
    }

    public boolean isMultiplexed() {
        return this.isMultiplexed;
    }

    void markAsMultiplexed() {
        this.deviceClientType = DeviceClientType.USE_MULTIPLEXING_CLIENT;
    }

    private DeviceClient() {
    }
}

