/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device;

import com.microsoft.azure.sdk.iot.device.ClientOptions;
import com.microsoft.azure.sdk.iot.device.IotHubClientProtocol;
import com.microsoft.azure.sdk.iot.device.IotHubConnectionString;
import com.microsoft.azure.sdk.iot.device.MessageCallback;
import com.microsoft.azure.sdk.iot.device.ProductInfo;
import com.microsoft.azure.sdk.iot.device.ProxySettings;
import com.microsoft.azure.sdk.iot.device.SasTokenProvider;
import com.microsoft.azure.sdk.iot.device.auth.IotHubAuthenticationProvider;
import com.microsoft.azure.sdk.iot.device.auth.IotHubSasTokenAuthenticationProvider;
import com.microsoft.azure.sdk.iot.device.auth.IotHubSasTokenHardwareAuthenticationProvider;
import com.microsoft.azure.sdk.iot.device.auth.IotHubSasTokenProvidedAuthenticationProvider;
import com.microsoft.azure.sdk.iot.device.auth.IotHubSasTokenSoftwareAuthenticationProvider;
import com.microsoft.azure.sdk.iot.device.auth.IotHubX509HardwareAuthenticationProvider;
import com.microsoft.azure.sdk.iot.device.auth.IotHubX509SoftwareAuthenticationProvider;
import com.microsoft.azure.sdk.iot.device.transport.ExponentialBackoffWithJitter;
import com.microsoft.azure.sdk.iot.device.transport.RetryPolicy;
import com.microsoft.azure.sdk.iot.device.twin.Pair;
import com.microsoft.azure.sdk.iot.provisioning.security.SecurityProvider;
import com.microsoft.azure.sdk.iot.provisioning.security.SecurityProviderSymmetricKey;
import com.microsoft.azure.sdk.iot.provisioning.security.SecurityProviderTpm;
import com.microsoft.azure.sdk.iot.provisioning.security.SecurityProviderX509;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.net.ssl.SSLContext;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClientConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ClientConfiguration.class);
    private static final int DEFAULT_HTTPS_READ_TIMEOUT_MILLIS = 240000;
    private static final int DEFAULT_HTTPS_CONNECT_TIMEOUT_MILLIS = 0;
    public static final int DEFAULT_KEEP_ALIVE_INTERVAL_IN_SECONDS = 230;
    public static final int DEFAULT_SEND_INTERVAL_IN_SECONDS = 10;
    public static final int DEFAULT_AMQP_OPEN_AUTHENTICATION_SESSION_TIMEOUT_IN_SECONDS = 20;
    public static final int DEFAULT_AMQP_OPEN_DEVICE_SESSIONS_TIMEOUT_IN_SECONDS = 60;
    public static final int DEFAULT_SEND_INTERVAL_IN_MILLISECONDS = 10;
    private static final int DEFAULT_MESSAGE_LOCK_TIMEOUT_SECS = 180;
    private static final long DEFAULT_OPERATION_TIMEOUT = 240000L;
    private boolean useWebsocket;
    private ProxySettings proxySettings;
    private final String deviceClientUniqueIdentifier = UUID.randomUUID().toString().substring(0, 8);
    String modelId;
    private int httpsReadTimeout = 240000;
    private int httpsConnectTimeout = 0;
    private int amqpOpenAuthenticationSessionTimeout = 20;
    private int amqpOpenDeviceSessionsTimeout = 60;
    private int keepAliveInterval = 230;
    private int sendInterval = 10;
    private String threadNameSuffix = null;
    private String threadNamePrefix = null;
    private boolean useIdentifiableThreadNames = true;
    private IotHubAuthenticationProvider authenticationProvider;
    private MessageCallback directMethodsMessageCallback;
    private Object directMethodsMessageContext;
    private MessageCallback deviceTwinMessageCallback;
    private Object deviceTwinMessageContext;
    private MessageCallback defaultDeviceTelemetryMessageCallback;
    private Object defaultDeviceTelemetryMessageContext;
    private final Map<String, Pair<MessageCallback, Object>> inputChannelMessageCallbacks = new HashMap<String, Pair<MessageCallback, Object>>();
    private ProductInfo productInfo;
    private long operationTimeout = 240000L;
    private final IotHubClientProtocol protocol;
    @NonNull
    private RetryPolicy retryPolicy = new ExponentialBackoffWithJitter();

    ClientConfiguration(IotHubConnectionString iotHubConnectionString, IotHubClientProtocol protocol) throws IllegalArgumentException {
        this.protocol = protocol;
        this.configSasAuth(iotHubConnectionString);
    }

    private void configSasAuth(IotHubConnectionString iotHubConnectionString) {
        this.commonConstructorSetup(iotHubConnectionString);
        this.assertConnectionStringIsNotX509(iotHubConnectionString);
        this.authenticationProvider = new IotHubSasTokenSoftwareAuthenticationProvider(iotHubConnectionString.getHostName(), iotHubConnectionString.getGatewayHostName(), iotHubConnectionString.getDeviceId(), iotHubConnectionString.getModuleId(), iotHubConnectionString.getSharedAccessKey(), iotHubConnectionString.getSharedAccessToken());
        log.debug("Device configured to use software based SAS authentication provider");
    }

    ClientConfiguration(IotHubAuthenticationProvider authenticationProvider, IotHubClientProtocol protocol) throws IllegalArgumentException {
        if (!(authenticationProvider instanceof IotHubSasTokenAuthenticationProvider)) {
            throw new UnsupportedOperationException("This constructor only support sas token authentication currently");
        }
        this.protocol = protocol;
        this.authenticationProvider = authenticationProvider;
        this.useWebsocket = false;
        this.productInfo = new ProductInfo();
    }

    ClientConfiguration(String hostName, SasTokenProvider sasTokenProvider, IotHubClientProtocol protocol, ClientOptions clientOptions, String deviceId, String moduleId) {
        SSLContext sslContext = clientOptions != null ? clientOptions.getSslContext() : null;
        this.protocol = protocol;
        this.setClientOptionValues(clientOptions);
        this.authenticationProvider = new IotHubSasTokenProvidedAuthenticationProvider(hostName, deviceId, moduleId, sasTokenProvider, sslContext);
        this.useWebsocket = false;
        this.productInfo = new ProductInfo();
        log.debug("Device configured to use SAS token provided authentication provider");
    }

    ClientConfiguration(IotHubConnectionString iotHubConnectionString, IotHubClientProtocol protocol, ClientOptions clientOptions) {
        this.protocol = protocol;
        if (clientOptions != null && clientOptions.getSslContext() != null) {
            this.configSsl(iotHubConnectionString, clientOptions.getSslContext());
        } else {
            this.configSasAuth(iotHubConnectionString);
        }
        this.setClientOptionValues(clientOptions);
    }

    private void setClientOptionValues(ClientOptions clientOptions) {
        IotHubClientProtocol protocol;
        this.modelId = clientOptions != null && clientOptions.getModelId() != null ? clientOptions.getModelId() : null;
        this.keepAliveInterval = clientOptions != null && clientOptions.getKeepAliveInterval() != 0 ? clientOptions.getKeepAliveInterval() : 230;
        this.httpsReadTimeout = clientOptions != null && clientOptions.getHttpsReadTimeout() != 0 ? clientOptions.getHttpsReadTimeout() : 240000;
        this.httpsConnectTimeout = clientOptions != null && clientOptions.getHttpsConnectTimeout() != 0 ? clientOptions.getHttpsConnectTimeout() : 0;
        this.amqpOpenAuthenticationSessionTimeout = clientOptions != null && clientOptions.getAmqpAuthenticationSessionTimeout() != 0 ? clientOptions.getAmqpAuthenticationSessionTimeout() : 20;
        this.amqpOpenDeviceSessionsTimeout = clientOptions != null && clientOptions.getAmqpDeviceSessionTimeout() != 0 ? clientOptions.getAmqpDeviceSessionTimeout() : 60;
        this.proxySettings = clientOptions != null && clientOptions.getProxySettings() != null ? clientOptions.getProxySettings() : null;
        this.sendInterval = clientOptions != null && clientOptions.getSendInterval() != 0 ? clientOptions.getSendInterval() : 10;
        this.threadNamePrefix = clientOptions != null ? clientOptions.getThreadNamePrefix() : null;
        this.threadNameSuffix = clientOptions != null ? clientOptions.getThreadNameSuffix() : null;
        boolean bl = this.useIdentifiableThreadNames = clientOptions == null || clientOptions.isUsingIdentifiableThreadNames();
        if (this.proxySettings != null && (protocol = this.getProtocol()) != IotHubClientProtocol.HTTPS && protocol != IotHubClientProtocol.AMQPS_WS && protocol != IotHubClientProtocol.MQTT_WS) {
            throw new IllegalArgumentException("Use of proxies is unsupported unless using HTTPS, MQTT_WS or AMQPS_WS");
        }
        if (this.getSasTokenAuthentication() != null && clientOptions != null) {
            if (clientOptions.getSasTokenExpiryTime() <= 0L) {
                throw new IllegalArgumentException("ClientOption sasTokenExpiryTime must be greater than 0");
            }
            this.getSasTokenAuthentication().setTokenValidSecs(clientOptions.getSasTokenExpiryTime());
        }
        if (this.keepAliveInterval <= 0) {
            throw new IllegalArgumentException("ClientOption keepAliveInterval must be greater than 0");
        }
        if (this.httpsReadTimeout < 0) {
            throw new IllegalArgumentException("ClientOption httpsReadTimeout must be greater than or equal to 0");
        }
        if (this.httpsConnectTimeout < 0) {
            throw new IllegalArgumentException("ClientOption httpsConnectTimeout must be greater than or equal to 0");
        }
        if (this.amqpOpenAuthenticationSessionTimeout <= 0) {
            throw new IllegalArgumentException("ClientOption amqpAuthenticationSessionTimeout must be greater than 0");
        }
        if (this.amqpOpenDeviceSessionsTimeout <= 0) {
            throw new IllegalArgumentException("ClientOption amqpDeviceSessionTimeout must be greater than 0");
        }
    }

    ClientConfiguration(IotHubConnectionString iotHubConnectionString, IotHubClientProtocol protocol, SSLContext sslContext) {
        this.protocol = protocol;
        this.configSsl(iotHubConnectionString, sslContext);
    }

    private void configSsl(IotHubConnectionString iotHubConnectionString, SSLContext sslContext) {
        this.commonConstructorSetup(iotHubConnectionString);
        if (iotHubConnectionString.isUsingX509()) {
            this.authenticationProvider = new IotHubX509SoftwareAuthenticationProvider(iotHubConnectionString.getHostName(), iotHubConnectionString.getGatewayHostName(), iotHubConnectionString.getDeviceId(), iotHubConnectionString.getModuleId(), sslContext);
            log.debug("Device configured to use software based x509 authentication provider with custom SSLContext");
        } else {
            this.authenticationProvider = new IotHubSasTokenSoftwareAuthenticationProvider(iotHubConnectionString.getHostName(), iotHubConnectionString.getGatewayHostName(), iotHubConnectionString.getDeviceId(), iotHubConnectionString.getModuleId(), iotHubConnectionString.getSharedAccessKey(), iotHubConnectionString.getSharedAccessToken(), sslContext);
            log.debug("Device configured to use software based SAS authentication provider with custom SSLContext");
        }
    }

    ClientConfiguration(IotHubConnectionString connectionString, SecurityProvider securityProvider, IotHubClientProtocol protocol) throws IOException {
        this.commonConstructorSetup(connectionString);
        this.protocol = protocol;
        if (securityProvider == null) {
            throw new IllegalArgumentException("security provider cannot be null");
        }
        if (securityProvider instanceof SecurityProviderTpm) {
            this.authenticationProvider = new IotHubSasTokenHardwareAuthenticationProvider(connectionString.getHostName(), connectionString.getGatewayHostName(), connectionString.getDeviceId(), connectionString.getModuleId(), securityProvider);
        } else if (securityProvider instanceof SecurityProviderSymmetricKey) {
            this.authenticationProvider = new IotHubSasTokenSoftwareAuthenticationProvider(connectionString.getHostName(), connectionString.getGatewayHostName(), connectionString.getDeviceId(), connectionString.getModuleId(), new String(((SecurityProviderSymmetricKey)securityProvider).getSymmetricKey(), StandardCharsets.UTF_8), null);
        } else if (securityProvider instanceof SecurityProviderX509) {
            this.authenticationProvider = new IotHubX509HardwareAuthenticationProvider(connectionString.getHostName(), connectionString.getGatewayHostName(), connectionString.getDeviceId(), connectionString.getModuleId(), securityProvider);
        } else {
            throw new UnsupportedOperationException("The provided security provider is not supported.");
        }
    }

    ClientConfiguration(IotHubConnectionString connectionString, SecurityProvider securityProvider, IotHubClientProtocol protocol, ClientOptions clientOptions) throws IOException {
        this(connectionString, securityProvider, protocol);
        this.setClientOptionValues(clientOptions);
    }

    private void commonConstructorSetup(IotHubConnectionString iotHubConnectionString) {
        if (iotHubConnectionString == null) {
            throw new IllegalArgumentException("connection string cannot be null");
        }
        this.productInfo = new ProductInfo();
        this.useWebsocket = false;
    }

    private void assertConnectionStringIsNotX509(IotHubConnectionString iotHubConnectionString) {
        if (iotHubConnectionString.isUsingX509()) {
            throw new IllegalArgumentException("Cannot use this constructor for x509 connection strings. Use constructor that takes public key certificate and private key or takes an SSLContext instance instead");
        }
    }

    public IotHubSasTokenAuthenticationProvider getSasTokenAuthentication() {
        if (this.authenticationProvider instanceof IotHubSasTokenAuthenticationProvider) {
            return (IotHubSasTokenAuthenticationProvider)this.authenticationProvider;
        }
        return null;
    }

    public IotHubAuthenticationProvider getAuthenticationProvider() {
        return this.authenticationProvider;
    }

    public boolean isUsingWebsocket() {
        return this.useWebsocket;
    }

    void setUseWebsocket(boolean useWebsocket) {
        this.useWebsocket = useWebsocket;
    }

    void setMessageCallback(MessageCallback callback, Object context) {
        this.defaultDeviceTelemetryMessageCallback = callback;
        this.defaultDeviceTelemetryMessageContext = context;
    }

    void setMessageCallback(String inputName, MessageCallback callback, Object context) {
        if (this.inputChannelMessageCallbacks.containsKey(inputName) && callback == null) {
            this.inputChannelMessageCallbacks.remove(inputName);
        } else {
            this.inputChannelMessageCallbacks.put(inputName, new Pair<MessageCallback, Object>(callback, context));
        }
    }

    public String getIotHubHostname() {
        return this.authenticationProvider.getHostname();
    }

    public String getIotHubName() {
        return IotHubConnectionString.parseHubName(this.authenticationProvider.getHostname());
    }

    public String getGatewayHostname() {
        return this.authenticationProvider.getGatewayHostname();
    }

    public String getDeviceId() {
        return this.authenticationProvider.getDeviceId();
    }

    public String getModuleId() {
        return this.authenticationProvider.getModuleId();
    }

    public String getDeviceClientUniqueIdentifier() {
        String identifierPrefix = this.getDeviceId();
        if ((identifierPrefix == null || identifierPrefix.isEmpty()) && ((identifierPrefix = this.getModuleId()) == null || identifierPrefix.isEmpty())) {
            identifierPrefix = UUID.randomUUID().toString().substring(0, 8);
        }
        return identifierPrefix + "-" + this.deviceClientUniqueIdentifier;
    }

    public MessageCallback getDeviceTelemetryMessageCallback(String inputName) {
        if (inputName == null || !this.inputChannelMessageCallbacks.containsKey(inputName)) {
            return this.defaultDeviceTelemetryMessageCallback;
        }
        return this.inputChannelMessageCallbacks.get(inputName).getKey();
    }

    public Object getDeviceTelemetryMessageContext(String inputName) {
        if (inputName == null || !this.inputChannelMessageCallbacks.containsKey(inputName)) {
            return this.defaultDeviceTelemetryMessageContext;
        }
        return this.inputChannelMessageCallbacks.get(inputName).getValue();
    }

    public void setDirectMethodsMessageCallback(MessageCallback callback, Object context) {
        this.directMethodsMessageCallback = callback;
        this.directMethodsMessageContext = context;
    }

    public MessageCallback getDirectMethodsMessageCallback() {
        return this.directMethodsMessageCallback;
    }

    public Object getDirectMethodsMessageContext() {
        return this.directMethodsMessageContext;
    }

    public void setDeviceTwinMessageCallback(MessageCallback callback, Object context) {
        this.deviceTwinMessageCallback = callback;
        this.deviceTwinMessageContext = context;
    }

    public MessageCallback getDeviceTwinMessageCallback() {
        return this.deviceTwinMessageCallback;
    }

    public Object getDeviceTwinMessageContext() {
        return this.deviceTwinMessageContext;
    }

    public int getMessageLockTimeoutSecs() {
        return 180;
    }

    public AuthType getAuthenticationType() {
        if (this.authenticationProvider instanceof IotHubSasTokenAuthenticationProvider) {
            return AuthType.SAS_TOKEN;
        }
        return AuthType.X509_CERTIFICATE;
    }

    public boolean isUsingIdentifiableThreadNames() {
        return this.useIdentifiableThreadNames;
    }

    void setOperationTimeout(long timeout) throws IllegalArgumentException {
        if (timeout < 1L) {
            throw new IllegalArgumentException("Operation timeout cannot be 0 or negative");
        }
        this.operationTimeout = timeout;
    }

    protected ClientConfiguration() {
        this.authenticationProvider = null;
        this.directMethodsMessageCallback = null;
        this.defaultDeviceTelemetryMessageCallback = null;
        this.deviceTwinMessageCallback = null;
        this.directMethodsMessageContext = null;
        this.defaultDeviceTelemetryMessageContext = null;
        this.deviceTwinMessageContext = null;
        this.useWebsocket = false;
        this.protocol = IotHubClientProtocol.AMQPS;
    }

    public ProxySettings getProxySettings() {
        return this.proxySettings;
    }

    void setProxySettings(ProxySettings proxySettings) {
        this.proxySettings = proxySettings;
    }

    public String getModelId() {
        return this.modelId;
    }

    void setModelId(String modelId) {
        this.modelId = modelId;
    }

    public int getHttpsReadTimeout() {
        return this.httpsReadTimeout;
    }

    void setHttpsReadTimeout(int httpsReadTimeout) {
        this.httpsReadTimeout = httpsReadTimeout;
    }

    public int getHttpsConnectTimeout() {
        return this.httpsConnectTimeout;
    }

    void setHttpsConnectTimeout(int httpsConnectTimeout) {
        this.httpsConnectTimeout = httpsConnectTimeout;
    }

    public int getAmqpOpenAuthenticationSessionTimeout() {
        return this.amqpOpenAuthenticationSessionTimeout;
    }

    void setAmqpOpenAuthenticationSessionTimeout(int amqpOpenAuthenticationSessionTimeout) {
        this.amqpOpenAuthenticationSessionTimeout = amqpOpenAuthenticationSessionTimeout;
    }

    public int getAmqpOpenDeviceSessionsTimeout() {
        return this.amqpOpenDeviceSessionsTimeout;
    }

    void setAmqpOpenDeviceSessionsTimeout(int amqpOpenDeviceSessionsTimeout) {
        this.amqpOpenDeviceSessionsTimeout = amqpOpenDeviceSessionsTimeout;
    }

    public int getKeepAliveInterval() {
        return this.keepAliveInterval;
    }

    void setKeepAliveInterval(int keepAliveInterval) {
        this.keepAliveInterval = keepAliveInterval;
    }

    public int getSendInterval() {
        return this.sendInterval;
    }

    void setSendInterval(int sendInterval) {
        this.sendInterval = sendInterval;
    }

    public String getThreadNameSuffix() {
        return this.threadNameSuffix;
    }

    public String getThreadNamePrefix() {
        return this.threadNamePrefix;
    }

    public ProductInfo getProductInfo() {
        return this.productInfo;
    }

    public long getOperationTimeout() {
        return this.operationTimeout;
    }

    public IotHubClientProtocol getProtocol() {
        return this.protocol;
    }

    @NonNull
    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    void setRetryPolicy(@NonNull RetryPolicy retryPolicy) {
        if (retryPolicy == null) {
            throw new NullPointerException("retryPolicy is marked non-null but is null");
        }
        this.retryPolicy = retryPolicy;
    }

    public static enum AuthType {
        X509_CERTIFICATE,
        SAS_TOKEN;

    }
}

