/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport.https;

import com.microsoft.azure.sdk.iot.device.DeviceClientConfig;
import com.microsoft.azure.sdk.iot.device.IotHubMethod;
import com.microsoft.azure.sdk.iot.device.IotHubStatusCode;
import com.microsoft.azure.sdk.iot.device.Message;
import com.microsoft.azure.sdk.iot.device.ResponseMessage;
import com.microsoft.azure.sdk.iot.device.edge.MethodRequest;
import com.microsoft.azure.sdk.iot.device.edge.MethodResult;
import com.microsoft.azure.sdk.iot.device.exceptions.IotHubServiceException;
import com.microsoft.azure.sdk.iot.device.exceptions.TransportException;
import com.microsoft.azure.sdk.iot.device.net.IotHubUri;
import com.microsoft.azure.sdk.iot.device.transport.IotHubTransportManager;
import com.microsoft.azure.sdk.iot.device.transport.IotHubTransportMessage;
import com.microsoft.azure.sdk.iot.device.transport.https.HttpsIotHubConnection;
import com.microsoft.azure.sdk.iot.device.transport.https.HttpsMethod;
import com.microsoft.azure.sdk.iot.device.transport.https.HttpsSingleMessage;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

public class HttpsTransportManager
implements IotHubTransportManager {
    DeviceClientConfig config;
    HttpsIotHubConnection httpsIotHubConnection;
    private static final String MODULE_ID = "x-ms-edge-moduleId";
    private static final String ModuleMethodUriFormat = "/twins/%s/modules/%s/methods";
    private static final String DeviceMethodUriFormat = "/twins/%s/methods";
    private static final String PATH_NOTIFICATIONS_STRING = "/files/notifications";
    private static final String PATH_FILES_STRING = "/files";

    public HttpsTransportManager(DeviceClientConfig config) throws IllegalArgumentException {
        if (config == null) {
            throw new IllegalArgumentException("config is null");
        }
        this.config = config;
    }

    @Override
    public void open() {
        this.httpsIotHubConnection = new HttpsIotHubConnection(this.config);
    }

    @Override
    public void open(String[] topics) {
        this.httpsIotHubConnection = new HttpsIotHubConnection(this.config);
    }

    @Override
    public void close() {
        this.httpsIotHubConnection = null;
    }

    public ResponseMessage sendFileUploadMessage(IotHubTransportMessage message) throws IOException {
        String uri = new IotHubUri("", this.config.getDeviceId(), PATH_FILES_STRING, this.config.getModuleId()).toStringWithoutApiVersion();
        message.setUriPath(uri);
        return this.send(message, new HashMap<String, String>());
    }

    public ResponseMessage sendFileUploadNotification(IotHubTransportMessage message) throws IOException {
        String uri = new IotHubUri("", this.config.getDeviceId(), PATH_NOTIFICATIONS_STRING, this.config.getModuleId()).toStringWithoutApiVersion();
        message.setUriPath(uri);
        return this.send(message, new HashMap<String, String>());
    }

    @Override
    public ResponseMessage send(IotHubTransportMessage message, Map<String, String> additionalHeaders) throws IOException, IllegalArgumentException {
        HttpsMethod httpsMethod;
        HttpsSingleMessage httpsMessage = HttpsSingleMessage.parseHttpsJsonMessage(message);
        if (message.getIotHubMethod() == null || message.getUriPath() == null) {
            throw new IllegalArgumentException("method or path is null");
        }
        switch (message.getIotHubMethod()) {
            case GET: {
                httpsMethod = HttpsMethod.GET;
                break;
            }
            case POST: {
                httpsMethod = HttpsMethod.POST;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown IoT Hub type " + message.getIotHubMethod().toString());
            }
        }
        String httpsPath = message.getUriPath();
        try {
            return this.httpsIotHubConnection.sendHttpsMessage(httpsMessage, httpsMethod, httpsPath, additionalHeaders);
        }
        catch (TransportException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Message receive() throws IOException {
        try {
            return this.httpsIotHubConnection.receiveMessage();
        }
        catch (TransportException e) {
            throw new IOException(e);
        }
    }

    public MethodResult invokeMethod(MethodRequest methodRequest, String deviceId, String moduleId) throws IOException, URISyntaxException, TransportException {
        URI uri = moduleId == null || moduleId.isEmpty() ? HttpsTransportManager.getDeviceMethodUri(deviceId) : HttpsTransportManager.getModuleMethodUri(deviceId, moduleId);
        return this.invokeMethod(methodRequest, uri);
    }

    private MethodResult invokeMethod(MethodRequest methodRequest, URI uri) throws IOException, TransportException {
        if (methodRequest == null) {
            throw new IllegalArgumentException("direct method request cannot be null");
        }
        if (uri == null || uri.toString().isEmpty()) {
            throw new IllegalArgumentException("uri cannot be null or be an empty path");
        }
        IotHubTransportMessage message = new IotHubTransportMessage(methodRequest.toJson());
        message.setIotHubMethod(IotHubMethod.POST);
        message.setUriPath(uri.toString());
        HashMap<String, String> additionalHeaders = new HashMap<String, String>();
        additionalHeaders.put(MODULE_ID, this.config.getDeviceId() + "/" + this.config.getModuleId());
        ResponseMessage responseMessage = this.send(message, additionalHeaders);
        if (responseMessage.getStatus() != IotHubStatusCode.OK && responseMessage.getStatus() != IotHubStatusCode.OK_EMPTY) {
            IotHubServiceException exception = IotHubStatusCode.getConnectionStatusException(responseMessage.getStatus(), new String(responseMessage.getBytes()));
            throw exception;
        }
        String resultJson = new String(responseMessage.getBytes());
        return new MethodResult(resultJson);
    }

    private static URI getDeviceMethodUri(String deviceId) throws UnsupportedEncodingException, URISyntaxException {
        deviceId = URLEncoder.encode(deviceId, "UTF-8");
        return new URI(String.format(DeviceMethodUriFormat, deviceId));
    }

    private static URI getModuleMethodUri(String deviceId, String moduleId) throws UnsupportedEncodingException, URISyntaxException {
        deviceId = URLEncoder.encode(deviceId, "UTF-8");
        moduleId = URLEncoder.encode(moduleId, "UTF-8");
        return new URI(String.format(ModuleMethodUriFormat, deviceId, moduleId));
    }
}

