/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport.amqps;

import com.microsoft.azure.sdk.iot.device.CustomLogger;
import com.microsoft.azure.sdk.iot.device.DeviceClientConfig;
import com.microsoft.azure.sdk.iot.device.Message;
import com.microsoft.azure.sdk.iot.device.MessageProperty;
import com.microsoft.azure.sdk.iot.device.MessageType;
import com.microsoft.azure.sdk.iot.device.exceptions.TransportException;
import com.microsoft.azure.sdk.iot.device.transport.IotHubTransportMessage;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsConvertFromProtonReturnValue;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsConvertToProtonReturnValue;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsDeviceOperationLinkState;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsMessage;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsSendReturnValue;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.Properties;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.amqp.messaging.Source;
import org.apache.qpid.proton.amqp.messaging.Target;
import org.apache.qpid.proton.amqp.transport.ReceiverSettleMode;
import org.apache.qpid.proton.amqp.transport.SenderSettleMode;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Receiver;
import org.apache.qpid.proton.engine.Sender;
import org.apache.qpid.proton.engine.Session;
import org.apache.qpid.proton.message.impl.MessageImpl;

public class AmqpsDeviceOperations {
    protected static final String VERSION_IDENTIFIER_KEY = "com.microsoft:client-version";
    protected static final String API_VERSION_KEY = "com.microsoft:api-version";
    protected static final String TO_KEY = "to";
    protected static final String USER_ID_KEY = "userId";
    protected static final String AMQPS_APP_PROPERTY_PREFIX = "iothub-app-";
    protected static final String INPUT_NAME_PROPERTY_KEY = "x-opt-input-name";
    protected AmqpsDeviceOperationLinkState amqpsSendLinkState = AmqpsDeviceOperationLinkState.UNKNOWN;
    protected AmqpsDeviceOperationLinkState amqpsRecvLinkState = AmqpsDeviceOperationLinkState.UNKNOWN;
    Map<Symbol, Object> amqpProperties;
    protected String senderLinkTag;
    protected String receiverLinkTag;
    protected String senderLinkEndpointPath;
    protected String receiverLinkEndpointPath;
    protected String senderLinkAddress;
    protected String receiverLinkAddress;
    protected Sender senderLink;
    protected Receiver receiverLink;
    private CustomLogger logger;
    int linkCredit;

    AmqpsDeviceOperations(DeviceClientConfig deviceClientConfig, String senderLinkEndpointPath, String receiverLinkEndpointpath, String senderLinkEndpointPathModules, String receiverLinkEndpointPathModules, String senderLinkTagPrefix, String receiverLinkTagPrefix) throws IllegalArgumentException {
        String uuidStr;
        if (deviceClientConfig == null) {
            throw new IllegalArgumentException("device config cannot be null");
        }
        this.amqpProperties = new HashMap<Symbol, Object>();
        this.amqpProperties.put(Symbol.getSymbol((String)VERSION_IDENTIFIER_KEY), deviceClientConfig.getProductInfo().getUserAgentString());
        this.senderLinkTag = uuidStr = UUID.randomUUID().toString();
        this.receiverLinkTag = uuidStr;
        this.senderLink = null;
        this.receiverLink = null;
        this.amqpsSendLinkState = AmqpsDeviceOperationLinkState.CLOSED;
        this.amqpsRecvLinkState = AmqpsDeviceOperationLinkState.CLOSED;
        this.logger = new CustomLogger(this.getClass());
        this.linkCredit = 0;
        String moduleId = deviceClientConfig.getModuleId();
        String deviceId = deviceClientConfig.getDeviceId();
        if (moduleId != null && !moduleId.isEmpty()) {
            this.senderLinkEndpointPath = senderLinkEndpointPathModules;
            this.receiverLinkEndpointPath = receiverLinkEndpointPathModules;
            this.senderLinkTag = senderLinkTagPrefix + deviceId + "/" + moduleId + "-" + this.senderLinkTag;
            this.receiverLinkTag = receiverLinkTagPrefix + deviceId + "/" + moduleId + "-" + this.receiverLinkTag;
            this.senderLinkAddress = String.format(this.senderLinkEndpointPath, deviceId, moduleId);
            this.receiverLinkAddress = String.format(this.receiverLinkEndpointPath, deviceId, moduleId);
        } else {
            this.senderLinkEndpointPath = senderLinkEndpointPath;
            this.receiverLinkEndpointPath = receiverLinkEndpointpath;
            this.senderLinkTag = senderLinkTagPrefix + deviceId + "-" + this.senderLinkTag;
            this.receiverLinkTag = receiverLinkTagPrefix + deviceId + "-" + this.receiverLinkTag;
            this.senderLinkAddress = String.format(this.senderLinkEndpointPath, deviceId);
            this.receiverLinkAddress = String.format(this.receiverLinkEndpointPath, deviceId);
        }
    }

    protected synchronized boolean openLinks(Session session) throws TransportException {
        Source source;
        Target target;
        boolean waitForRemoteOpenCallback = false;
        this.logger.LogDebug("Entered in method %s", this.logger.getMethodName());
        if (session == null) {
            throw new IllegalArgumentException("The session cannot be null.");
        }
        if (this.senderLink == null && this.amqpsSendLinkState == AmqpsDeviceOperationLinkState.CLOSED) {
            try {
                this.senderLink = session.sender(this.getSenderLinkTag());
                this.senderLink.setProperties(this.getAmqpProperties());
                target = new Target();
                source = new Source();
                target.setAddress(this.getSenderLinkAddress());
                source.setAddress(this.getReceiverLinkAddress());
                this.senderLink.setTarget((org.apache.qpid.proton.amqp.transport.Target)target);
                this.senderLink.setSource((org.apache.qpid.proton.amqp.transport.Source)source);
                this.amqpsSendLinkState = AmqpsDeviceOperationLinkState.OPENING;
                this.senderLink.open();
                waitForRemoteOpenCallback = true;
            }
            catch (Exception e) {
                throw new TransportException(e);
            }
        }
        if (this.receiverLink == null && this.amqpsRecvLinkState == AmqpsDeviceOperationLinkState.CLOSED) {
            try {
                this.receiverLink = session.receiver(this.getReceiverLinkTag());
                this.receiverLink.setProperties(this.getAmqpProperties());
                target = new Target();
                source = new Source();
                target.setAddress(this.getSenderLinkAddress());
                source.setAddress(this.getReceiverLinkAddress());
                this.receiverLink.setTarget((org.apache.qpid.proton.amqp.transport.Target)target);
                this.receiverLink.setSource((org.apache.qpid.proton.amqp.transport.Source)source);
                this.amqpsRecvLinkState = AmqpsDeviceOperationLinkState.OPENING;
                this.receiverLink.open();
                waitForRemoteOpenCallback = true;
            }
            catch (Exception e) {
                throw new TransportException(e);
            }
        }
        this.logger.LogDebug("Exited from method %s", this.logger.getMethodName());
        return waitForRemoteOpenCallback;
    }

    protected void closeLinks() {
        this.logger.LogDebug("Entered in method %s", this.logger.getMethodName());
        if (this.senderLink != null) {
            this.senderLink.close();
            this.senderLink = null;
        }
        if (this.receiverLink != null) {
            this.receiverLink.close();
            this.receiverLink = null;
        }
        this.amqpsSendLinkState = AmqpsDeviceOperationLinkState.CLOSED;
        this.amqpsRecvLinkState = AmqpsDeviceOperationLinkState.CLOSED;
        this.logger.LogDebug("Exited from method %s", this.logger.getMethodName());
    }

    protected synchronized void initLink(Link link) throws TransportException, IllegalArgumentException {
        this.logger.LogDebug("Entered in method %s", this.logger.getMethodName());
        if (link == null) {
            throw new IllegalArgumentException("The link cannot be null.");
        }
        String linkName = link.getName();
        if (linkName.equals(this.getSenderLinkTag()) && this.amqpsSendLinkState == AmqpsDeviceOperationLinkState.OPENING) {
            try {
                Target target = new Target();
                target.setAddress(this.getSenderLinkAddress());
                link.setTarget((org.apache.qpid.proton.amqp.transport.Target)target);
                link.setSenderSettleMode(SenderSettleMode.UNSETTLED);
            }
            catch (Exception e) {
                throw new TransportException(e);
            }
        }
        if (linkName.equals(this.getReceiverLinkTag()) && this.amqpsRecvLinkState == AmqpsDeviceOperationLinkState.OPENING) {
            try {
                Source source = new Source();
                source.setAddress(this.getReceiverLinkAddress());
                link.setSource((org.apache.qpid.proton.amqp.transport.Source)source);
                link.setReceiverSettleMode(ReceiverSettleMode.FIRST);
            }
            catch (Exception e) {
                throw new TransportException(e);
            }
        }
        this.logger.LogDebug("Exited from method %s", this.logger.getMethodName());
    }

    protected synchronized AmqpsSendReturnValue sendMessageAndGetDeliveryTag(MessageType messageType, byte[] msgData, int offset, int length, byte[] deliveryTag) throws IllegalStateException, IllegalArgumentException {
        if (this.senderLink == null) {
            throw new IllegalStateException("Trying to send but Sender link is not initialized.");
        }
        if (deliveryTag.length == 0) {
            throw new IllegalArgumentException("Trying deliveryTag cannot be null.");
        }
        if (this.linkCredit <= 0) {
            return new AmqpsSendReturnValue(false, -1);
        }
        Delivery delivery = this.senderLink.delivery(deliveryTag);
        try {
            this.senderLink.send(msgData, offset, length);
            this.senderLink.advance();
            this.linkCredit = this.senderLink.getCredit();
            return new AmqpsSendReturnValue(true, delivery.hashCode(), deliveryTag);
        }
        catch (Exception e) {
            this.senderLink.advance();
            delivery.free();
            return new AmqpsSendReturnValue(false, -1);
        }
    }

    protected AmqpsMessage getMessageFromReceiverLink(String linkName) throws IllegalArgumentException, TransportException {
        if (linkName.isEmpty()) {
            throw new IllegalArgumentException("The linkName cannot be empty.");
        }
        if (linkName.equals(this.getReceiverLinkTag())) {
            try {
                Delivery delivery;
                if (this.receiverLink != null && (delivery = this.receiverLink.current()) != null && delivery.isReadable() && !delivery.isPartial()) {
                    int size = delivery.pending();
                    byte[] buffer = new byte[size];
                    int read = this.receiverLink.recv(buffer, 0, buffer.length);
                    this.receiverLink.advance();
                    AmqpsMessage amqpsMessage = new AmqpsMessage();
                    amqpsMessage.setDelivery(delivery);
                    amqpsMessage.decode(buffer, 0, read);
                    return amqpsMessage;
                }
            }
            catch (Exception e) {
                throw new TransportException(e);
            }
        }
        return null;
    }

    public Boolean operationLinksOpened() {
        return this.amqpsSendLinkState == AmqpsDeviceOperationLinkState.OPENED && this.amqpsRecvLinkState == AmqpsDeviceOperationLinkState.OPENED;
    }

    protected Boolean isLinkFound(String linkName) {
        return null;
    }

    protected AmqpsConvertFromProtonReturnValue convertFromProton(AmqpsMessage amqpsMessage, DeviceClientConfig deviceClientConfig) throws TransportException {
        return null;
    }

    protected AmqpsConvertToProtonReturnValue convertToProton(Message message) throws TransportException {
        return null;
    }

    protected IotHubTransportMessage protonMessageToIoTHubMessage(MessageImpl protonMsg) throws TransportException {
        byte[] msgBody;
        Data d = (Data)protonMsg.getBody();
        if (d != null) {
            Binary b = d.getValue();
            msgBody = new byte[b.getLength()];
            ByteBuffer buffer = b.asByteBuffer();
            buffer.get(msgBody);
        } else {
            msgBody = new byte[]{};
        }
        IotHubTransportMessage iotHubTransportMessage = new IotHubTransportMessage(msgBody, MessageType.UNKNOWN);
        Properties properties = protonMsg.getProperties();
        if (properties != null) {
            if (properties.getCorrelationId() != null) {
                iotHubTransportMessage.setCorrelationId(properties.getCorrelationId().toString());
            }
            if (properties.getMessageId() != null) {
                iotHubTransportMessage.setMessageId(properties.getMessageId().toString());
            }
            if (properties.getTo() != null) {
                iotHubTransportMessage.setProperty("iothub-app-to", properties.getTo());
            }
            if (properties.getUserId() != null) {
                iotHubTransportMessage.setProperty("iothub-app-userId", properties.getUserId().toString());
            }
            if (properties.getContentEncoding() != null) {
                iotHubTransportMessage.setContentEncoding(properties.getContentEncoding().toString());
            }
            if (properties.getContentType() != null) {
                iotHubTransportMessage.setContentType(properties.getContentType().toString());
            }
        }
        if (protonMsg.getApplicationProperties() != null) {
            Map applicationProperties = protonMsg.getApplicationProperties().getValue();
            for (Map.Entry entry : applicationProperties.entrySet()) {
                String propertyKey = (String)entry.getKey();
                if (propertyKey.equalsIgnoreCase("iothub-connection-device-id")) {
                    iotHubTransportMessage.setConnectionDeviceId(entry.getValue().toString());
                    continue;
                }
                if (propertyKey.equalsIgnoreCase("iothub-connection-module-id")) {
                    iotHubTransportMessage.setConnectionModuleId(entry.getValue().toString());
                    continue;
                }
                if (MessageProperty.RESERVED_PROPERTY_NAMES.contains(propertyKey)) continue;
                iotHubTransportMessage.setProperty((String)entry.getKey(), entry.getValue().toString());
            }
        }
        return iotHubTransportMessage;
    }

    protected MessageImpl iotHubMessageToProtonMessage(Message message) throws TransportException {
        MessageImpl outgoingMessage = (MessageImpl)Proton.message();
        Properties properties = new Properties();
        if (message.getMessageId() != null) {
            properties.setMessageId((Object)message.getMessageId());
        }
        if (message.getCorrelationId() != null) {
            properties.setCorrelationId((Object)message.getCorrelationId());
        }
        if (message.getContentType() != null) {
            properties.setContentType(Symbol.valueOf((String)message.getContentType()));
        }
        if (message.getContentEncoding() != null) {
            properties.setContentEncoding(Symbol.valueOf((String)message.getContentEncoding()));
        }
        outgoingMessage.setProperties(properties);
        HashMap<String, String> userProperties = new HashMap<String, String>();
        if (message.getProperties().length > 0) {
            for (MessageProperty messageProperty : message.getProperties()) {
                if (MessageProperty.RESERVED_PROPERTY_NAMES.contains(messageProperty.getName())) continue;
                userProperties.put(messageProperty.getName(), messageProperty.getValue());
            }
        }
        if (message.getConnectionDeviceId() != null) {
            userProperties.put("iothub-connection-device-id", message.getConnectionDeviceId());
        }
        if (message.getConnectionModuleId() != null) {
            userProperties.put("iothub-connection-module-id", message.getConnectionModuleId());
        }
        if (message.getCreationTimeUTC() != null) {
            userProperties.put("iothub-creation-time-utc", message.getCreationTimeUTCString());
        }
        ApplicationProperties applicationProperties = new ApplicationProperties(userProperties);
        outgoingMessage.setApplicationProperties(applicationProperties);
        Binary binary = new Binary(message.getBytes());
        Data section = new Data(binary);
        outgoingMessage.setBody((Section)section);
        return outgoingMessage;
    }

    Map<Symbol, Object> getAmqpProperties() {
        return this.amqpProperties;
    }

    String getSenderLinkTag() {
        return this.senderLinkTag;
    }

    String getReceiverLinkTag() {
        return this.receiverLinkTag;
    }

    String getSenderLinkAddress() {
        return this.senderLinkAddress;
    }

    String getReceiverLinkAddress() {
        return this.receiverLinkAddress;
    }

    public void onLinkFlow(int linkCredit) {
        this.linkCredit = linkCredit;
    }
}

