/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport.amqps;

import com.microsoft.azure.sdk.iot.device.CustomLogger;
import com.microsoft.azure.sdk.iot.device.DeviceClientConfig;
import com.microsoft.azure.sdk.iot.device.MessageType;
import com.microsoft.azure.sdk.iot.device.exceptions.TransportException;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsDeviceAuthentication;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsDeviceOperationLinkState;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsMessage;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsSendReturnValue;
import java.io.IOException;
import org.apache.qpid.proton.engine.SslDomain;
import org.apache.qpid.proton.engine.Transport;

public class AmqpsDeviceAuthenticationX509
extends AmqpsDeviceAuthentication {
    private final DeviceClientConfig deviceClientConfig;
    private CustomLogger logger;

    public AmqpsDeviceAuthenticationX509(DeviceClientConfig deviceClientConfig) throws IllegalArgumentException {
        super(deviceClientConfig);
        this.deviceClientConfig = deviceClientConfig;
        this.amqpsSendLinkState = AmqpsDeviceOperationLinkState.OPENED;
        this.amqpsRecvLinkState = AmqpsDeviceOperationLinkState.OPENED;
        this.logger = new CustomLogger(this.getClass());
    }

    @Override
    protected AmqpsSendReturnValue sendMessageAndGetDeliveryTag(MessageType messageType, byte[] msgData, int offset, int length, byte[] deliveryTag) {
        return null;
    }

    @Override
    protected AmqpsMessage getMessageFromReceiverLink(String linkName) {
        return null;
    }

    @Override
    protected void setSslDomain(Transport transport) throws TransportException {
        if (transport == null) {
            throw new IllegalArgumentException("Input parameter transport cannot be null.");
        }
        SslDomain domain = null;
        try {
            domain = this.makeDomain(this.deviceClientConfig.getAuthenticationProvider().getSSLContext());
        }
        catch (IOException e) {
            this.logger.LogDebug("setSslDomain has thrown exception: %s", e.getMessage());
            throw new TransportException(e);
        }
        transport.ssl(domain);
    }

    @Override
    protected Boolean isLinkFound(String linkName) {
        return true;
    }
}

