/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport;

import com.microsoft.azure.sdk.iot.device.exceptions.TransportException;
import com.microsoft.azure.sdk.iot.device.transport.RetryDecision;
import com.microsoft.azure.sdk.iot.device.transport.RetryPolicy;
import java.security.SecureRandom;

public class ExponentialBackoffWithJitter
implements RetryPolicy {
    private int retryCount = Integer.MAX_VALUE;
    private long minBackoff = 100L;
    private long maxBackoff = 10000L;
    private long deltaBackoff = 100L;
    private boolean firstFastRetry = true;
    private SecureRandom random = new SecureRandom();

    public ExponentialBackoffWithJitter() {
    }

    public ExponentialBackoffWithJitter(int retryCount, long minBackoff, long maxBackoff, long deltaBackoff, boolean firstFastRetry) {
        if (retryCount <= 0) {
            throw new IllegalArgumentException("retryCount cannot be less than or equal to 0.");
        }
        this.retryCount = retryCount;
        this.minBackoff = minBackoff;
        this.maxBackoff = maxBackoff;
        this.deltaBackoff = deltaBackoff;
        this.firstFastRetry = firstFastRetry;
    }

    @Override
    public RetryDecision getRetryDecision(int currentRetryCount, TransportException lastException) {
        if (currentRetryCount == 0 && this.firstFastRetry) {
            return new RetryDecision(true, 0L);
        }
        if (currentRetryCount < this.retryCount) {
            int deltaBackoffLowbound = (int)((double)this.deltaBackoff * 0.8);
            int deltaBackoffUpperbound = (int)((double)this.deltaBackoff * 1.2);
            long randomDeltaBackOff = this.random.nextInt(deltaBackoffUpperbound - deltaBackoffLowbound);
            long exponentialBackOffWithJitter = (int)((Math.pow(2.0, currentRetryCount) - 1.0) * (double)(randomDeltaBackOff + (long)deltaBackoffLowbound));
            long finalWaitTimeUntilNextRetry = (int)Math.min((double)this.minBackoff + (double)exponentialBackOffWithJitter, (double)this.maxBackoff);
            return new RetryDecision(true, finalWaitTimeUntilNextRetry);
        }
        return new RetryDecision(false, 0L);
    }
}

