/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.auth;

import com.microsoft.azure.sdk.iot.device.auth.IotHubSasToken;
import com.microsoft.azure.sdk.iot.device.auth.IotHubSasTokenAuthenticationProvider;
import com.microsoft.azure.sdk.iot.device.exceptions.TransportException;
import java.io.IOException;

public class IotHubSasTokenSoftwareAuthenticationProvider
extends IotHubSasTokenAuthenticationProvider {
    protected String deviceKey;

    public IotHubSasTokenSoftwareAuthenticationProvider(String hostname, String gatewayHostname, String deviceId, String moduleId, String deviceKey, String sharedAccessToken, int tokenValidSecs, int timeBufferPercentage) throws SecurityException {
        super(hostname, gatewayHostname, deviceId, moduleId, tokenValidSecs, timeBufferPercentage);
        this.deviceKey = deviceKey;
        this.sslContextNeedsUpdate = true;
        this.sasToken = new IotHubSasToken(hostname, deviceId, deviceKey, sharedAccessToken, moduleId, this.getExpiryTimeInSeconds());
    }

    public IotHubSasTokenSoftwareAuthenticationProvider(String hostname, String gatewayHostname, String deviceId, String moduleId, String deviceKey, String sharedAccessToken) throws SecurityException {
        super(hostname, gatewayHostname, deviceId, moduleId);
        this.deviceKey = deviceKey;
        this.sslContextNeedsUpdate = true;
        this.sasToken = new IotHubSasToken(hostname, deviceId, deviceKey, sharedAccessToken, moduleId, this.getExpiryTimeInSeconds());
    }

    @Override
    public boolean isRenewalNecessary() {
        return super.isRenewalNecessary() && this.deviceKey == null;
    }

    @Override
    public void setTokenValidSecs(long tokenValidSecs) {
        super.setTokenValidSecs(tokenValidSecs);
        if (this.deviceKey != null) {
            this.sasToken = new IotHubSasToken(this.hostname, this.deviceId, this.deviceKey, null, this.moduleId, this.getExpiryTimeInSeconds());
        }
    }

    @Override
    public boolean canRefreshToken() {
        return this.deviceKey != null;
    }

    @Override
    public String getRenewedSasToken(boolean proactivelyRenew, boolean forceRenewal) throws IOException, TransportException {
        if ((this.shouldRefreshToken(proactivelyRenew) || forceRenewal) && this.deviceKey != null) {
            this.sasToken = new IotHubSasToken(this.hostname, this.deviceId, this.deviceKey, null, this.moduleId, this.getExpiryTimeInSeconds());
        }
        return this.sasToken.toString();
    }
}

