/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.proton.transport.proxy.impl;

import com.microsoft.azure.proton.transport.proxy.ProxyHandler;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Scanner;

public class ProxyHandlerImpl
implements ProxyHandler {
    @Override
    public String createProxyRequest(String hostName, Map<String, String> additionalHeaders) {
        String endOfLine = "\r\n";
        StringBuilder connectRequestBuilder = new StringBuilder();
        connectRequestBuilder.append(String.format("CONNECT %1$s HTTP/1.1%2$sHost: %1$s%2$sConnection: Keep-Alive%2$s", hostName, "\r\n"));
        if (additionalHeaders != null) {
            for (Map.Entry<String, String> entry : additionalHeaders.entrySet()) {
                connectRequestBuilder.append(entry.getKey());
                connectRequestBuilder.append(": ");
                connectRequestBuilder.append(entry.getValue());
                connectRequestBuilder.append("\r\n");
            }
        }
        connectRequestBuilder.append("\r\n");
        return connectRequestBuilder.toString();
    }

    @Override
    public ProxyHandler.ProxyResponseResult validateProxyResponse(ByteBuffer buffer) {
        int size = buffer.remaining();
        String response = null;
        if (size > 0) {
            String firstLine;
            byte[] responseBytes = new byte[buffer.remaining()];
            buffer.get(responseBytes);
            response = new String(responseBytes, StandardCharsets.UTF_8);
            Scanner responseScanner = new Scanner(response);
            if (responseScanner.hasNextLine() && (firstLine = responseScanner.nextLine()).toLowerCase().contains("http/1.1") && firstLine.contains("200") && firstLine.toLowerCase().contains("connection established")) {
                return new ProxyHandler.ProxyResponseResult(true, null);
            }
        }
        return new ProxyHandler.ProxyResponseResult(false, response);
    }
}

