/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.proton.transport.proxy.impl;

import com.microsoft.azure.proton.transport.proxy.ProxyChallengeProcessor;
import com.microsoft.azure.proton.transport.proxy.impl.ProxyAuthenticator;
import java.io.UnsupportedEncodingException;
import java.net.PasswordAuthentication;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.bind.DatatypeConverter;

public class DigestProxyChallengeProcessorImpl
implements ProxyChallengeProcessor {
    private final String DIGEST = "digest";
    private final String PROXY_AUTH_DIGEST = "Proxy-Authenticate: Digest";
    private final AtomicInteger nonceCounter = new AtomicInteger(0);
    private final Map<String, String> headers;
    private final ProxyAuthenticator proxyAuthenticator;
    private static String host;
    private static String challenge;

    DigestProxyChallengeProcessorImpl(String host, String challenge) {
        DigestProxyChallengeProcessorImpl.host = host;
        DigestProxyChallengeProcessorImpl.challenge = challenge;
        this.headers = new HashMap<String, String>();
        this.proxyAuthenticator = new ProxyAuthenticator();
    }

    @Override
    public Map<String, String> getHeader() {
        Scanner responseScanner = new Scanner(challenge);
        HashMap<String, String> challengeQuestionValues = new HashMap<String, String>();
        while (responseScanner.hasNextLine()) {
            String line = responseScanner.nextLine();
            if (!line.contains("Proxy-Authenticate: Digest")) continue;
            this.getChallengeQuestionHeaders(line, challengeQuestionValues);
            this.computeDigestAuthHeader(challengeQuestionValues, host, this.proxyAuthenticator.getPasswordAuthentication("digest", host));
            break;
        }
        return this.headers;
    }

    private void getChallengeQuestionHeaders(String line, Map<String, String> challengeQuestionValues) {
        String[] headerValues;
        String context = line.substring("Proxy-Authenticate: Digest".length());
        for (String headerValue : headerValues = context.split(",")) {
            if (!headerValue.contains("=")) continue;
            String key = headerValue.substring(0, headerValue.indexOf("="));
            String value = headerValue.substring(headerValue.indexOf("=") + 1);
            challengeQuestionValues.put(key.trim(), value.replaceAll("\"", "").trim());
        }
    }

    private void computeDigestAuthHeader(Map<String, String> challengeQuestionValues, String uri, PasswordAuthentication passwordAuthentication) {
        if (!this.proxyAuthenticator.isPasswordAuthenticationHasValues(passwordAuthentication)) {
            return;
        }
        String proxyUserName = passwordAuthentication.getUserName();
        String proxyPassword = new String(passwordAuthentication.getPassword());
        try {
            String digestValue;
            String nonce = challengeQuestionValues.get("nonce");
            String realm = challengeQuestionValues.get("realm");
            String qop = challengeQuestionValues.get("qop");
            MessageDigest md5 = MessageDigest.getInstance("md5");
            SecureRandom secureRandom = new SecureRandom();
            String a1 = DatatypeConverter.printHexBinary((byte[])md5.digest(String.format("%s:%s:%s", proxyUserName, realm, proxyPassword).getBytes("UTF-8"))).toLowerCase();
            String a2 = DatatypeConverter.printHexBinary((byte[])md5.digest(String.format("%s:%s", "CONNECT", uri).getBytes("UTF-8"))).toLowerCase();
            byte[] cnonceBytes = new byte[16];
            secureRandom.nextBytes(cnonceBytes);
            String cnonce = DatatypeConverter.printHexBinary((byte[])cnonceBytes).toLowerCase();
            if (qop == null || qop.isEmpty()) {
                String response = DatatypeConverter.printHexBinary((byte[])md5.digest(String.format("%s:%s:%s", a1, nonce, a2).getBytes("UTF-8"))).toLowerCase();
                digestValue = String.format("Digest username=\"%s\",realm=\"%s\",nonce=\"%s\",uri=\"%s\",cnonce=\"%s\",response=\"%s\"", proxyUserName, realm, nonce, uri, cnonce, response);
            } else {
                int nc = this.nonceCounter.incrementAndGet();
                String response = DatatypeConverter.printHexBinary((byte[])md5.digest(String.format("%s:%s:%08X:%s:%s:%s", a1, nonce, nc, cnonce, qop, a2).getBytes("UTF-8"))).toLowerCase();
                digestValue = String.format("Digest username=\"%s\",realm=\"%s\",nonce=\"%s\",uri=\"%s\",cnonce=\"%s\",nc=%08X,response=\"%s\",qop=\"%s\"", proxyUserName, realm, nonce, uri, cnonce, nc, response, qop);
            }
            this.headers.put("Proxy-Authorization", digestValue);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }
}

