/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.proton.transport.proxy.impl;

import com.microsoft.azure.proton.transport.proxy.ProxyChallengeProcessor;
import com.microsoft.azure.proton.transport.proxy.impl.ProxyAuthenticator;
import java.net.PasswordAuthentication;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;

public class BasicProxyChallengeProcessorImpl
implements ProxyChallengeProcessor {
    private final String BASIC = "basic";
    private final ProxyAuthenticator proxyAuthenticator;
    private final Map<String, String> headers;
    private String host;

    BasicProxyChallengeProcessorImpl(String host) {
        this.host = host;
        this.headers = new HashMap<String, String>();
        this.proxyAuthenticator = new ProxyAuthenticator();
    }

    @Override
    public Map<String, String> getHeader() {
        PasswordAuthentication passwordAuthentication = this.proxyAuthenticator.getPasswordAuthentication("basic", this.host);
        if (!this.proxyAuthenticator.isPasswordAuthenticationHasValues(passwordAuthentication)) {
            return null;
        }
        String proxyUserName = passwordAuthentication.getUserName();
        String proxyPassword = new String(passwordAuthentication.getPassword());
        String usernamePasswordPair = proxyUserName + ":" + proxyPassword;
        this.headers.put("Proxy-Authorization", "Basic " + Base64.getEncoder().encodeToString(usernamePasswordPair.getBytes()));
        return this.headers;
    }
}

