// Generated by delombok at Fri Jan 10 21:22:46 UTC 2020
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
package com.microsoft.aad.msal4j;

import java.util.UUID;

class RequestContext {
    private String telemetryRequestId;
    private String clientId;
    private String correlationId;
    private PublicApi publicApi;
    private String applicationName;
    private String applicationVersion;

    public RequestContext(ClientApplicationBase clientApplication, PublicApi publicApi) {
        this.clientId = StringHelper.isBlank(clientApplication.clientId()) ? "unset_client_id" : clientApplication.clientId();
        this.correlationId = StringHelper.isBlank(clientApplication.correlationId()) ? generateNewCorrelationId() : clientApplication.correlationId();
        this.applicationVersion = clientApplication.applicationVersion();
        this.applicationName = clientApplication.applicationName();
        this.publicApi = publicApi;
    }

    private static String generateNewCorrelationId() {
        return UUID.randomUUID().toString();
    }

    @java.lang.SuppressWarnings("all")
    String telemetryRequestId() {
        return this.telemetryRequestId;
    }

    @java.lang.SuppressWarnings("all")
    String clientId() {
        return this.clientId;
    }

    @java.lang.SuppressWarnings("all")
    String correlationId() {
        return this.correlationId;
    }

    @java.lang.SuppressWarnings("all")
    PublicApi publicApi() {
        return this.publicApi;
    }

    @java.lang.SuppressWarnings("all")
    String applicationName() {
        return this.applicationName;
    }

    @java.lang.SuppressWarnings("all")
    String applicationVersion() {
        return this.applicationVersion;
    }

    @java.lang.SuppressWarnings("all")
    RequestContext telemetryRequestId(final String telemetryRequestId) {
        this.telemetryRequestId = telemetryRequestId;
        return this;
    }
}
