// Generated by delombok at Fri Jan 10 21:22:46 UTC 2020
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
package com.microsoft.aad.msal4j;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nimbusds.jose.util.StandardCharset;
import java.util.Base64;

class ClientInfo {
    @JsonProperty("uid")
    private String uniqueIdentifier;
    @JsonProperty("utid")
    private String unqiueTenantIdentifier;

    public static ClientInfo createFromJson(String clientInfoJsonBase64Encoded) {
        if (StringHelper.isBlank(clientInfoJsonBase64Encoded)) {
            return null;
        }
        byte[] decodedInput = Base64.getDecoder().decode(clientInfoJsonBase64Encoded.getBytes(StandardCharset.UTF_8));
        return JsonHelper.convertJsonToObject(new String(decodedInput, StandardCharset.UTF_8), ClientInfo.class);
    }

    String toAccountIdentifier() {
        return uniqueIdentifier + "." + unqiueTenantIdentifier;
    }

    @java.lang.SuppressWarnings("all")
    String getUniqueIdentifier() {
        return this.uniqueIdentifier;
    }

    @java.lang.SuppressWarnings("all")
    String getUnqiueTenantIdentifier() {
        return this.unqiueTenantIdentifier;
    }
}
