// Generated by delombok at Fri Jan 10 21:22:46 UTC 2020
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
package com.microsoft.aad.msal4j;

import lombok.*;
import java.util.Set;
import static com.microsoft.aad.msal4j.ParameterValidationUtils.validateNotEmpty;

/**
 * Object containing parameters for client credential flow. Can be used as parameter to

 * {@link ConfidentialClientApplication#acquireToken(ClientCredentialParameters)}
 */
public class ClientCredentialParameters {
    @NonNull
    private Set<String> scopes;

    private static ClientCredentialParametersBuilder builder() {
        return new ClientCredentialParametersBuilder();
    }

    /**
     * Builder for {@link ClientCredentialParameters}

     * @param scopes scopes application is requesting access to

     * @return builder that can be used to construct ClientCredentialParameters
     */
    public static ClientCredentialParametersBuilder builder(Set<String> scopes) {
        validateNotEmpty("scopes", scopes);
        return builder().scopes(scopes);
    }


    @java.lang.SuppressWarnings("all")
    public static class ClientCredentialParametersBuilder {
        @java.lang.SuppressWarnings("all")
        private Set<String> scopes;

        @java.lang.SuppressWarnings("all")
        ClientCredentialParametersBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        public ClientCredentialParametersBuilder scopes(final Set<String> scopes) {
            this.scopes = scopes;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public ClientCredentialParameters build() {
            return new ClientCredentialParameters(scopes);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public java.lang.String toString() {
            return "ClientCredentialParameters.ClientCredentialParametersBuilder(scopes=" + this.scopes + ")";
        }
    }

    @NonNull
    @java.lang.SuppressWarnings("all")
    public Set<String> scopes() {
        return this.scopes;
    }

    @java.beans.ConstructorProperties({"scopes"})
    @java.lang.SuppressWarnings("all")
    private ClientCredentialParameters(@NonNull final Set<String> scopes) {
        if (scopes == null) {
            throw new java.lang.NullPointerException("scopes is marked @NonNull but is null");
        }
        this.scopes = scopes;
    }
}
