// Generated by delombok at Fri Jan 10 21:22:46 UTC 2020
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
package com.microsoft.aad.msal4j;

import lombok.*;
import java.net.URI;
import java.util.Set;
import static com.microsoft.aad.msal4j.ParameterValidationUtils.validateNotBlank;

/**
 * Object containing parameters for authorization code flow. Can be used as parameter to

 * {@link PublicClientApplication#acquireToken(AuthorizationCodeParameters)} or to

 * {@link ConfidentialClientApplication#acquireToken(AuthorizationCodeParameters)}
 */
public class AuthorizationCodeParameters {
    private Set<String> scopes;
    @NonNull
    private String authorizationCode;
    @NonNull
    private URI redirectUri;

    private static AuthorizationCodeParametersBuilder builder() {
        return new AuthorizationCodeParametersBuilder();
    }

    /**
     * Builder for {@link AuthorizationCodeParameters}

     * @param authorizationCode code received from the service authorization endpoint

     * @param redirectUri URI where authorization code was received

     * @return builder object that can be used to construct {@link AuthorizationCodeParameters}
     */
    public static AuthorizationCodeParametersBuilder builder(String authorizationCode, URI redirectUri) {
        validateNotBlank("authorizationCode", authorizationCode);
        return builder().authorizationCode(authorizationCode).redirectUri(redirectUri);
    }


    @java.lang.SuppressWarnings("all")
    public static class AuthorizationCodeParametersBuilder {
        @java.lang.SuppressWarnings("all")
        private Set<String> scopes;
        @java.lang.SuppressWarnings("all")
        private String authorizationCode;
        @java.lang.SuppressWarnings("all")
        private URI redirectUri;

        @java.lang.SuppressWarnings("all")
        AuthorizationCodeParametersBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        public AuthorizationCodeParametersBuilder scopes(final Set<String> scopes) {
            this.scopes = scopes;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public AuthorizationCodeParametersBuilder authorizationCode(final String authorizationCode) {
            this.authorizationCode = authorizationCode;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public AuthorizationCodeParametersBuilder redirectUri(final URI redirectUri) {
            this.redirectUri = redirectUri;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public AuthorizationCodeParameters build() {
            return new AuthorizationCodeParameters(scopes, authorizationCode, redirectUri);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public java.lang.String toString() {
            return "AuthorizationCodeParameters.AuthorizationCodeParametersBuilder(scopes=" + this.scopes + ", authorizationCode=" + this.authorizationCode + ", redirectUri=" + this.redirectUri + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    public Set<String> scopes() {
        return this.scopes;
    }

    @NonNull
    @java.lang.SuppressWarnings("all")
    public String authorizationCode() {
        return this.authorizationCode;
    }

    @NonNull
    @java.lang.SuppressWarnings("all")
    public URI redirectUri() {
        return this.redirectUri;
    }

    @java.beans.ConstructorProperties({"scopes", "authorizationCode", "redirectUri"})
    @java.lang.SuppressWarnings("all")
    private AuthorizationCodeParameters(final Set<String> scopes, @NonNull final String authorizationCode, @NonNull final URI redirectUri) {
        if (authorizationCode == null) {
            throw new java.lang.NullPointerException("authorizationCode is marked @NonNull but is null");
        }
        if (redirectUri == null) {
            throw new java.lang.NullPointerException("redirectUri is marked @NonNull but is null");
        }
        this.scopes = scopes;
        this.authorizationCode = authorizationCode;
        this.redirectUri = redirectUri;
    }
}
