// Generated by delombok at Fri Jul 26 21:46:44 UTC 2024
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
package com.microsoft.aad.msal4j;

import java.net.URI;

/**
 * Options for using the default OS browser as a separate process to handle interactive authentication.

 * MSAL will listen for the OS browser to finish authenticating, but it cannot close the browser.

 * It can however response with a HTTP 200 OK message or a 302 Redirect, which can be configured here.

 * For more details, see https://aka.ms/msal4j-interactive-request
 */
public class SystemBrowserOptions {
    /**
     * When the user finishes authenticating, MSAL will respond with a Http 200 OK message, which the

     * browser will show to the user
     */
    private String htmlMessageSuccess;
    /**
     * WHen the user finishes authenticating, but an error occurred, MSAL will respond with a

     * Http 200 Ok message, which the browser will show to the user.
     */
    private String htmlMessageError;
    /**
     * When the user finishes authenticating, MSAL will redirect the browser to the given URI.

     * Takes precedence over htmlMessageSuccess
     */
    private URI browserRedirectSuccess;
    /**
     * When the the user finishes authenticating, but an error occurred, MSAL will redirect the

     * browser to the given URI.

     * Takes precedence over htmlMessageError
     */
    private URI browserRedirectError;
    /**
     * Allows developers to implement their own logic for starting a browser and navigating to a

     * specific Uri. Msal will use this when opening the browser. If not set, the user configured

     * browser will be used.
     */
    private OpenBrowserAction openBrowserAction;

    /**
     * Builder for {@link SystemBrowserOptions}
     */
    public static SystemBrowserOptionsBuilder builder() {
        return new SystemBrowserOptionsBuilder();
    }


    @java.lang.SuppressWarnings("all")
    public static class SystemBrowserOptionsBuilder {
        @java.lang.SuppressWarnings("all")
        private String htmlMessageSuccess;
        @java.lang.SuppressWarnings("all")
        private String htmlMessageError;
        @java.lang.SuppressWarnings("all")
        private URI browserRedirectSuccess;
        @java.lang.SuppressWarnings("all")
        private URI browserRedirectError;
        @java.lang.SuppressWarnings("all")
        private OpenBrowserAction openBrowserAction;

        @java.lang.SuppressWarnings("all")
        SystemBrowserOptionsBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        public SystemBrowserOptionsBuilder htmlMessageSuccess(final String htmlMessageSuccess) {
            this.htmlMessageSuccess = htmlMessageSuccess;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public SystemBrowserOptionsBuilder htmlMessageError(final String htmlMessageError) {
            this.htmlMessageError = htmlMessageError;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public SystemBrowserOptionsBuilder browserRedirectSuccess(final URI browserRedirectSuccess) {
            this.browserRedirectSuccess = browserRedirectSuccess;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public SystemBrowserOptionsBuilder browserRedirectError(final URI browserRedirectError) {
            this.browserRedirectError = browserRedirectError;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public SystemBrowserOptionsBuilder openBrowserAction(final OpenBrowserAction openBrowserAction) {
            this.openBrowserAction = openBrowserAction;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public SystemBrowserOptions build() {
            return new SystemBrowserOptions(htmlMessageSuccess, htmlMessageError, browserRedirectSuccess, browserRedirectError, openBrowserAction);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public java.lang.String toString() {
            return "SystemBrowserOptions.SystemBrowserOptionsBuilder(htmlMessageSuccess=" + this.htmlMessageSuccess + ", htmlMessageError=" + this.htmlMessageError + ", browserRedirectSuccess=" + this.browserRedirectSuccess + ", browserRedirectError=" + this.browserRedirectError + ", openBrowserAction=" + this.openBrowserAction + ")";
        }
    }

    /**
     * When the user finishes authenticating, MSAL will respond with a Http 200 OK message, which the

     * browser will show to the user
     */
    @java.lang.SuppressWarnings("all")
    public String htmlMessageSuccess() {
        return this.htmlMessageSuccess;
    }

    /**
     * WHen the user finishes authenticating, but an error occurred, MSAL will respond with a

     * Http 200 Ok message, which the browser will show to the user.
     */
    @java.lang.SuppressWarnings("all")
    public String htmlMessageError() {
        return this.htmlMessageError;
    }

    /**
     * When the user finishes authenticating, MSAL will redirect the browser to the given URI.

     * Takes precedence over htmlMessageSuccess
     */
    @java.lang.SuppressWarnings("all")
    public URI browserRedirectSuccess() {
        return this.browserRedirectSuccess;
    }

    /**
     * When the the user finishes authenticating, but an error occurred, MSAL will redirect the

     * browser to the given URI.

     * Takes precedence over htmlMessageError
     */
    @java.lang.SuppressWarnings("all")
    public URI browserRedirectError() {
        return this.browserRedirectError;
    }

    /**
     * Allows developers to implement their own logic for starting a browser and navigating to a

     * specific Uri. Msal will use this when opening the browser. If not set, the user configured

     * browser will be used.
     */
    @java.lang.SuppressWarnings("all")
    public OpenBrowserAction openBrowserAction() {
        return this.openBrowserAction;
    }

    @java.lang.SuppressWarnings("all")
    private SystemBrowserOptions(final String htmlMessageSuccess, final String htmlMessageError, final URI browserRedirectSuccess, final URI browserRedirectError, final OpenBrowserAction openBrowserAction) {
        this.htmlMessageSuccess = htmlMessageSuccess;
        this.htmlMessageError = htmlMessageError;
        this.browserRedirectSuccess = browserRedirectSuccess;
        this.browserRedirectError = browserRedirectError;
        this.openBrowserAction = openBrowserAction;
    }
}
