/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.msal4j;

import com.microsoft.aad.msal4j.AbstractManagedIdentitySource;
import com.microsoft.aad.msal4j.HttpMethod;
import com.microsoft.aad.msal4j.IEnvironmentVariables;
import com.microsoft.aad.msal4j.ManagedIdentityApplication;
import com.microsoft.aad.msal4j.ManagedIdentityIdType;
import com.microsoft.aad.msal4j.ManagedIdentityParameters;
import com.microsoft.aad.msal4j.ManagedIdentitySourceType;
import com.microsoft.aad.msal4j.MsalManagedIdentityException;
import com.microsoft.aad.msal4j.MsalRequest;
import com.microsoft.aad.msal4j.ServiceBundle;
import com.microsoft.aad.msal4j.StringHelper;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CloudShellManagedIdentitySource
extends AbstractManagedIdentitySource {
    private static final Logger LOG = LoggerFactory.getLogger(CloudShellManagedIdentitySource.class);
    private final URI MSI_ENDPOINT;

    @Override
    public void createManagedIdentityRequest(String resource) {
        this.managedIdentityRequest.baseEndpoint = this.MSI_ENDPOINT;
        this.managedIdentityRequest.method = HttpMethod.POST;
        this.managedIdentityRequest.headers = new HashMap<String, String>();
        this.managedIdentityRequest.headers.put("ContentType", "application/x-www-form-urlencoded");
        this.managedIdentityRequest.headers.put("Metadata", "true");
        this.managedIdentityRequest.bodyParameters = new HashMap<String, List<String>>();
        this.managedIdentityRequest.bodyParameters.put("resource", Collections.singletonList(resource));
    }

    private CloudShellManagedIdentitySource(MsalRequest msalRequest, ServiceBundle serviceBundle, URI msiEndpoint) {
        super(msalRequest, serviceBundle, ManagedIdentitySourceType.CLOUD_SHELL);
        this.MSI_ENDPOINT = msiEndpoint;
        ManagedIdentityIdType idType = ((ManagedIdentityApplication)msalRequest.application()).getManagedIdentityId().getIdType();
        if (idType != ManagedIdentityIdType.SYSTEM_ASSIGNED) {
            throw new MsalManagedIdentityException("user_assigned_managed_identity_not_supported", String.format("[Managed Identity] User assigned identity is not supported by the %s Managed Identity. To authenticate with the system assigned identity use ManagedIdentityApplication.builder(ManagedIdentityId.systemAssigned()).build().", "cloud shell"), ManagedIdentitySourceType.CLOUD_SHELL);
        }
    }

    static AbstractManagedIdentitySource create(MsalRequest msalRequest, ServiceBundle serviceBundle) {
        IEnvironmentVariables environmentVariables = CloudShellManagedIdentitySource.getEnvironmentVariables((ManagedIdentityParameters)msalRequest.requestContext().apiParameters());
        String msiEndpoint = environmentVariables.getEnvironmentVariable("MSI_ENDPOINT");
        if (StringHelper.isNullOrBlank(msiEndpoint)) {
            LOG.info("[Managed Identity] Cloud shell managed identity is unavailable.");
            return null;
        }
        URI validatedUri = CloudShellManagedIdentitySource.validateAndGetUri(msiEndpoint);
        return validatedUri == null ? null : new CloudShellManagedIdentitySource(msalRequest, serviceBundle, validatedUri);
    }

    private static URI validateAndGetUri(String msiEndpoint) {
        URI endpointUri = null;
        try {
            endpointUri = new URI(msiEndpoint);
        }
        catch (URISyntaxException ex) {
            throw new MsalManagedIdentityException("invalid_managed_identity_endpoint", String.format("[Managed Identity] The environment variable %s contains an invalid Uri %s in %s managed identity source.", "MSI_ENDPOINT", msiEndpoint, "Cloud Shell"), ManagedIdentitySourceType.CLOUD_SHELL);
        }
        LOG.info("[Managed Identity] Environment variables validation passed for cloud shell managed identity. Endpoint URI: " + endpointUri + ". Creating cloud shell managed identity.");
        return endpointUri;
    }
}

