/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.msal4j;

import com.microsoft.aad.msal4j.EnvironmentVariables;
import com.microsoft.aad.msal4j.HttpHelper;
import com.microsoft.aad.msal4j.HttpMethod;
import com.microsoft.aad.msal4j.HttpRequest;
import com.microsoft.aad.msal4j.IEnvironmentVariables;
import com.microsoft.aad.msal4j.IHttpResponse;
import com.microsoft.aad.msal4j.JsonHelper;
import com.microsoft.aad.msal4j.ManagedIdentityErrorResponse;
import com.microsoft.aad.msal4j.ManagedIdentityParameters;
import com.microsoft.aad.msal4j.ManagedIdentityRequest;
import com.microsoft.aad.msal4j.ManagedIdentityResponse;
import com.microsoft.aad.msal4j.ManagedIdentitySourceType;
import com.microsoft.aad.msal4j.MsalClientException;
import com.microsoft.aad.msal4j.MsalManagedIdentityException;
import com.microsoft.aad.msal4j.MsalRequest;
import com.microsoft.aad.msal4j.ServiceBundle;
import java.net.SocketException;
import java.net.URISyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractManagedIdentitySource {
    protected static final String TIMEOUT_ERROR = "[Managed Identity] Authentication unavailable. The request to the managed identity endpoint timed out.";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractManagedIdentitySource.class);
    private static final String MANAGED_IDENTITY_NO_RESPONSE_RECEIVED = "[Managed Identity] Authentication unavailable. No response received from the managed identity endpoint.";
    protected final ManagedIdentityRequest managedIdentityRequest;
    protected final ServiceBundle serviceBundle;
    private ManagedIdentitySourceType managedIdentitySourceType;
    private boolean isUserAssignedManagedIdentity;
    private String managedIdentityUserAssignedClientId;
    private String managedIdentityUserAssignedResourceId;

    public AbstractManagedIdentitySource(MsalRequest msalRequest, ServiceBundle serviceBundle, ManagedIdentitySourceType sourceType) {
        this.managedIdentityRequest = (ManagedIdentityRequest)msalRequest;
        this.managedIdentitySourceType = sourceType;
        this.serviceBundle = serviceBundle;
    }

    public ManagedIdentityResponse getManagedIdentityResponse(ManagedIdentityParameters parameters) {
        IHttpResponse response;
        this.createManagedIdentityRequest(parameters.resource);
        try {
            HttpRequest httpRequest = this.managedIdentityRequest.method.equals((Object)HttpMethod.GET) ? new HttpRequest(HttpMethod.GET, this.managedIdentityRequest.computeURI().toString(), this.managedIdentityRequest.headers) : new HttpRequest(HttpMethod.POST, this.managedIdentityRequest.computeURI().toString(), this.managedIdentityRequest.headers, this.managedIdentityRequest.getBodyAsString());
            response = HttpHelper.executeHttpRequest(httpRequest, this.managedIdentityRequest.requestContext(), this.serviceBundle);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        catch (MsalClientException e) {
            if (e.getCause() instanceof SocketException) {
                throw new MsalManagedIdentityException("managed_identity_unreachable_network", e.getMessage(), this.managedIdentitySourceType);
            }
            throw e;
        }
        return this.handleResponse(parameters, response);
    }

    public ManagedIdentityResponse handleResponse(ManagedIdentityParameters parameters, IHttpResponse response) {
        try {
            if (response.statusCode() == 200) {
                LOG.info("[Managed Identity] Successful response received.");
                return this.getSuccessfulResponse(response);
            }
            String message = this.getMessageFromErrorResponse(response);
            LOG.error(String.format("[Managed Identity] request failed, HttpStatusCode: %s Error message: %s", response.statusCode(), message));
            throw new MsalManagedIdentityException("managed_identity_request_failed", message, this.managedIdentitySourceType);
        }
        catch (Exception e) {
            if (e instanceof MsalManagedIdentityException) {
                throw e;
            }
            LOG.error(String.format("[Managed Identity] Exception: %s Http status code: %s", e.getMessage(), response != null ? Integer.valueOf(response.statusCode()) : ""));
            String message = "[Managed Identity] Unexpected exception occurred when parsing the response. See the inner exception for details.";
            throw new MsalManagedIdentityException("managed_identity_request_failed", message, this.managedIdentitySourceType);
        }
    }

    public abstract void createManagedIdentityRequest(String var1);

    protected ManagedIdentityResponse getSuccessfulResponse(IHttpResponse response) {
        ManagedIdentityResponse managedIdentityResponse = JsonHelper.convertJsonToObject(response.body(), ManagedIdentityResponse.class);
        if (managedIdentityResponse == null || managedIdentityResponse.getAccessToken() == null || managedIdentityResponse.getAccessToken().isEmpty() || managedIdentityResponse.getExpiresOn() == null || managedIdentityResponse.getExpiresOn().isEmpty()) {
            LOG.error("[Managed Identity] Response is either null or insufficient for authentication.");
            throw new MsalManagedIdentityException("managed_identity_request_failed", "[Managed Identity] Unexpected exception occurred when parsing the response. See the inner exception for details.", this.managedIdentitySourceType);
        }
        return managedIdentityResponse;
    }

    protected String getMessageFromErrorResponse(IHttpResponse response) {
        ManagedIdentityErrorResponse managedIdentityErrorResponse = JsonHelper.convertJsonToObject(response.body(), ManagedIdentityErrorResponse.class);
        if (managedIdentityErrorResponse == null) {
            return MANAGED_IDENTITY_NO_RESPONSE_RECEIVED;
        }
        if (managedIdentityErrorResponse.getMessage() != null && !managedIdentityErrorResponse.getMessage().isEmpty()) {
            return String.format("[Managed Identity] Error Message: %s Managed Identity Correlation ID: %s Use this Correlation ID for further investigation.", managedIdentityErrorResponse.getMessage(), managedIdentityErrorResponse.getCorrelationId());
        }
        return String.format("[Managed Identity] Error Code: %s Error Message: %s", managedIdentityErrorResponse.getError(), managedIdentityErrorResponse.getErrorDescription());
    }

    protected static IEnvironmentVariables getEnvironmentVariables(ManagedIdentityParameters parameters) {
        return parameters.environmentVariables == null ? new EnvironmentVariables() : parameters.environmentVariables;
    }

    public boolean isUserAssignedManagedIdentity() {
        return this.isUserAssignedManagedIdentity;
    }

    public void setUserAssignedManagedIdentity(boolean isUserAssignedManagedIdentity) {
        this.isUserAssignedManagedIdentity = isUserAssignedManagedIdentity;
    }

    public String getManagedIdentityUserAssignedClientId() {
        return this.managedIdentityUserAssignedClientId;
    }

    public void setManagedIdentityUserAssignedClientId(String managedIdentityUserAssignedClientId) {
        this.managedIdentityUserAssignedClientId = managedIdentityUserAssignedClientId;
    }

    public String getManagedIdentityUserAssignedResourceId() {
        return this.managedIdentityUserAssignedResourceId;
    }

    public void setManagedIdentityUserAssignedResourceId(String managedIdentityUserAssignedResourceId) {
        this.managedIdentityUserAssignedResourceId = managedIdentityUserAssignedResourceId;
    }
}

