// Generated by delombok at Thu Feb 03 15:51:24 UTC 2022
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
package com.microsoft.aad.msal4j;

import lombok.*;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import static com.microsoft.aad.msal4j.ParameterValidationUtils.validateNotNull;

/**
 * Object containing parameters for device code flow. Can be used as parameter to

 * {@link PublicClientApplication#acquireToken(DeviceCodeFlowParameters)}. For more details,

 * see https://aka.ms/msal4j-device-code
 */
public class DeviceCodeFlowParameters implements IAcquireTokenParameters {
    /**
     * Scopes to which the application is requesting access to.
     */
    @NonNull
    private Set<String> scopes;
    /**
     * Receives the device code returned from the first step of Oauth2.0 device code flow. The

     * {@link DeviceCode#verificationUri} and the {@link DeviceCode#userCode} should be shown

     * to the end user.

     * <p>

     * For more details, see https://aka.ms/msal4j-device-code
     */
    @NonNull
    private Consumer<DeviceCode> deviceCodeConsumer;
    /**
     * Claims to be requested through the OIDC claims request parameter, allowing requests for standard and custom claims
     */
    private ClaimsRequest claims;
    /**
     * Adds additional headers to the token request
     */
    private Map<String, String> extraHttpHeaders;
    /**
     * Overrides the tenant value in the authority URL for this request
     */
    private String tenant;

    private static DeviceCodeFlowParametersBuilder builder() {
        return new DeviceCodeFlowParametersBuilder();
    }

    /**
     * Builder for {@link DeviceCodeFlowParameters}

     *

     * @param scopes             scopes application is requesting access to

     * @param deviceCodeConsumer {@link Consumer} of {@link DeviceCode}

     * @return builder that can be used to construct DeviceCodeFlowParameters
     */
    public static DeviceCodeFlowParametersBuilder builder(Set<String> scopes, Consumer<DeviceCode> deviceCodeConsumer) {
        validateNotNull("scopes", scopes);
        return builder().scopes(scopes).deviceCodeConsumer(deviceCodeConsumer);
    }


    @java.lang.SuppressWarnings("all")
    public static class DeviceCodeFlowParametersBuilder {
        @java.lang.SuppressWarnings("all")
        private Set<String> scopes;
        @java.lang.SuppressWarnings("all")
        private Consumer<DeviceCode> deviceCodeConsumer;
        @java.lang.SuppressWarnings("all")
        private ClaimsRequest claims;
        @java.lang.SuppressWarnings("all")
        private Map<String, String> extraHttpHeaders;
        @java.lang.SuppressWarnings("all")
        private String tenant;

        @java.lang.SuppressWarnings("all")
        DeviceCodeFlowParametersBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        public DeviceCodeFlowParametersBuilder scopes(final Set<String> scopes) {
            this.scopes = scopes;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public DeviceCodeFlowParametersBuilder deviceCodeConsumer(final Consumer<DeviceCode> deviceCodeConsumer) {
            this.deviceCodeConsumer = deviceCodeConsumer;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public DeviceCodeFlowParametersBuilder claims(final ClaimsRequest claims) {
            this.claims = claims;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public DeviceCodeFlowParametersBuilder extraHttpHeaders(final Map<String, String> extraHttpHeaders) {
            this.extraHttpHeaders = extraHttpHeaders;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public DeviceCodeFlowParametersBuilder tenant(final String tenant) {
            this.tenant = tenant;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public DeviceCodeFlowParameters build() {
            return new DeviceCodeFlowParameters(scopes, deviceCodeConsumer, claims, extraHttpHeaders, tenant);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public java.lang.String toString() {
            return "DeviceCodeFlowParameters.DeviceCodeFlowParametersBuilder(scopes=" + this.scopes + ", deviceCodeConsumer=" + this.deviceCodeConsumer + ", claims=" + this.claims + ", extraHttpHeaders=" + this.extraHttpHeaders + ", tenant=" + this.tenant + ")";
        }
    }

    /**
     * Scopes to which the application is requesting access to.
     */
    @NonNull
    @java.lang.SuppressWarnings("all")
    public Set<String> scopes() {
        return this.scopes;
    }

    /**
     * Receives the device code returned from the first step of Oauth2.0 device code flow. The

     * {@link DeviceCode#verificationUri} and the {@link DeviceCode#userCode} should be shown

     * to the end user.

     * <p>

     * For more details, see https://aka.ms/msal4j-device-code
     */
    @NonNull
    @java.lang.SuppressWarnings("all")
    public Consumer<DeviceCode> deviceCodeConsumer() {
        return this.deviceCodeConsumer;
    }

    /**
     * Claims to be requested through the OIDC claims request parameter, allowing requests for standard and custom claims
     */
    @java.lang.SuppressWarnings("all")
    public ClaimsRequest claims() {
        return this.claims;
    }

    /**
     * Adds additional headers to the token request
     */
    @java.lang.SuppressWarnings("all")
    public Map<String, String> extraHttpHeaders() {
        return this.extraHttpHeaders;
    }

    /**
     * Overrides the tenant value in the authority URL for this request
     */
    @java.lang.SuppressWarnings("all")
    public String tenant() {
        return this.tenant;
    }

    @java.lang.SuppressWarnings("all")
    private DeviceCodeFlowParameters(@NonNull final Set<String> scopes, @NonNull final Consumer<DeviceCode> deviceCodeConsumer, final ClaimsRequest claims, final Map<String, String> extraHttpHeaders, final String tenant) {
        if (scopes == null) {
            throw new java.lang.NullPointerException("scopes is marked @NonNull but is null");
        }
        if (deviceCodeConsumer == null) {
            throw new java.lang.NullPointerException("deviceCodeConsumer is marked @NonNull but is null");
        }
        this.scopes = scopes;
        this.deviceCodeConsumer = deviceCodeConsumer;
        this.claims = claims;
        this.extraHttpHeaders = extraHttpHeaders;
        this.tenant = tenant;
    }
}
