/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.msal4j;

import com.microsoft.aad.msal4j.IAccount;
import com.microsoft.aad.msal4j.ParameterValidationUtils;
import java.util.Set;
import lombok.NonNull;

public class SilentParameters {
    @NonNull
    private Set<String> scopes;
    @NonNull
    private IAccount account;
    private String authorityUrl;
    private boolean forceRefresh;

    private static SilentParametersBuilder builder() {
        return new SilentParametersBuilder();
    }

    public static SilentParametersBuilder builder(Set<String> scopes, IAccount account) {
        ParameterValidationUtils.validateNotEmpty("scopes", scopes);
        return SilentParameters.builder().scopes(scopes).account(account);
    }

    @NonNull
    public Set<String> scopes() {
        return this.scopes;
    }

    @NonNull
    public IAccount account() {
        return this.account;
    }

    public String authorityUrl() {
        return this.authorityUrl;
    }

    public boolean forceRefresh() {
        return this.forceRefresh;
    }

    private SilentParameters(@NonNull Set<String> scopes, @NonNull IAccount account, String authorityUrl, boolean forceRefresh) {
        if (scopes == null) {
            throw new NullPointerException("scopes is marked @NonNull but is null");
        }
        if (account == null) {
            throw new NullPointerException("account is marked @NonNull but is null");
        }
        this.scopes = scopes;
        this.account = account;
        this.authorityUrl = authorityUrl;
        this.forceRefresh = forceRefresh;
    }

    public static class SilentParametersBuilder {
        private Set<String> scopes;
        private IAccount account;
        private String authorityUrl;
        private boolean forceRefresh;

        SilentParametersBuilder() {
        }

        public SilentParametersBuilder scopes(@NonNull Set<String> scopes) {
            if (scopes == null) {
                throw new NullPointerException("scopes is marked @NonNull but is null");
            }
            this.scopes = scopes;
            return this;
        }

        public SilentParametersBuilder account(@NonNull IAccount account) {
            if (account == null) {
                throw new NullPointerException("account is marked @NonNull but is null");
            }
            this.account = account;
            return this;
        }

        public SilentParametersBuilder authorityUrl(String authorityUrl) {
            this.authorityUrl = authorityUrl;
            return this;
        }

        public SilentParametersBuilder forceRefresh(boolean forceRefresh) {
            this.forceRefresh = forceRefresh;
            return this;
        }

        public SilentParameters build() {
            return new SilentParameters(this.scopes, this.account, this.authorityUrl, this.forceRefresh);
        }

        public String toString() {
            return "SilentParameters.SilentParametersBuilder(scopes=" + this.scopes + ", account=" + this.account + ", authorityUrl=" + this.authorityUrl + ", forceRefresh=" + this.forceRefresh + ")";
        }
    }
}

