/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.msal4j;

import com.microsoft.aad.msal4j.Account;
import com.microsoft.aad.msal4j.TokenCache;

public class TokenCacheAccessContext {
    private TokenCache tokenCache;
    private String clientId;
    private Account account;
    private boolean isCacheChanged;

    TokenCacheAccessContext(TokenCache tokenCache, String clientId, Account account, boolean isCacheChanged) {
        this.tokenCache = tokenCache;
        this.clientId = clientId;
        this.account = account;
        this.isCacheChanged = isCacheChanged;
    }

    public static TokenCacheAccessContextBuilder builder() {
        return new TokenCacheAccessContextBuilder();
    }

    public TokenCache getTokenCache() {
        return this.tokenCache;
    }

    public String getClientId() {
        return this.clientId;
    }

    public Account getAccount() {
        return this.account;
    }

    public boolean isCacheChanged() {
        return this.isCacheChanged;
    }

    public static class TokenCacheAccessContextBuilder {
        private TokenCache tokenCache;
        private String clientId;
        private Account account;
        private boolean isCacheChanged;

        TokenCacheAccessContextBuilder() {
        }

        public TokenCacheAccessContextBuilder tokenCache(TokenCache tokenCache) {
            this.tokenCache = tokenCache;
            return this;
        }

        public TokenCacheAccessContextBuilder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public TokenCacheAccessContextBuilder account(Account account) {
            this.account = account;
            return this;
        }

        public TokenCacheAccessContextBuilder isCacheChanged(boolean isCacheChanged) {
            this.isCacheChanged = isCacheChanged;
            return this;
        }

        public TokenCacheAccessContext build() {
            return new TokenCacheAccessContext(this.tokenCache, this.clientId, this.account, this.isCacheChanged);
        }

        public String toString() {
            return "TokenCacheAccessContext.TokenCacheAccessContextBuilder(tokenCache=" + this.tokenCache + ", clientId=" + this.clientId + ", account=" + this.account + ", isCacheChanged=" + this.isCacheChanged + ")";
        }
    }
}

