/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.msal4j;

import com.microsoft.aad.msal4j.AadInstanceDiscovery;
import com.microsoft.aad.msal4j.Account;
import com.microsoft.aad.msal4j.ClientApplicationBase;
import com.microsoft.aad.msal4j.ClientDataHttpHeaders;
import com.microsoft.aad.msal4j.InstanceDiscoveryMetadataEntry;
import com.microsoft.aad.msal4j.LogHelper;
import java.util.Collection;
import java.util.concurrent.CompletionException;
import java.util.function.Supplier;

class AccountsSupplier
implements Supplier<Collection<Account>> {
    ClientDataHttpHeaders headers;
    ClientApplicationBase clientApplication;

    AccountsSupplier(ClientApplicationBase clientApplication) {
        this.clientApplication = clientApplication;
        this.headers = new ClientDataHttpHeaders(clientApplication.correlationId());
    }

    @Override
    public Collection<Account> get() {
        Collection<Account> accounts;
        try {
            InstanceDiscoveryMetadataEntry instanceDiscoveryData = AadInstanceDiscovery.cache.get(this.clientApplication.authenticationAuthority.host());
            accounts = this.clientApplication.tokenCache.getAccounts(this.clientApplication.clientId(), instanceDiscoveryData.getAliasesSet());
        }
        catch (Exception ex) {
            this.clientApplication.log.error(LogHelper.createMessage("Execution of " + this.getClass() + " failed.", this.headers.getHeaderCorrelationIdValue()), (Throwable)ex);
            throw new CompletionException(ex);
        }
        return accounts;
    }
}

