/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.msal4j;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponse;
import com.nimbusds.openid.connect.sdk.token.OIDCTokens;
import net.minidev.json.JSONObject;

class TokenResponse
extends OIDCTokenResponse {
    private String scope;
    private String clientInfo;
    private long expiresIn;
    private long extExpiresIn;

    TokenResponse(AccessToken accessToken, RefreshToken refreshToken, String idToken) {
        super(new OIDCTokens(idToken, accessToken, refreshToken));
    }

    TokenResponse(AccessToken accessToken, RefreshToken refreshToken, String idToken, String scope, String clientInfo, long expiresIn, long extExpiresIn) {
        this(accessToken, refreshToken, idToken);
        this.scope = scope;
        this.clientInfo = clientInfo;
        this.expiresIn = expiresIn;
        this.extExpiresIn = extExpiresIn;
    }

    static TokenResponse parseHttpResponse(HTTPResponse httpResponse) throws ParseException {
        httpResponse.ensureStatusCode(new int[]{200});
        JSONObject jsonObject = httpResponse.getContentAsJSONObject();
        return TokenResponse.parseJsonObject(jsonObject);
    }

    static TokenResponse parseJsonObject(JSONObject jsonObject) throws ParseException {
        AccessToken accessToken = AccessToken.parse((JSONObject)jsonObject);
        RefreshToken refreshToken = RefreshToken.parse((JSONObject)jsonObject);
        String idTokenValue = "";
        if (jsonObject.containsKey((Object)"id_token")) {
            idTokenValue = JSONObjectUtils.getString((JSONObject)jsonObject, (String)"id_token");
        }
        String scopeValue = null;
        if (jsonObject.containsKey((Object)"scope")) {
            scopeValue = JSONObjectUtils.getString((JSONObject)jsonObject, (String)"scope");
        }
        String clientInfo = null;
        if (jsonObject.containsKey((Object)"client_info")) {
            clientInfo = JSONObjectUtils.getString((JSONObject)jsonObject, (String)"client_info");
        }
        long expiresIn = 0L;
        if (jsonObject.containsKey((Object)"expires_in")) {
            expiresIn = JSONObjectUtils.getLong((JSONObject)jsonObject, (String)"expires_in");
        }
        long ext_expires_in = 0L;
        if (jsonObject.containsKey((Object)"ext_expires_in")) {
            ext_expires_in = JSONObjectUtils.getLong((JSONObject)jsonObject, (String)"ext_expires_in");
        }
        return new TokenResponse(accessToken, refreshToken, idTokenValue, scopeValue, clientInfo, expiresIn, ext_expires_in);
    }

    String getScope() {
        return this.scope;
    }

    String getClientInfo() {
        return this.clientInfo;
    }

    long getExpiresIn() {
        return this.expiresIn;
    }

    long getExtExpiresIn() {
        return this.extExpiresIn;
    }
}

