/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.msal4j;

import com.microsoft.aad.msal4j.AadInstanceDiscovery;
import com.microsoft.aad.msal4j.ApiEvent;
import com.microsoft.aad.msal4j.AuthenticationAuthority;
import com.microsoft.aad.msal4j.AuthenticationException;
import com.microsoft.aad.msal4j.AuthenticationResult;
import com.microsoft.aad.msal4j.ClientApplicationBase;
import com.microsoft.aad.msal4j.ClientDataHttpHeaders;
import com.microsoft.aad.msal4j.ConfidentialClientApplication;
import com.microsoft.aad.msal4j.InstanceDiscoveryMetadataEntry;
import com.microsoft.aad.msal4j.LogHelper;
import com.microsoft.aad.msal4j.MsalRequest;
import com.microsoft.aad.msal4j.StringHelper;
import com.microsoft.aad.msal4j.TelemetryHelper;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.CompletionException;
import java.util.function.Supplier;
import org.apache.commons.codec.binary.Base64;

abstract class AuthenticationResultSupplier
implements Supplier<AuthenticationResult> {
    ClientApplicationBase clientApplication;
    MsalRequest msalRequest;

    AuthenticationResultSupplier(ClientApplicationBase clientApplication, MsalRequest msalRequest) {
        this.clientApplication = clientApplication;
        this.msalRequest = msalRequest;
    }

    AuthenticationAuthority getAuthorityWithPrefNetworkHost(String authority) throws Exception {
        URL authorityUrl = new URL(authority);
        InstanceDiscoveryMetadataEntry discoveryMetadataEntry = AadInstanceDiscovery.GetMetadataEntry(authorityUrl, this.clientApplication.validateAuthority(), this.msalRequest, this.clientApplication.getServiceBundle());
        URL updatedAuthorityUrl = new URL(authorityUrl.getProtocol(), discoveryMetadataEntry.preferredNetwork, authorityUrl.getFile());
        return new AuthenticationAuthority(updatedAuthorityUrl);
    }

    abstract AuthenticationResult execute() throws Exception;

    @Override
    public AuthenticationResult get() {
        AuthenticationResult result;
        ApiEvent apiEvent = this.initializeApiEvent(this.msalRequest);
        try (TelemetryHelper telemetryHelper = this.clientApplication.getServiceBundle().getTelemetryManager().createTelemetryHelper(this.msalRequest.requestContext().getTelemetryRequestId(), this.msalRequest.application().clientId(), apiEvent, true);){
            try {
                result = this.execute();
                this.logResult(result, this.msalRequest.headers());
                apiEvent.setWasSuccessful(true);
                if (result.account() != null) {
                    apiEvent.setTenantId(result.account().realm());
                }
            }
            catch (Exception ex) {
                if (ex instanceof AuthenticationException) {
                    apiEvent.setApiErrorCode(((AuthenticationException)ex).getErrorCode());
                }
                this.clientApplication.log.error(LogHelper.createMessage("Execution of " + this.getClass() + " failed.", this.msalRequest.headers().getHeaderCorrelationIdValue()), (Throwable)ex);
                throw new CompletionException(ex);
            }
        }
        return result;
    }

    void logResult(AuthenticationResult result, ClientDataHttpHeaders headers) {
        if (!StringHelper.isBlank(result.accessToken())) {
            String accessTokenHash = this.computeSha256Hash(result.accessToken());
            if (!StringHelper.isBlank(result.refreshToken())) {
                String refreshTokenHash = this.computeSha256Hash(result.refreshToken());
                if (this.clientApplication.logPii()) {
                    this.clientApplication.log.debug(LogHelper.createMessage(String.format("Access Token with hash '%s' and Refresh Token with hash '%s' returned", accessTokenHash, refreshTokenHash), headers.getHeaderCorrelationIdValue()));
                } else {
                    this.clientApplication.log.debug(LogHelper.createMessage("Access Token and Refresh Token were returned", headers.getHeaderCorrelationIdValue()));
                }
            } else if (this.clientApplication.logPii()) {
                this.clientApplication.log.debug(LogHelper.createMessage(String.format("Access Token with hash '%s' returned", accessTokenHash), headers.getHeaderCorrelationIdValue()));
            } else {
                this.clientApplication.log.debug(LogHelper.createMessage("Access Token was returned", headers.getHeaderCorrelationIdValue()));
            }
        }
    }

    private ApiEvent initializeApiEvent(MsalRequest msalRequest) {
        ApiEvent apiEvent = new ApiEvent(this.clientApplication.logPii());
        msalRequest.requestContext().setTelemetryRequestId(this.clientApplication.getServiceBundle().getTelemetryManager().generateRequestId());
        apiEvent.setApiId(msalRequest.requestContext().getAcquireTokenPublicApi().getApiId());
        apiEvent.setCorrelationId(msalRequest.requestContext().getCorrelationId());
        apiEvent.setRequestId(msalRequest.requestContext().getTelemetryRequestId());
        apiEvent.setWasSuccessful(false);
        if (this.clientApplication instanceof ConfidentialClientApplication) {
            apiEvent.setIsConfidentialClient(true);
        } else {
            apiEvent.setIsConfidentialClient(false);
        }
        try {
            AuthenticationAuthority authenticationAuthority = this.clientApplication.authenticationAuthority;
            if (authenticationAuthority != null) {
                apiEvent.setAuthority(new URI(authenticationAuthority.getAuthority()));
                apiEvent.setAuthorityType(authenticationAuthority.getAuthorityType().toString());
            }
        }
        catch (URISyntaxException ex) {
            this.clientApplication.log.warn(LogHelper.createMessage("Setting URL telemetry fields failed: " + LogHelper.getPiiScrubbedDetails(ex), msalRequest.headers().getHeaderCorrelationIdValue()));
        }
        return apiEvent;
    }

    private String computeSha256Hash(String input) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(input.getBytes("UTF-8"));
            byte[] hash = digest.digest();
            return Base64.encodeBase64URLSafeString((byte[])hash);
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException ex) {
            this.clientApplication.log.warn(LogHelper.createMessage("Failed to compute SHA-256 hash due to exception - ", LogHelper.getPiiScrubbedDetails(ex)));
            return "Failed to compute SHA-256 hash";
        }
    }
}

