/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.msal4j;

import com.microsoft.aad.msal4j.AcquireTokenByAuthorizationGrantSupplier;
import com.microsoft.aad.msal4j.AuthenticationAuthority;
import com.microsoft.aad.msal4j.AuthenticationResult;
import com.microsoft.aad.msal4j.AuthenticationResultSupplier;
import com.microsoft.aad.msal4j.ClientApplicationBase;
import com.microsoft.aad.msal4j.RefreshTokenParameters;
import com.microsoft.aad.msal4j.RefreshTokenRequest;
import com.microsoft.aad.msal4j.SilentRequest;
import com.microsoft.aad.msal4j.StringHelper;

class AcquireTokenSilentSupplier
extends AuthenticationResultSupplier {
    private SilentRequest silentRequest;

    AcquireTokenSilentSupplier(ClientApplicationBase clientApplication, SilentRequest silentRequest) {
        super(clientApplication, silentRequest);
        this.silentRequest = silentRequest;
    }

    @Override
    AuthenticationResult execute() throws Exception {
        AuthenticationAuthority requestAuthority = this.getAuthorityWithPrefNetworkHost(this.silentRequest.requestAuthority().getAuthority());
        AuthenticationResult res = this.clientApplication.tokenCache.getAuthenticationResult(this.silentRequest.parameters().account(), requestAuthority, this.silentRequest.parameters().scopes(), this.clientApplication.clientId());
        if (!this.silentRequest.parameters().forceRefresh() && !StringHelper.isBlank(res.accessToken())) {
            return res;
        }
        if (StringHelper.isBlank(res.refreshToken())) {
            return null;
        }
        RefreshTokenRequest refreshTokenRequest = new RefreshTokenRequest(RefreshTokenParameters.builder(this.silentRequest.parameters().scopes(), res.refreshToken()).build(), this.silentRequest.application(), this.silentRequest.requestContext());
        AcquireTokenByAuthorizationGrantSupplier acquireTokenByAuthorisationGrantSupplier = new AcquireTokenByAuthorizationGrantSupplier(this.clientApplication, refreshTokenRequest, requestAuthority);
        return acquireTokenByAuthorisationGrantSupplier.execute();
    }
}

