/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.msal4j;

import com.microsoft.aad.msal4j.AbstractMsalAuthorizationGrant;
import com.microsoft.aad.msal4j.AuthenticationAuthority;
import com.microsoft.aad.msal4j.AuthenticationException;
import com.microsoft.aad.msal4j.AuthenticationResult;
import com.microsoft.aad.msal4j.AuthenticationResultSupplier;
import com.microsoft.aad.msal4j.ClientApplicationBase;
import com.microsoft.aad.msal4j.IntegratedWindowsAuthorizationGrant;
import com.microsoft.aad.msal4j.MsalRequest;
import com.microsoft.aad.msal4j.OAuthAuthorizationGrant;
import com.microsoft.aad.msal4j.SAML11BearerGrant;
import com.microsoft.aad.msal4j.UserDiscoveryRequest;
import com.microsoft.aad.msal4j.UserDiscoveryResponse;
import com.microsoft.aad.msal4j.WSTrustRequest;
import com.microsoft.aad.msal4j.WSTrustResponse;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.ResourceOwnerPasswordCredentialsGrant;
import com.nimbusds.oauth2.sdk.SAML2BearerGrant;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.commons.codec.binary.Base64;

class AcquireTokenByAuthorizationGrantSupplier
extends AuthenticationResultSupplier {
    private AuthenticationAuthority requestAuthority;
    private MsalRequest msalRequest;

    AcquireTokenByAuthorizationGrantSupplier(ClientApplicationBase clientApplication, MsalRequest msalRequest, AuthenticationAuthority authority) {
        super(clientApplication, msalRequest);
        this.msalRequest = msalRequest;
        this.requestAuthority = authority;
    }

    @Override
    AuthenticationResult execute() throws Exception {
        AbstractMsalAuthorizationGrant authGrant = this.msalRequest.msalAuthorizationGrant();
        if (authGrant instanceof OAuthAuthorizationGrant) {
            this.msalRequest.msalAuthorizationGrant = this.processPasswordGrant((OAuthAuthorizationGrant)authGrant);
        }
        if (authGrant instanceof IntegratedWindowsAuthorizationGrant) {
            IntegratedWindowsAuthorizationGrant integratedAuthGrant = (IntegratedWindowsAuthorizationGrant)authGrant;
            this.msalRequest.msalAuthorizationGrant = new OAuthAuthorizationGrant(this.getAuthorizationGrantIntegrated(integratedAuthGrant.getUserName()), integratedAuthGrant.getScopes());
        }
        if (this.requestAuthority == null) {
            this.requestAuthority = this.clientApplication.authenticationAuthority;
        }
        this.requestAuthority = this.getAuthorityWithPrefNetworkHost(this.requestAuthority.getAuthority());
        return this.clientApplication.acquireTokenCommon(this.msalRequest, this.requestAuthority);
    }

    private OAuthAuthorizationGrant processPasswordGrant(OAuthAuthorizationGrant authGrant) throws Exception {
        if (!(authGrant.getAuthorizationGrant() instanceof ResourceOwnerPasswordCredentialsGrant)) {
            return authGrant;
        }
        ResourceOwnerPasswordCredentialsGrant grant = (ResourceOwnerPasswordCredentialsGrant)authGrant.getAuthorizationGrant();
        UserDiscoveryResponse userDiscoveryResponse = UserDiscoveryRequest.execute(this.clientApplication.authenticationAuthority.getUserRealmEndpoint(grant.getUsername()), this.msalRequest.headers().getReadonlyHeaderMap(), this.msalRequest.requestContext(), this.clientApplication.getServiceBundle());
        if (userDiscoveryResponse.isAccountFederated()) {
            WSTrustResponse response = WSTrustRequest.execute(userDiscoveryResponse.getFederationMetadataUrl(), grant.getUsername(), grant.getPassword().getValue(), userDiscoveryResponse.getCloudAudienceUrn(), this.msalRequest.requestContext(), this.clientApplication.getServiceBundle(), this.clientApplication.logPii());
            AuthorizationGrant updatedGrant = this.getSAMLAuthorizationGrant(response);
            authGrant = new OAuthAuthorizationGrant(updatedGrant, authGrant.getCustomParameters());
        }
        return authGrant;
    }

    private AuthorizationGrant getSAMLAuthorizationGrant(WSTrustResponse response) throws UnsupportedEncodingException {
        SAML11BearerGrant updatedGrant = response.isTokenSaml2() ? new SAML2BearerGrant(new Base64URL(Base64.encodeBase64String((byte[])response.getToken().getBytes("UTF-8")))) : new SAML11BearerGrant(new Base64URL(Base64.encodeBase64String((byte[])response.getToken().getBytes())));
        return updatedGrant;
    }

    private AuthorizationGrant getAuthorizationGrantIntegrated(String userName) throws Exception {
        String userRealmEndpoint = this.clientApplication.authenticationAuthority.getUserRealmEndpoint(URLEncoder.encode(userName, "UTF-8"));
        UserDiscoveryResponse userRealmResponse = UserDiscoveryRequest.execute(userRealmEndpoint, this.msalRequest.headers().getReadonlyHeaderMap(), this.msalRequest.requestContext(), this.clientApplication.getServiceBundle());
        if (!userRealmResponse.isAccountFederated() || !"WSTrust".equalsIgnoreCase(userRealmResponse.getFederationProtocol())) {
            if (userRealmResponse.isAccountManaged()) {
                throw new AuthenticationException("Password is required for managed user");
            }
            throw new AuthenticationException("Unknown User Type");
        }
        String mexURL = userRealmResponse.getFederationMetadataUrl();
        String cloudAudienceUrn = userRealmResponse.getCloudAudienceUrn();
        WSTrustResponse wsTrustResponse = WSTrustRequest.execute(mexURL, cloudAudienceUrn, this.msalRequest.requestContext(), this.clientApplication.getServiceBundle(), this.clientApplication.logPii());
        AuthorizationGrant updatedGrant = this.getSAMLAuthorizationGrant(wsTrustResponse);
        return updatedGrant;
    }
}

