/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.mobile.react.mobilecentershared;

import android.app.Application;
import com.microsoft.azure.mobile.MobileCenter;
import com.microsoft.azure.mobile.ingestion.models.WrapperSdk;
import java.io.InputStream;
import org.json.JSONObject;

public class RNMobileCenterShared {
    private static String appSecret;
    private static Application application;
    private static WrapperSdk wrapperSdk;

    public static void configureMobileCenter(Application application) {
        if (MobileCenter.isConfigured()) {
            return;
        }
        RNMobileCenterShared.application = application;
        wrapperSdk.setWrapperSdkVersion("0.8.0");
        wrapperSdk.setWrapperSdkName("mobilecenter.react-native");
        MobileCenter.setWrapperSdk((WrapperSdk)wrapperSdk);
        MobileCenter.configure((Application)application, (String)RNMobileCenterShared.getAppSecret());
    }

    public static void setWrapperSdk(WrapperSdk wrapperSdk) {
        RNMobileCenterShared.wrapperSdk = wrapperSdk;
        MobileCenter.setWrapperSdk((WrapperSdk)wrapperSdk);
    }

    public static WrapperSdk getWrapperSdk() {
        return wrapperSdk;
    }

    public static void setAppSecret(String secret) {
        appSecret = secret;
    }

    public static String getAppSecret() {
        if (appSecret == null) {
            try {
                InputStream configStream = application.getAssets().open("mobile-center-config.json");
                int size = configStream.available();
                byte[] buffer = new byte[size];
                configStream.read(buffer);
                configStream.close();
                String jsonContents = new String(buffer, "UTF-8");
                JSONObject json = new JSONObject(jsonContents);
                appSecret = json.getString("app_secret");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return appSecret;
    }

    static {
        wrapperSdk = new WrapperSdk();
    }
}

