/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.mobile.utils;

import android.support.annotation.VisibleForTesting;
import com.microsoft.azure.mobile.utils.MobileCenterLog;
import java.util.Random;
import java.util.UUID;

public final class UUIDUtils {
    @VisibleForTesting
    static Implementation sImplementation = new Implementation(){

        @Override
        public UUID randomUUID() {
            return UUID.randomUUID();
        }
    };
    private static Random sRandom;

    @VisibleForTesting
    UUIDUtils() {
    }

    public static UUID randomUUID() {
        try {
            return sImplementation.randomUUID();
        }
        catch (SecurityException e) {
            UUIDUtils.initFailOver(e);
            long highest = sRandom.nextLong() & 0xFFFFFFFFFFFF0FFFL | 0x4000L;
            long lowest = sRandom.nextLong() & 0x3FFFFFFFFFFFFFFFL | Long.MIN_VALUE;
            return new UUID(highest, lowest);
        }
    }

    private static synchronized void initFailOver(SecurityException e) {
        if (sRandom == null) {
            sRandom = new Random();
            MobileCenterLog.error("MobileCenter", "UUID.randomUUID failed, using Random as fallback", e);
        }
    }

    @VisibleForTesting
    static interface Implementation {
        public UUID randomUUID();
    }
}

