/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.mobile.ingestion.http;

import com.microsoft.azure.mobile.ingestion.Ingestion;
import com.microsoft.azure.mobile.ingestion.ServiceCall;
import com.microsoft.azure.mobile.ingestion.ServiceCallback;
import com.microsoft.azure.mobile.ingestion.http.IngestionCallDecorator;
import com.microsoft.azure.mobile.ingestion.http.IngestionDecorator;
import com.microsoft.azure.mobile.ingestion.models.LogContainer;
import com.microsoft.azure.mobile.utils.NetworkStateHelper;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;

public class IngestionNetworkStateHandler
extends IngestionDecorator
implements NetworkStateHelper.Listener {
    private final NetworkStateHelper mNetworkStateHelper;
    private final Set<Call> mCalls = new HashSet<Call>();

    public IngestionNetworkStateHandler(Ingestion decoratedApi, NetworkStateHelper networkStateHelper) {
        super(decoratedApi);
        this.mNetworkStateHelper = networkStateHelper;
        this.mNetworkStateHelper.addListener(this);
    }

    @Override
    public synchronized ServiceCall sendAsync(String appSecret, UUID installId, LogContainer logContainer, ServiceCallback serviceCallback) throws IllegalArgumentException {
        Call ingestionCall = new Call(this.mDecoratedApi, appSecret, installId, logContainer, serviceCallback);
        this.mCalls.add(ingestionCall);
        if (this.mNetworkStateHelper.isNetworkConnected()) {
            ingestionCall.run();
        }
        return ingestionCall;
    }

    @Override
    public synchronized void close() throws IOException {
        this.mNetworkStateHelper.removeListener(this);
        for (Call call : this.mCalls) {
            this.pauseCall(call);
        }
        this.mCalls.clear();
        super.close();
    }

    @Override
    public synchronized void onNetworkStateUpdated(boolean connected) {
        for (Call call : this.mCalls) {
            if (connected) {
                call.run();
                continue;
            }
            this.pauseCall(call);
        }
    }

    private synchronized void callRunAsync(Call call) {
        call.mServiceCall = call.mDecoratedApi.sendAsync(call.mAppSecret, call.mInstallId, call.mLogContainer, call);
    }

    private synchronized void cancelCall(Call call) {
        this.mCalls.remove(call);
        this.pauseCall(call);
    }

    private synchronized void pauseCall(Call call) {
        if (call.mServiceCall != null) {
            call.mServiceCall.cancel();
        }
    }

    private synchronized void onCallSucceeded(Call call) {
        if (this.mCalls.contains(call)) {
            call.mServiceCallback.onCallSucceeded();
            this.mCalls.remove(call);
        }
    }

    private synchronized void onCallFailed(Call call, Exception e) {
        if (this.mCalls.contains(call)) {
            call.mServiceCallback.onCallFailed(e);
            this.mCalls.remove(call);
        }
    }

    private class Call
    extends IngestionCallDecorator
    implements Runnable,
    ServiceCallback {
        Call(Ingestion decoratedApi, String appSecret, UUID installId, LogContainer logContainer, ServiceCallback serviceCallback) {
            super(decoratedApi, appSecret, installId, logContainer, serviceCallback);
        }

        @Override
        public void run() {
            IngestionNetworkStateHandler.this.callRunAsync(this);
        }

        @Override
        public void cancel() {
            IngestionNetworkStateHandler.this.cancelCall(this);
        }

        @Override
        public void onCallSucceeded() {
            IngestionNetworkStateHandler.this.onCallSucceeded(this);
        }

        @Override
        public void onCallFailed(Exception e) {
            IngestionNetworkStateHandler.this.onCallFailed(this, e);
        }
    }
}

