/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.mobile.ingestion.http;

import android.support.annotation.VisibleForTesting;
import com.microsoft.azure.mobile.ingestion.http.HttpException;
import java.io.EOFException;
import java.io.InterruptedIOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Locale;
import java.util.concurrent.RejectedExecutionException;
import java.util.regex.Pattern;
import javax.net.ssl.SSLException;

public final class HttpUtils {
    private static final Class[] RECOVERABLE_EXCEPTIONS = new Class[]{EOFException.class, InterruptedIOException.class, SocketException.class, UnknownHostException.class, RejectedExecutionException.class};
    private static final Pattern CONNECTION_ISSUE_PATTERN = Pattern.compile("connection (time|reset)|failure in ssl library, usually a protocol error");

    @VisibleForTesting
    HttpUtils() {
    }

    public static boolean isRecoverableError(Throwable t) {
        String message;
        if (t instanceof HttpException) {
            HttpException exception = (HttpException)t;
            int code = exception.getStatusCode();
            return code >= 500 || code == 408 || code == 429 || code == 401;
        }
        for (Class type : RECOVERABLE_EXCEPTIONS) {
            if (!type.isAssignableFrom(t.getClass())) continue;
            return true;
        }
        return t instanceof SSLException && (message = t.getMessage()) != null && CONNECTION_ISSUE_PATTERN.matcher(message.toLowerCase(Locale.US)).find();
    }
}

