/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.mobile.persistence;

import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.microsoft.azure.mobile.ingestion.models.Log;
import com.microsoft.azure.mobile.ingestion.models.json.LogSerializer;
import java.io.Closeable;
import java.util.List;

public abstract class Persistence
implements Closeable {
    static final int DEFAULT_CAPACITY = 300;
    private LogSerializer mLogSerializer;

    public abstract void putLog(@NonNull String var1, @NonNull Log var2) throws PersistenceException;

    public abstract void deleteLogs(@NonNull String var1, @NonNull String var2);

    public abstract void deleteLogs(String var1);

    public abstract int countLogs(@NonNull String var1);

    @Nullable
    public abstract String getLogs(@NonNull String var1, @IntRange(from=0L) int var2, @NonNull List<Log> var3);

    public abstract void clearPendingLogState();

    public abstract void clear();

    LogSerializer getLogSerializer() {
        if (this.mLogSerializer == null) {
            throw new IllegalStateException("logSerializer not configured");
        }
        return this.mLogSerializer;
    }

    public void setLogSerializer(@NonNull LogSerializer logSerializer) {
        this.mLogSerializer = logSerializer;
    }

    public static class PersistenceException
    extends Exception {
        public PersistenceException(String detailMessage, Throwable throwable) {
            super(detailMessage, throwable);
        }
    }
}

