/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.mobile.ingestion.http;

import com.microsoft.azure.mobile.ingestion.Ingestion;
import com.microsoft.azure.mobile.ingestion.ServiceCall;
import com.microsoft.azure.mobile.ingestion.ServiceCallback;
import com.microsoft.azure.mobile.ingestion.http.IngestionCallDecorator;
import com.microsoft.azure.mobile.ingestion.http.IngestionDecorator;
import com.microsoft.azure.mobile.ingestion.models.LogContainer;
import com.microsoft.azure.mobile.utils.NetworkStateHelper;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;

public class IngestionNetworkStateHandler
extends IngestionDecorator
implements NetworkStateHelper.Listener {
    private final NetworkStateHelper mNetworkStateHelper;
    private final Set<Call> mCalls = new HashSet<Call>();

    public IngestionNetworkStateHandler(Ingestion decoratedApi, NetworkStateHelper networkStateHelper) {
        super(decoratedApi);
        this.mNetworkStateHelper = networkStateHelper;
        this.mNetworkStateHelper.addListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceCall sendAsync(String appSecret, UUID installId, LogContainer logContainer, ServiceCallback serviceCallback) throws IllegalArgumentException {
        Call ingestionCall = new Call(this.mDecoratedApi, appSecret, installId, logContainer, serviceCallback);
        Set<Call> set = this.mCalls;
        synchronized (set) {
            this.mCalls.add(ingestionCall);
            if (this.mNetworkStateHelper.isNetworkConnected()) {
                ingestionCall.run();
            }
        }
        return ingestionCall;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.mNetworkStateHelper.removeListener(this);
        Set<Call> set = this.mCalls;
        synchronized (set) {
            for (Call call : this.mCalls) {
                call.pauseCall();
            }
            this.mCalls.clear();
        }
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNetworkStateUpdated(boolean connected) {
        Set<Call> set = this.mCalls;
        synchronized (set) {
            for (Call call : this.mCalls) {
                if (connected) {
                    call.run();
                    continue;
                }
                call.pauseCall();
            }
        }
    }

    private class Call
    extends IngestionCallDecorator
    implements Runnable,
    ServiceCallback {
        Call(Ingestion decoratedApi, String appSecret, UUID installId, LogContainer logContainer, ServiceCallback serviceCallback) {
            super(decoratedApi, appSecret, installId, logContainer, serviceCallback);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Set set = IngestionNetworkStateHandler.this.mCalls;
            synchronized (set) {
                this.mServiceCall = this.mDecoratedApi.sendAsync(this.mAppSecret, this.mInstallId, this.mLogContainer, this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel() {
            Set set = IngestionNetworkStateHandler.this.mCalls;
            synchronized (set) {
                IngestionNetworkStateHandler.this.mCalls.remove(this);
                this.pauseCall();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void pauseCall() {
            Set set = IngestionNetworkStateHandler.this.mCalls;
            synchronized (set) {
                if (this.mServiceCall != null) {
                    this.mServiceCall.cancel();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCallSucceeded() {
            Set set = IngestionNetworkStateHandler.this.mCalls;
            synchronized (set) {
                if (IngestionNetworkStateHandler.this.mCalls.contains(this)) {
                    super.onCallSucceeded();
                    IngestionNetworkStateHandler.this.mCalls.remove(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCallFailed(Exception e) {
            Set set = IngestionNetworkStateHandler.this.mCalls;
            synchronized (set) {
                if (IngestionNetworkStateHandler.this.mCalls.contains(this)) {
                    this.mServiceCallback.onCallFailed(e);
                    IngestionNetworkStateHandler.this.mCalls.remove(this);
                }
            }
        }
    }
}

