/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.mobile;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.Context;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import com.microsoft.azure.mobile.Constants;
import com.microsoft.azure.mobile.MobileCenterService;
import com.microsoft.azure.mobile.channel.Channel;
import com.microsoft.azure.mobile.channel.DefaultChannel;
import com.microsoft.azure.mobile.ingestion.models.WrapperSdk;
import com.microsoft.azure.mobile.ingestion.models.json.DefaultLogSerializer;
import com.microsoft.azure.mobile.ingestion.models.json.LogFactory;
import com.microsoft.azure.mobile.ingestion.models.json.LogSerializer;
import com.microsoft.azure.mobile.utils.DeviceInfoHelper;
import com.microsoft.azure.mobile.utils.IdHelper;
import com.microsoft.azure.mobile.utils.MobileCenterLog;
import com.microsoft.azure.mobile.utils.storage.StorageHelper;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public final class MobileCenter {
    public static final String LOG_TAG = "MobileCenter";
    @SuppressLint(value={"StaticFieldLeak"})
    private static MobileCenter sInstance;
    private boolean mLogLevelConfigured;
    private String mServerUrl;
    private Application mApplication;
    private Set<MobileCenterService> mServices;
    private LogSerializer mLogSerializer;
    private Channel mChannel;

    @VisibleForTesting
    static synchronized MobileCenter getInstance() {
        if (sInstance == null) {
            sInstance = new MobileCenter();
        }
        return sInstance;
    }

    @VisibleForTesting
    static synchronized void unsetInstance() {
        sInstance = null;
    }

    public static void setWrapperSdk(WrapperSdk wrapperSdk) {
        MobileCenter.getInstance().setInstanceWrapperSdk(wrapperSdk);
    }

    @IntRange(from=2L, to=7L)
    public static int getLogLevel() {
        return MobileCenterLog.getLogLevel();
    }

    public static void setLogLevel(@IntRange(from=2L, to=8L) int logLevel) {
        MobileCenter.getInstance().setInstanceLogLevel(logLevel);
    }

    public static void setServerUrl(String serverUrl) {
        MobileCenter.getInstance().setInstanceServerUrl(serverUrl);
    }

    public static boolean isConfigured() {
        return MobileCenter.getInstance().isInstanceConfigured();
    }

    public static void configure(Application application, String appSecret) {
        MobileCenter.getInstance().instanceConfigure(application, appSecret);
    }

    @SafeVarargs
    public static void start(Class<? extends MobileCenterService> ... services) {
        MobileCenter.getInstance().startServices(services);
    }

    @SafeVarargs
    public static void start(Application application, String appSecret, Class<? extends MobileCenterService> ... services) {
        MobileCenter.getInstance().configureAndStartServices(application, appSecret, services);
    }

    public static boolean isEnabled() {
        return MobileCenter.checkPrecondition("isEnabled") && MobileCenter.getInstance().isInstanceEnabled();
    }

    public static void setEnabled(boolean enabled) {
        if (MobileCenter.checkPrecondition("setEnabled")) {
            MobileCenter.getInstance().setInstanceEnabled(enabled);
        }
    }

    public static UUID getInstallId() {
        if (MobileCenter.checkPrecondition("getInstallId")) {
            return IdHelper.getInstallId();
        }
        return null;
    }

    private static boolean checkPrecondition(String methodName) {
        if (MobileCenter.getInstance().isInstanceConfigured()) {
            return true;
        }
        MobileCenterLog.error(LOG_TAG, "Mobile Center has not been configured and is not ready for " + methodName);
        return false;
    }

    private synchronized void setInstanceWrapperSdk(WrapperSdk wrapperSdk) {
        DeviceInfoHelper.setWrapperSdk(wrapperSdk);
        if (this.mChannel != null) {
            this.mChannel.invalidateDeviceCache();
        }
    }

    private synchronized void setInstanceLogLevel(int logLevel) {
        this.mLogLevelConfigured = true;
        MobileCenterLog.setLogLevel(logLevel);
    }

    private synchronized void setInstanceServerUrl(String serverUrl) {
        this.mServerUrl = serverUrl;
        if (this.mChannel != null) {
            this.mChannel.setServerUrl(serverUrl);
        }
    }

    private synchronized boolean isInstanceConfigured() {
        return this.mApplication != null;
    }

    private synchronized boolean instanceConfigure(Application application, String appSecret) {
        Constants.loadFromContext((Context)application);
        if (!this.mLogLevelConfigured && Constants.APPLICATION_DEBUGGABLE) {
            MobileCenterLog.setLogLevel(5);
        }
        if (this.mApplication != null) {
            MobileCenterLog.warn(LOG_TAG, "Mobile Center may only be configured once");
            return false;
        }
        if (application == null) {
            MobileCenterLog.error(LOG_TAG, "application may not be null");
        } else if (appSecret == null || appSecret.isEmpty()) {
            MobileCenterLog.error(LOG_TAG, "appSecret may not be null or empty");
        } else {
            this.mApplication = application;
            StorageHelper.initialize((Context)application);
            this.mServices = new HashSet<MobileCenterService>();
            this.mLogSerializer = new DefaultLogSerializer();
            this.mChannel = new DefaultChannel((Context)application, appSecret, this.mLogSerializer);
            this.mChannel.setEnabled(this.isInstanceEnabled());
            if (this.mServerUrl != null) {
                this.mChannel.setServerUrl(this.mServerUrl);
            }
            MobileCenterLog.logAssert(LOG_TAG, "Mobile Center SDK configured successfully.");
            return true;
        }
        MobileCenterLog.logAssert(LOG_TAG, "Mobile Center SDK configuration failed.");
        return false;
    }

    @SafeVarargs
    private final synchronized void startServices(Class<? extends MobileCenterService> ... services) {
        if (services == null) {
            MobileCenterLog.error(LOG_TAG, "Cannot start services, services array is null. Failed to start services.");
            return;
        }
        if (this.mApplication == null) {
            String serviceNames = "";
            for (Class<? extends MobileCenterService> service : services) {
                serviceNames = serviceNames + "\t" + service.getName() + "\n";
            }
            MobileCenterLog.error(LOG_TAG, "Cannot start services, Mobile Center has not been configured. Failed to start the following services:\n" + serviceNames);
            return;
        }
        for (Class<? extends MobileCenterService> service : services) {
            if (service == null) {
                MobileCenterLog.warn(LOG_TAG, "Skipping null service, please check your varargs/array does not contain any null reference.");
                continue;
            }
            try {
                this.startService((MobileCenterService)service.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]));
            }
            catch (Exception e) {
                MobileCenterLog.error(LOG_TAG, "Failed to get service instance '" + service.getName() + "', skipping it.", e);
            }
        }
    }

    private synchronized void startService(@NonNull MobileCenterService service) {
        if (this.mServices.contains(service)) {
            MobileCenterLog.warn(LOG_TAG, "Mobile Center has already started the service with class name: " + service.getClass().getName());
            return;
        }
        Map<String, LogFactory> logFactories = service.getLogFactories();
        if (logFactories != null) {
            for (Map.Entry<String, LogFactory> logFactory : logFactories.entrySet()) {
                this.mLogSerializer.addLogFactory(logFactory.getKey(), logFactory.getValue());
            }
        }
        this.mServices.add(service);
        service.onChannelReady((Context)this.mApplication, this.mChannel);
        if (this.isInstanceEnabled()) {
            this.mApplication.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)service);
        }
        MobileCenterLog.info(LOG_TAG, service.getClass().getSimpleName() + " service started.");
    }

    @SafeVarargs
    private final synchronized void configureAndStartServices(Application application, String appSecret, Class<? extends MobileCenterService> ... services) {
        boolean configuredSuccessfully = this.instanceConfigure(application, appSecret);
        if (configuredSuccessfully) {
            this.startServices(services);
        }
    }

    private synchronized boolean isInstanceEnabled() {
        return StorageHelper.PreferencesStorage.getBoolean("enabled", true);
    }

    private synchronized void setInstanceEnabled(boolean enabled) {
        this.mChannel.setEnabled(enabled);
        boolean previouslyEnabled = this.isInstanceEnabled();
        boolean switchToDisabled = previouslyEnabled && !enabled;
        boolean switchToEnabled = !previouslyEnabled && enabled;
        StorageHelper.PreferencesStorage.putBoolean("enabled", enabled);
        for (MobileCenterService service : this.mServices) {
            if (switchToDisabled) {
                this.mApplication.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)service);
            } else if (switchToEnabled) {
                this.mApplication.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)service);
            }
            if (service.isInstanceEnabled() == enabled) continue;
            service.setInstanceEnabled(enabled);
        }
        if (switchToDisabled) {
            MobileCenterLog.info(LOG_TAG, "Mobile Center has been disabled.");
        } else if (switchToEnabled) {
            MobileCenterLog.info(LOG_TAG, "Mobile Center has been enabled.");
        } else {
            MobileCenterLog.info(LOG_TAG, "Mobile Center has already been " + (enabled ? "enabled" : "disabled") + ".");
        }
    }

    @VisibleForTesting
    Set<MobileCenterService> getServices() {
        return this.mServices;
    }

    @VisibleForTesting
    Application getApplication() {
        return this.mApplication;
    }

    @VisibleForTesting
    void setChannel(Channel channel) {
        this.mChannel = channel;
    }
}

