/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.mobile.persistence;

import android.content.ContentValues;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.microsoft.azure.mobile.ingestion.models.Log;
import com.microsoft.azure.mobile.persistence.Persistence;
import com.microsoft.azure.mobile.utils.MobileCenterLog;
import com.microsoft.azure.mobile.utils.UUIDUtils;
import com.microsoft.azure.mobile.utils.storage.StorageHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.json.JSONException;

public class DatabasePersistence
extends Persistence {
    @VisibleForTesting
    static final String COLUMN_GROUP = "persistence_group";
    private static final String COLUMN_LOG = "log";
    private static final String DATABASE = "com.microsoft.azure.mobile.persistence";
    private static final String TABLE = "logs";
    private static final ContentValues SCHEMA = DatabasePersistence.getContentValues("", "");
    final StorageHelper.DatabaseStorage mDatabaseStorage;
    private final Map<String, List<Long>> mPendingDbIdentifiersGroups = new HashMap<String, List<Long>>();
    private final Set<Long> mPendingDbIdentifiers = new HashSet<Long>();

    public DatabasePersistence() {
        this(DATABASE, TABLE, 1);
    }

    DatabasePersistence(String database, String table, int version) {
        this(database, table, version, 300);
    }

    DatabasePersistence(String database, String table, int version, int maxRecords) {
        this.mDatabaseStorage = StorageHelper.DatabaseStorage.getDatabaseStorage(database, table, version, SCHEMA, maxRecords, new StorageHelper.DatabaseStorage.DatabaseErrorListener(){

            @Override
            public void onError(String operation, RuntimeException e) {
                MobileCenterLog.error("MobileCenter", "Cannot complete an operation (" + operation + ")", e);
            }
        });
    }

    private static ContentValues getContentValues(@Nullable String group, @Nullable String logJ) {
        ContentValues values = new ContentValues();
        values.put(COLUMN_GROUP, group);
        values.put(COLUMN_LOG, logJ);
        return values;
    }

    @Override
    public void putLog(@NonNull String group, @NonNull Log log) throws Persistence.PersistenceException {
        try {
            MobileCenterLog.debug("MobileCenter", "Storing a log to the Persistence database for log type " + log.getType() + " with " + log.getSid());
            this.mDatabaseStorage.put(DatabasePersistence.getContentValues(group, this.getLogSerializer().serializeLog(log)));
        }
        catch (JSONException e) {
            throw new Persistence.PersistenceException("Cannot convert to JSON string", e);
        }
    }

    @Override
    public void deleteLogs(@NonNull String group, @NonNull String id) {
        MobileCenterLog.info("MobileCenter", "Deleting logs from the Persistence database for " + group + " with " + id);
        MobileCenterLog.debug("MobileCenter", "The IDs for deleting log(s) is/are:");
        List<Long> dbIdentifiers = this.mPendingDbIdentifiersGroups.remove(group + id);
        if (dbIdentifiers != null) {
            for (Long dbIdentifier : dbIdentifiers) {
                MobileCenterLog.debug("MobileCenter", "\t" + dbIdentifier);
                this.mDatabaseStorage.delete(dbIdentifier);
                this.mPendingDbIdentifiers.remove(dbIdentifier);
            }
        }
    }

    @Override
    public void deleteLogs(String group) {
        MobileCenterLog.info("MobileCenter", "Deleting all logs from the Persistence database for " + group);
        this.mDatabaseStorage.delete(COLUMN_GROUP, group);
        Iterator<String> iterator = this.mPendingDbIdentifiersGroups.keySet().iterator();
        while (iterator.hasNext()) {
            String key = iterator.next();
            if (!key.startsWith(group)) continue;
            iterator.remove();
        }
    }

    @Override
    public int countLogs(@NonNull String group) {
        StorageHelper.DatabaseStorage.DatabaseScanner scanner = this.mDatabaseStorage.getScanner(COLUMN_GROUP, group);
        int count = scanner.getCount();
        scanner.close();
        return count;
    }

    @Override
    @Nullable
    public String getLogs(@NonNull String group, @IntRange(from=0L) int limit, @NonNull List<Log> outLogs) {
        MobileCenterLog.info("MobileCenter", "Trying to get " + limit + " logs from the Persistence database for " + group);
        StorageHelper.DatabaseStorage.DatabaseScanner scanner = this.mDatabaseStorage.getScanner(COLUMN_GROUP, group);
        int count = 0;
        TreeMap<Long, Log> candidates = new TreeMap<Long, Log>();
        ArrayList<Long> failedDbIdentifiers = new ArrayList<Long>();
        Iterator<ContentValues> iterator = scanner.iterator();
        while (iterator.hasNext() && count < limit) {
            ContentValues values = iterator.next();
            Long dbIdentifier = values.getAsLong("oid");
            if (this.mPendingDbIdentifiers.contains(dbIdentifier)) continue;
            try {
                candidates.put(dbIdentifier, this.getLogSerializer().deserializeLog(values.getAsString(COLUMN_LOG)));
                ++count;
            }
            catch (JSONException e) {
                MobileCenterLog.error("MobileCenter", "Cannot deserialize a log in the database", e);
                failedDbIdentifiers.add(dbIdentifier);
            }
        }
        scanner.close();
        if (failedDbIdentifiers.size() > 0) {
            this.mDatabaseStorage.delete(failedDbIdentifiers);
            MobileCenterLog.info("MobileCenter", "Deleted logs that cannot be deserialized");
        }
        if (candidates.size() <= 0) {
            MobileCenterLog.info("MobileCenter", "No logs found in the Persistence database at the moment");
            return null;
        }
        String id = UUIDUtils.randomUUID().toString();
        MobileCenterLog.info("MobileCenter", "Returning " + candidates.size() + " log(s) with an ID, " + id);
        MobileCenterLog.debug("MobileCenter", "The SID/ID pairs for returning log(s) is/are:");
        ArrayList<Long> pendingDbIdentifiersGroup = new ArrayList<Long>();
        for (Map.Entry entry : candidates.entrySet()) {
            Long dbIdentifier = (Long)entry.getKey();
            this.mPendingDbIdentifiers.add(dbIdentifier);
            pendingDbIdentifiersGroup.add(dbIdentifier);
            outLogs.add((Log)entry.getValue());
            MobileCenterLog.debug("MobileCenter", "\t" + ((Log)entry.getValue()).getSid() + " / " + dbIdentifier);
        }
        this.mPendingDbIdentifiersGroups.put(group + id, pendingDbIdentifiersGroup);
        return id;
    }

    @Override
    public void clearPendingLogState() {
        this.mPendingDbIdentifiers.clear();
        this.mPendingDbIdentifiersGroups.clear();
        MobileCenterLog.info("MobileCenter", "Cleared pending log states");
    }

    @Override
    public void clear() {
        this.clearPendingLogState();
        this.mDatabaseStorage.clear();
        MobileCenterLog.info("MobileCenter", "Deleted logs from the Persistence database");
    }

    @Override
    public void close() throws IOException {
        this.mDatabaseStorage.close();
    }

    @VisibleForTesting
    Map<String, List<Long>> getPendingDbIdentifiersGroups() {
        return this.mPendingDbIdentifiersGroups;
    }
}

