/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.mobile.ingestion.models;

import android.support.annotation.VisibleForTesting;
import com.microsoft.azure.mobile.ingestion.models.Device;
import com.microsoft.azure.mobile.ingestion.models.Log;
import com.microsoft.azure.mobile.ingestion.models.json.JSONUtils;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONStringer;

public abstract class AbstractLog
implements Log {
    @VisibleForTesting
    static final String SID = "sid";
    @VisibleForTesting
    static final String DEVICE = "device";
    private static final String TOFFSET = "toffset";
    private long toffset;
    private UUID sid;
    private Device device;

    @Override
    public long getToffset() {
        return this.toffset;
    }

    @Override
    public void setToffset(long toffset) {
        this.toffset = toffset;
    }

    @Override
    public UUID getSid() {
        return this.sid;
    }

    @Override
    public void setSid(UUID sid) {
        this.sid = sid;
    }

    @Override
    public Device getDevice() {
        return this.device;
    }

    @Override
    public void setDevice(Device device) {
        this.device = device;
    }

    @Override
    public void write(JSONStringer writer) throws JSONException {
        JSONUtils.write(writer, "type", this.getType());
        JSONUtils.write(writer, TOFFSET, this.getToffset());
        JSONUtils.write(writer, SID, this.getSid());
        if (this.getDevice() != null) {
            writer.key(DEVICE).object();
            this.getDevice().write(writer);
            writer.endObject();
        }
    }

    @Override
    public void read(JSONObject object) throws JSONException {
        if (!object.getString("type").equals(this.getType())) {
            throw new JSONException("Invalid type");
        }
        this.setToffset(object.getLong(TOFFSET));
        if (object.has(SID)) {
            this.setSid(UUID.fromString(object.getString(SID)));
        }
        if (object.has(DEVICE)) {
            Device device = new Device();
            device.read(object.getJSONObject(DEVICE));
            this.setDevice(device);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractLog that = (AbstractLog)o;
        if (this.toffset != that.toffset) {
            return false;
        }
        if (this.sid != null ? !this.sid.equals(that.sid) : that.sid != null) {
            return false;
        }
        return this.device != null ? this.device.equals(that.device) : that.device == null;
    }

    public int hashCode() {
        int result = (int)(this.toffset ^ this.toffset >>> 32);
        result = 31 * result + (this.sid != null ? this.sid.hashCode() : 0);
        result = 31 * result + (this.device != null ? this.device.hashCode() : 0);
        return result;
    }
}

