/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.mobile;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import com.microsoft.azure.mobile.MobileCenter;
import com.microsoft.azure.mobile.MobileCenterService;
import com.microsoft.azure.mobile.channel.Channel;
import com.microsoft.azure.mobile.ingestion.models.json.LogFactory;
import com.microsoft.azure.mobile.utils.MobileCenterLog;
import com.microsoft.azure.mobile.utils.storage.StorageHelper;
import java.util.Map;

public abstract class AbstractMobileCenterService
implements MobileCenterService {
    private static final String PREFERENCE_KEY_SEPARATOR = "_";
    private static final int DEFAULT_TRIGGER_COUNT = 50;
    private static final int DEFAULT_TRIGGER_INTERVAL = 3000;
    private static final int DEFAULT_TRIGGER_MAX_PARALLEL_REQUESTS = 3;
    protected Channel mChannel;

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityResumed(Activity activity) {
    }

    public void onActivityPaused(Activity activity) {
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
    }

    @Override
    public synchronized boolean isInstanceEnabled() {
        return StorageHelper.PreferencesStorage.getBoolean(this.getEnabledPreferenceKey(), true);
    }

    @Override
    public synchronized void setInstanceEnabled(boolean enabled) {
        if (!MobileCenter.isEnabled() && enabled) {
            MobileCenterLog.error("MobileCenter", "The SDK is disabled. Call MobileCenter.setEnabled(true) first before enabling a specific service.");
            return;
        }
        if (enabled == this.isInstanceEnabled()) {
            return;
        }
        if (this.mChannel != null) {
            if (enabled) {
                this.mChannel.addGroup(this.getGroupName(), this.getTriggerCount(), this.getTriggerInterval(), this.getTriggerMaxParallelRequests(), this.getChannelListener());
            } else {
                this.mChannel.clear(this.getGroupName());
                this.mChannel.removeGroup(this.getGroupName());
            }
        }
        StorageHelper.PreferencesStorage.putBoolean(this.getEnabledPreferenceKey(), enabled);
    }

    @Override
    public synchronized void onChannelReady(@NonNull Context context, @NonNull Channel channel) {
        channel.removeGroup(this.getGroupName());
        if (this.isInstanceEnabled()) {
            channel.addGroup(this.getGroupName(), this.getTriggerCount(), this.getTriggerInterval(), this.getTriggerMaxParallelRequests(), this.getChannelListener());
        } else {
            channel.clear(this.getGroupName());
        }
        this.mChannel = channel;
    }

    @Override
    public Map<String, LogFactory> getLogFactories() {
        return null;
    }

    protected abstract String getGroupName();

    protected abstract String getServiceName();

    @NonNull
    protected String getEnabledPreferenceKey() {
        return "enabled_" + this.getGroupName();
    }

    protected int getTriggerCount() {
        return 50;
    }

    protected int getTriggerInterval() {
        return 3000;
    }

    protected int getTriggerMaxParallelRequests() {
        return 3;
    }

    protected Channel.GroupListener getChannelListener() {
        return null;
    }

    protected synchronized boolean isInactive() {
        if (this.mChannel == null) {
            MobileCenterLog.error("MobileCenter", this.getServiceName() + " service not initialized, discarding calls.");
            return true;
        }
        if (!this.isInstanceEnabled()) {
            MobileCenterLog.info("MobileCenter", this.getServiceName() + " service not enabled, discarding calls.");
            return true;
        }
        return false;
    }
}

