/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.mobile.utils.crypto;

import android.annotation.SuppressLint;
import android.content.Context;
import android.security.KeyPairGeneratorSpec;
import android.support.annotation.RequiresApi;
import com.microsoft.azure.mobile.utils.crypto.CryptoHandler;
import com.microsoft.azure.mobile.utils.crypto.CryptoUtils;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.cert.CertificateExpiredException;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Calendar;
import java.util.Date;
import javax.security.auth.x500.X500Principal;

@RequiresApi(value=19)
class CryptoRsaHandler
implements CryptoHandler {
    CryptoRsaHandler() {
    }

    @Override
    public String getAlgorithm() {
        return "RSA/ECB/PKCS1Padding/2048";
    }

    @Override
    @SuppressLint(value={"InlinedApi", "TrulyRandom"})
    public void generateKey(CryptoUtils.ICryptoFactory cryptoFactory, String alias, Context context) throws Exception {
        Calendar writeExpiry = Calendar.getInstance();
        writeExpiry.add(1, 1);
        KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA", "AndroidKeyStore");
        generator.initialize((AlgorithmParameterSpec)new KeyPairGeneratorSpec.Builder(context).setAlias(alias).setSubject(new X500Principal("CN=" + alias)).setStartDate(new Date()).setEndDate(writeExpiry.getTime()).setSerialNumber(BigInteger.TEN).setKeySize(2048).build());
        generator.generateKeyPair();
    }

    private CryptoUtils.ICipher getCipher(CryptoUtils.ICryptoFactory cipherFactory, int apiLevel) throws Exception {
        String provider = apiLevel >= 23 ? "AndroidKeyStoreBCWorkaround" : "AndroidOpenSSL";
        return cipherFactory.getCipher("RSA/ECB/PKCS1Padding", provider);
    }

    @Override
    public byte[] encrypt(CryptoUtils.ICryptoFactory cryptoFactory, int apiLevel, KeyStore.Entry keyStoreEntry, byte[] input) throws Exception {
        CryptoUtils.ICipher cipher = this.getCipher(cryptoFactory, apiLevel);
        KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)keyStoreEntry;
        X509Certificate certificate = (X509Certificate)privateKeyEntry.getCertificate();
        try {
            certificate.checkValidity();
        }
        catch (CertificateExpiredException e) {
            throw new InvalidKeyException(e);
        }
        cipher.init(1, certificate.getPublicKey());
        return cipher.doFinal(input);
    }

    @Override
    public byte[] decrypt(CryptoUtils.ICryptoFactory cryptoFactory, int apiLevel, KeyStore.Entry keyStoreEntry, byte[] data) throws Exception {
        CryptoUtils.ICipher cipher = this.getCipher(cryptoFactory, apiLevel);
        cipher.init(2, ((KeyStore.PrivateKeyEntry)keyStoreEntry).getPrivateKey());
        return cipher.doFinal(data);
    }
}

