/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.mobile.utils;

import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class HashUtils {
    private static final char[] HEXADECIMAL_OUTPUT = "0123456789abcdef".toCharArray();

    @VisibleForTesting
    HashUtils() {
    }

    @NonNull
    public static String sha256(@NonNull String data) {
        return HashUtils.sha256(data, "UTF-8");
    }

    @NonNull
    @VisibleForTesting
    static String sha256(@NonNull String data, String charsetName) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(data.getBytes(charsetName));
            return HashUtils.encodeHex(digest.digest());
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    @NonNull
    private static String encodeHex(@NonNull byte[] bytes) {
        char[] output = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            output[j * 2] = HEXADECIMAL_OUTPUT[v >>> 4];
            output[j * 2 + 1] = HEXADECIMAL_OUTPUT[v & 0xF];
        }
        return new String(output);
    }
}

