/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.mobile.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Point;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.view.Display;
import android.view.WindowManager;
import com.microsoft.azure.mobile.ingestion.models.Device;
import com.microsoft.azure.mobile.ingestion.models.WrapperSdk;
import com.microsoft.azure.mobile.utils.MobileCenterLog;
import java.util.Locale;
import java.util.TimeZone;

public class DeviceInfoHelper {
    private static final String OS_NAME = "Android";
    private static WrapperSdk sWrapperSdk;

    public static synchronized Device getDeviceInfo(Context context) throws DeviceInfoException {
        Device device = new Device();
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            device.setAppVersion(packageInfo.versionName);
            device.setAppBuild(String.valueOf(packageInfo.versionCode));
        }
        catch (Exception e) {
            MobileCenterLog.error("MobileCenter", "Cannot retrieve package info", e);
            throw new DeviceInfoException("Cannot retrieve package info", e);
        }
        device.setAppNamespace(context.getPackageName());
        try {
            String networkOperatorName;
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            String networkCountryIso = telephonyManager.getNetworkCountryIso();
            if (!TextUtils.isEmpty((CharSequence)networkCountryIso)) {
                device.setCarrierCountry(networkCountryIso);
            }
            if (!TextUtils.isEmpty((CharSequence)(networkOperatorName = telephonyManager.getNetworkOperatorName()))) {
                device.setCarrierName(networkOperatorName);
            }
        }
        catch (Exception e) {
            MobileCenterLog.error("MobileCenter", "Cannot retrieve carrier info", e);
        }
        device.setLocale(Locale.getDefault().toString());
        device.setModel(Build.MODEL);
        device.setOemName(Build.MANUFACTURER);
        device.setOsApiLevel(Build.VERSION.SDK_INT);
        device.setOsName(OS_NAME);
        device.setOsVersion(Build.VERSION.RELEASE);
        device.setOsBuild(Build.ID);
        try {
            device.setScreenSize(DeviceInfoHelper.getScreenSize(context));
        }
        catch (Exception e) {
            MobileCenterLog.error("MobileCenter", "Cannot retrieve screen size", e);
        }
        device.setSdkName("mobilecenter.android");
        device.setSdkVersion("0.12.0");
        device.setTimeZoneOffset(TimeZone.getDefault().getOffset(System.currentTimeMillis()) / 60 / 1000);
        if (sWrapperSdk != null) {
            device.setWrapperSdkVersion(sWrapperSdk.getWrapperSdkVersion());
            device.setWrapperSdkName(sWrapperSdk.getWrapperSdkName());
            device.setWrapperRuntimeVersion(sWrapperSdk.getWrapperRuntimeVersion());
            device.setLiveUpdateReleaseLabel(sWrapperSdk.getLiveUpdateReleaseLabel());
            device.setLiveUpdateDeploymentKey(sWrapperSdk.getLiveUpdateDeploymentKey());
            device.setLiveUpdatePackageHash(sWrapperSdk.getLiveUpdatePackageHash());
        }
        return device;
    }

    @SuppressLint(value={"SwitchIntDef"})
    private static String getScreenSize(Context context) {
        int screenWidth;
        int screenHeight;
        Display defaultDisplay = ((WindowManager)context.getSystemService("window")).getDefaultDisplay();
        Point size = new Point();
        defaultDisplay.getSize(size);
        switch (defaultDisplay.getRotation()) {
            case 1: 
            case 3: {
                screenHeight = size.x;
                screenWidth = size.y;
                break;
            }
            default: {
                screenWidth = size.x;
                screenHeight = size.y;
            }
        }
        return screenWidth + "x" + screenHeight;
    }

    public static synchronized void setWrapperSdk(WrapperSdk wrapperSdk) {
        sWrapperSdk = wrapperSdk;
    }

    public static class DeviceInfoException
    extends Exception {
        public DeviceInfoException(String detailMessage, Throwable throwable) {
            super(detailMessage, throwable);
        }
    }
}

