/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.mobile.ingestion.models;

import com.microsoft.azure.mobile.ingestion.models.AbstractLog;
import com.microsoft.azure.mobile.ingestion.models.json.JSONUtils;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONStringer;

public class StartServiceLog
extends AbstractLog {
    public static final String TYPE = "start_service";
    private static final String SERVICES = "services";
    private List<String> services;

    @Override
    public String getType() {
        return TYPE;
    }

    public List<String> getServices() {
        return this.services;
    }

    public void setServices(List<String> services) {
        this.services = services;
    }

    @Override
    public void read(JSONObject object) throws JSONException {
        super.read(object);
        this.setServices(JSONUtils.readStringArray(object, SERVICES));
    }

    @Override
    public void write(JSONStringer writer) throws JSONException {
        super.write(writer);
        JSONUtils.writeStringArray(writer, SERVICES, this.getServices());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StartServiceLog that = (StartServiceLog)o;
        return this.services != null ? this.services.equals(that.services) : that.services == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.services != null ? this.services.hashCode() : 0);
        return result;
    }
}

